/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.trace.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import sun.plugin2.applet.Applet2Manager;

public class Applet2ManagerCache {
    private int cacheSize = Integer.getInteger("javaplugin.lifecycle.cachesize", 4);
    private List entries = new LinkedList();
    private Timer memoryPressureTimer = new Timer();
    private TimerTask currentTask = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Applet2Manager get(String string, Map map) {
        if (map.get("legacy_lifecycle") == null) {
            return null;
        }
        String string2 = this.getCacheKey(string, map);
        Applet2ManagerCache applet2ManagerCache = this;
        synchronized (applet2ManagerCache) {
            Iterator iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (!entry.getKey().equals(string2)) continue;
                iterator.remove();
                Trace.msgPrintln((String)"lifecycle.applet.found");
                return entry.getManager();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Applet2Manager applet2Manager) {
        String string = applet2Manager.getLegacyLifeCycleCacheKey();
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Entry entry = new Entry(string, applet2Manager);
        Applet2ManagerCache applet2ManagerCache = this;
        synchronized (applet2ManagerCache) {
            Trace.msgPrintln((String)"lifecycle.applet.support");
            this.entries.add(0, entry);
            while (this.entries.size() > this.cacheSize) {
                Entry entry2 = (Entry)this.entries.remove(this.entries.size() - 1);
                arrayList.add(entry2);
            }
        }
        if (arrayList.size() > 0) {
            Trace.msgPrintln((String)"lifecycle.applet.cachefull");
            Applet2ManagerCache.destroy(arrayList);
        }
        this.startWatchdog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Applet2ManagerCache applet2ManagerCache = this;
        synchronized (applet2ManagerCache) {
            return this.entries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList arrayList = new ArrayList();
        Applet2ManagerCache applet2ManagerCache = this;
        synchronized (applet2ManagerCache) {
            arrayList.addAll(this.entries);
            this.entries.clear();
        }
        Applet2ManagerCache.destroy(arrayList);
        this.stopWatchdog();
    }

    public String getCacheKey(String string, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append("<NAME=_documentBase VALUE=");
            stringBuffer.append(string);
            stringBuffer.append(">");
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (string2 == null || string3 == null) continue;
            stringBuffer.append("<NAME=");
            stringBuffer.append(string2);
            stringBuffer.append(" VALUE=");
            stringBuffer.append(string3);
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    private static void destroy(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).getManager().destroy();
        }
    }

    private synchronized void startWatchdog() {
        if (this.currentTask == null) {
            this.currentTask = new WatchdogTask();
            long l = Applet2ManagerCache.getTimerPeriod(Applet2ManagerCache.getMemoryPressure());
            this.memoryPressureTimer.schedule(this.currentTask, l, l);
        }
    }

    private synchronized void stopWatchdog() {
        if (this.currentTask != null) {
            this.currentTask.cancel();
            this.currentTask = null;
        }
    }

    private static float getMemoryPressure() {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        if (l == Long.MAX_VALUE) {
            return 0.0f;
        }
        long l2 = runtime.totalMemory();
        long l3 = l2 - runtime.freeMemory();
        float f = (float)((double)l3 / (double)l);
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private static long getTimerPeriod(float f) {
        if (f < 0.5f) {
            return 30000L;
        }
        if (f < 0.75f) {
            return 15000L;
        }
        return 5000L;
    }

    class WatchdogTask
    extends TimerTask {
        private long period = Applet2ManagerCache.access$100(Applet2ManagerCache.access$000());

        WatchdogTask() {
        }

        public void run() {
            float f = Applet2ManagerCache.getMemoryPressure();
            if (f > 0.9f) {
                Applet2ManagerCache.this.clear();
            }
            if (Applet2ManagerCache.getTimerPeriod(Applet2ManagerCache.getMemoryPressure()) != this.period) {
                Applet2ManagerCache.this.stopWatchdog();
                Applet2ManagerCache.this.startWatchdog();
            }
        }
    }

    class Entry {
        private String key;
        private Applet2Manager manager;

        Entry(String string, Applet2Manager applet2Manager) {
            this.key = string;
            this.manager = applet2Manager;
        }

        public String getKey() {
            return this.key;
        }

        public Applet2Manager getManager() {
            return this.manager;
        }
    }
}

