/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.support;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ResourceLoader resourceLoader;
    private PathMatcher pathMatcher = new AntPathMatcher();

    public PathMatchingResourcePatternResolver() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public PathMatchingResourcePatternResolver(ClassLoader classLoader) {
        this.resourceLoader = new DefaultResourceLoader(classLoader);
    }

    public PathMatchingResourcePatternResolver(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassLoader getClassLoader() {
        return this.getResourceLoader().getClassLoader();
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull(pathMatcher, "PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public Resource getResource(String string) {
        return this.getResourceLoader().getResource(string);
    }

    public Resource[] getResources(String string) throws IOException {
        Assert.notNull(string, "Location pattern must not be null");
        if (string.startsWith("classpath*:")) {
            if (this.getPathMatcher().isPattern(string.substring("classpath*:".length()))) {
                return this.findPathMatchingResources(string);
            }
            return this.findAllClassPathResources(string.substring("classpath*:".length()));
        }
        int n = string.indexOf(":") + 1;
        if (this.getPathMatcher().isPattern(string.substring(n))) {
            return this.findPathMatchingResources(string);
        }
        return new Resource[]{this.getResourceLoader().getResource(string)};
    }

    protected Resource[] findAllClassPathResources(String string) throws IOException {
        String string2 = string;
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        Enumeration<URL> enumeration = this.getClassLoader().getResources(string2);
        Set set = CollectionFactory.createLinkedSetIfPossible(16);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            set.add(this.convertClassLoaderURL(uRL));
        }
        return set.toArray(new Resource[set.size()]);
    }

    protected Resource convertClassLoaderURL(URL uRL) {
        return new UrlResource(uRL);
    }

    protected Resource[] findPathMatchingResources(String string) throws IOException {
        String string2 = this.determineRootDir(string);
        String string3 = string.substring(string2.length());
        Resource[] resourceArray = this.getResources(string2);
        Set set = CollectionFactory.createLinkedSetIfPossible(16);
        for (int i = 0; i < resourceArray.length; ++i) {
            Resource resource = resourceArray[i];
            if (this.isJarResource(resource)) {
                set.addAll(this.doFindPathMatchingJarResources(resource, string3));
                continue;
            }
            set.addAll(this.doFindPathMatchingFileResources(resource, string3));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Resolved location pattern [" + string + "] to resources " + set));
        }
        return set.toArray(new Resource[set.size()]);
    }

    protected String determineRootDir(String string) {
        int n = string.indexOf(":") + 1;
        int n2 = string.length();
        while (n2 > n && this.getPathMatcher().isPattern(string.substring(n, n2))) {
            n2 = string.lastIndexOf(47, n2 - 2) + 1;
        }
        if (n2 == 0) {
            n2 = n;
        }
        return string.substring(0, n2);
    }

    protected boolean isJarResource(Resource resource) throws IOException {
        return ResourceUtils.isJarURL(resource.getURL());
    }

    protected Set doFindPathMatchingJarResources(Resource resource, String string) throws IOException {
        Object object;
        Object object2;
        URLConnection uRLConnection = resource.getURL().openConnection();
        JarFile jarFile = null;
        String string2 = null;
        String string3 = null;
        if (uRLConnection instanceof JarURLConnection) {
            object2 = (JarURLConnection)uRLConnection;
            jarFile = ((JarURLConnection)object2).getJarFile();
            string2 = ((JarURLConnection)object2).getJarFileURL().toExternalForm();
            object = ((JarURLConnection)object2).getJarEntry();
            string3 = object != null ? ((ZipEntry)object).getName() : "";
        } else {
            int n;
            object2 = resource.getURL().getFile();
            string2 = ((String)object2).substring(0, n = ((String)object2).indexOf("!/"));
            if (string2.startsWith("file:")) {
                string2 = string2.substring("file:".length());
            }
            jarFile = new JarFile(string2);
            string2 = "file:" + string2;
            string3 = ((String)object2).substring(n + "!/".length());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for matching resources in jar file [" + string2 + "]"));
        }
        if (!"".equals(string3) && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        object2 = CollectionFactory.createLinkedSetIfPossible(8);
        object = jarFile.entries();
        while (object.hasMoreElements()) {
            JarEntry jarEntry = (JarEntry)object.nextElement();
            String string4 = jarEntry.getName();
            if (!string4.startsWith(string3)) continue;
            String string5 = string4.substring(string3.length());
            if (!this.getPathMatcher().match(string, string5)) continue;
            object2.add(resource.createRelative(string5));
        }
        return object2;
    }

    protected Set doFindPathMatchingFileResources(Resource resource, String string) throws IOException {
        File file = null;
        try {
            file = resource.getFile().getAbsoluteFile();
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Cannot search for matching files underneath " + resource + " because it does not correspond to a directory in the file system"), (Throwable)iOException);
            }
            return Collections.EMPTY_SET;
        }
        return this.doFindMatchingFileSystemResources(file, string);
    }

    protected Set doFindMatchingFileSystemResources(File file, String string) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for matching resources in directory tree [" + file.getPath() + "]"));
        }
        Set set = this.retrieveMatchingFiles(file, string);
        Set set2 = CollectionFactory.createLinkedSetIfPossible(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            File file2 = (File)iterator.next();
            set2.add(new FileSystemResource(file2));
        }
        return set2;
    }

    protected Set retrieveMatchingFiles(File file, String string) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Resource path [" + file + "] does not denote a directory");
        }
        String string2 = StringUtils.replace(file.getAbsolutePath(), File.separator, "/");
        if (!string.startsWith("/")) {
            string2 = string2 + "/";
        }
        string2 = string2 + StringUtils.replace(string, File.separator, "/");
        Set set = CollectionFactory.createLinkedSetIfPossible(8);
        this.doRetrieveMatchingFiles(string2, file, set);
        return set;
    }

    protected void doRetrieveMatchingFiles(String string, File file, Set set) throws IOException {
        File[] fileArray;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searching directory [" + file.getAbsolutePath() + "] for files matching pattern [" + string + "]"));
        }
        if ((fileArray = file.listFiles()) == null) {
            throw new IOException("Could not retrieve contents of directory [" + file.getAbsolutePath() + "]");
        }
        boolean bl = string.indexOf("**") != -1;
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = StringUtils.replace(fileArray[i].getAbsolutePath(), File.separator, "/");
            if (fileArray[i].isDirectory() && (bl || StringUtils.countOccurrencesOf(string2, "/") < StringUtils.countOccurrencesOf(string, "/"))) {
                this.doRetrieveMatchingFiles(string, fileArray[i], set);
            }
            if (!this.getPathMatcher().match(string, string2)) continue;
            set.add(fileArray[i]);
        }
    }
}

