/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Window;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.quantum.GlassStage;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class GlassWindowEventHandler
extends Window.EventHandler
implements PrivilegedAction<Void> {
    private final GlassStage stage;
    private Window window;
    private long time;
    private int type;

    public GlassWindowEventHandler(GlassStage glassStage) {
        this.stage = glassStage;
    }

    @Override
    public Void run() {
        if (this.stage == null || this.stage.stageListener == null) {
            return null;
        }
        switch (this.type) {
            case 531: {
                this.stage.stageListener.changedIconified(true);
                break;
            }
            case 532: {
                break;
            }
            case 533: {
                this.stage.stageListener.changedIconified(false);
                break;
            }
            case 512: {
                this.stage.stageListener.changedLocation(this.window.getX(), this.window.getY());
                break;
            }
            case 511: {
                this.stage.stageListener.changedSize(this.window.getWidth(), this.window.getHeight());
                break;
            }
            case 542: {
                GlassStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.ACTIVATED);
                break;
            }
            case 541: {
                this.stage.stageListener.changedFocused(false, FocusCause.DEACTIVATED);
                break;
            }
            case 546: {
                this.stage.stageListener.focusUngrab();
                break;
            }
            case 543: {
                GlassStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_FORWARD);
                break;
            }
            case 544: {
                GlassStage.addActiveWindow(this.stage);
                this.stage.stageListener.changedFocused(true, FocusCause.TRAVERSED_BACKWARD);
                break;
            }
            case 545: {
                this.stage.handleFocusDisabled();
                break;
            }
            case 522: {
                this.stage.setPlatformWindowClosed();
                this.stage.stageListener.closed();
                break;
            }
            case 521: {
                this.stage.stageListener.closing();
            }
        }
        return null;
    }

    @Override
    public void handleWindowEvent(Window window, long l, int n) {
        this.window = window;
        this.time = l;
        this.type = n;
        AccessControlContext accessControlContext = this.stage.getAccessControlContext();
        AccessController.doPrivileged(this, accessControlContext);
    }
}

