/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

final class PropertyMatches {
    public static final int DEFAULT_MAX_DISTANCE = 2;
    private final String propertyName;
    private String[] possibleMatches;

    public static PropertyMatches forProperty(String string, Class clazz) {
        return PropertyMatches.forProperty(string, clazz, 2);
    }

    public static PropertyMatches forProperty(String string, Class clazz, int n) {
        return new PropertyMatches(string, clazz, n);
    }

    private PropertyMatches(String string, Class clazz, int n) {
        this.propertyName = string;
        this.possibleMatches = this.calculateMatches(BeanUtils.getPropertyDescriptors(clazz), n);
    }

    public String[] getPossibleMatches() {
        return this.possibleMatches;
    }

    public String buildErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Bean property '");
        stringBuffer.append(this.propertyName);
        stringBuffer.append("' is not writable or has an invalid setter method. ");
        if (ObjectUtils.isEmpty((Object[])this.possibleMatches)) {
            stringBuffer.append("Does the parameter type of the setter match the return type of the getter?");
        } else {
            stringBuffer.append("Did you mean ");
            for (int i = 0; i < this.possibleMatches.length; ++i) {
                stringBuffer.append('\'');
                stringBuffer.append(this.possibleMatches[i]);
                if (i < this.possibleMatches.length - 2) {
                    stringBuffer.append("', ");
                    continue;
                }
                if (i != this.possibleMatches.length - 2) continue;
                stringBuffer.append("', or ");
            }
            stringBuffer.append("'?");
        }
        return stringBuffer.toString();
    }

    private String[] calculateMatches(PropertyDescriptor[] propertyDescriptorArray, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            String string;
            if (propertyDescriptorArray[i].getWriteMethod() == null || this.calculateStringDistance(this.propertyName, string = propertyDescriptorArray[i].getName()) > n) continue;
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        return StringUtils.toStringArray(arrayList);
    }

    private int calculateStringDistance(String string, String string2) {
        int n;
        if (string.length() == 0) {
            return string2.length();
        }
        if (string2.length() == 0) {
            return string.length();
        }
        int[][] nArray = new int[string.length() + 1][string2.length() + 1];
        for (n = 0; n <= string.length(); ++n) {
            nArray[n][0] = n;
        }
        for (n = 0; n <= string2.length(); ++n) {
            nArray[0][n] = n;
        }
        for (n = 1; n <= string.length(); ++n) {
            char c = string.charAt(n - 1);
            for (int i = 1; i <= string2.length(); ++i) {
                char c2 = string2.charAt(i - 1);
                int n2 = c == c2 ? 0 : 1;
                nArray[n][i] = Math.min(Math.min(nArray[n - 1][i] + 1, nArray[n][i - 1] + 1), nArray[n - 1][i - 1] + n2);
            }
        }
        return nArray[string.length()][string2.length()];
    }
}

