/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.FactoryBeanNotInitializedException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public abstract class AbstractFactoryBean
implements FactoryBean,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean singleton = true;
    private BeanFactory beanFactory;
    private boolean initialized = false;
    private Object singletonInstance;
    private Object earlySingletonInstance;

    public void setSingleton(boolean bl) {
        this.singleton = bl;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    protected TypeConverter getBeanTypeConverter() {
        BeanFactory beanFactory = this.getBeanFactory();
        if (beanFactory instanceof ConfigurableBeanFactory) {
            return ((ConfigurableBeanFactory)beanFactory).getTypeConverter();
        }
        return new SimpleTypeConverter();
    }

    public void afterPropertiesSet() throws Exception {
        if (this.isSingleton()) {
            this.initialized = true;
            this.singletonInstance = this.createInstance();
            this.earlySingletonInstance = null;
        }
    }

    public final Object getObject() throws Exception {
        if (this.isSingleton()) {
            return this.initialized ? this.singletonInstance : this.getEarlySingletonInstance();
        }
        return this.createInstance();
    }

    private Object getEarlySingletonInstance() throws Exception {
        Class[] classArray = this.getEarlySingletonInterfaces();
        if (classArray == null) {
            throw new FactoryBeanNotInitializedException(this.getClass().getName() + " does not support circular references");
        }
        if (this.earlySingletonInstance == null) {
            this.earlySingletonInstance = Proxy.newProxyInstance(this.getClass().getClassLoader(), classArray, new InvocationHandler(){

                public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                    try {
                        return method.invoke(AbstractFactoryBean.this.getSingletonInstance(), objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getTargetException();
                    }
                }
            });
        }
        return this.earlySingletonInstance;
    }

    private Object getSingletonInstance() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("Singleton instance not initialized yet");
        }
        return this.singletonInstance;
    }

    public void destroy() throws Exception {
        if (this.isSingleton()) {
            this.destroyInstance(this.singletonInstance);
        }
    }

    public abstract Class getObjectType();

    protected abstract Object createInstance() throws Exception;

    protected Class[] getEarlySingletonInterfaces() {
        Class[] classArray;
        Class clazz = this.getObjectType();
        if (clazz != null && clazz.isInterface()) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = clazz;
        } else {
            classArray = null;
        }
        return classArray;
    }

    protected void destroyInstance(Object object) throws Exception {
    }
}

