/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.Assert;

class DisposableBeanAdapter
implements DisposableBean,
Runnable,
Serializable {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$support$DisposableBeanAdapter == null ? (class$org$springframework$beans$factory$support$DisposableBeanAdapter = DisposableBeanAdapter.class$("org.springframework.beans.factory.support.DisposableBeanAdapter")) : class$org$springframework$beans$factory$support$DisposableBeanAdapter));
    private final Object bean;
    private final String beanName;
    private final String destroyMethodName;
    private final boolean enforceDestroyMethod;
    private List beanPostProcessors;
    static /* synthetic */ Class class$org$springframework$beans$factory$support$DisposableBeanAdapter;

    public DisposableBeanAdapter(Object object, String string, RootBeanDefinition rootBeanDefinition, List list) {
        Assert.notNull((Object)object, (String)"Bean must not be null");
        this.bean = object;
        this.beanName = string;
        this.destroyMethodName = rootBeanDefinition.getDestroyMethodName();
        this.enforceDestroyMethod = rootBeanDefinition.isEnforceDestroyMethod();
        this.beanPostProcessors = this.filterPostProcessors(list);
    }

    private DisposableBeanAdapter(Object object, String string, String string2, boolean bl, List list) {
        this.bean = object;
        this.beanName = string;
        this.destroyMethodName = string2;
        this.enforceDestroyMethod = bl;
        this.beanPostProcessors = list;
    }

    private List filterPostProcessors(List list) {
        ArrayList arrayList = null;
        if (list != null && !list.isEmpty()) {
            arrayList = new ArrayList(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof DestructionAwareBeanPostProcessor)) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public void run() {
        this.destroy();
    }

    public void destroy() {
        if (this.beanPostProcessors != null && !this.beanPostProcessors.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Applying DestructionAwareBeanPostProcessors to bean with name '" + this.beanName + "'"));
            }
            for (int i = this.beanPostProcessors.size() - 1; i >= 0; --i) {
                ((DestructionAwareBeanPostProcessor)this.beanPostProcessors.get(i)).postProcessBeforeDestruction(this.bean, this.beanName);
            }
        }
        if (this.bean instanceof DisposableBean) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Invoking destroy() on bean with name '" + this.beanName + "'"));
            }
            try {
                ((DisposableBean)this.bean).destroy();
            }
            catch (Throwable throwable) {
                logger.error((Object)("Couldn't invoke destroy method of bean with name '" + this.beanName + "'"), throwable);
            }
        }
        if (this.destroyMethodName != null) {
            this.invokeCustomDestroyMethod();
        }
    }

    private void invokeCustomDestroyMethod() {
        if (this.destroyMethodName != null) {
            try {
                Method method = BeanUtils.findMethodWithMinimalParameters(this.bean.getClass(), this.destroyMethodName);
                if (method == null) {
                    if (this.enforceDestroyMethod) {
                        logger.error((Object)("Couldn't find a destroy method named '" + this.destroyMethodName + "' on bean with name '" + this.beanName + "'"));
                    }
                } else {
                    Class<?>[] classArray = method.getParameterTypes();
                    if (classArray.length > 1) {
                        logger.error((Object)("Method '" + this.destroyMethodName + "' of bean '" + this.beanName + "' has more than one parameter - not supported as destroy method"));
                    } else if (classArray.length == 1 && !classArray[0].equals(Boolean.TYPE)) {
                        logger.error((Object)("Method '" + this.destroyMethodName + "' of bean '" + this.beanName + "' has a non-boolean parameter - not supported as destroy method"));
                    } else {
                        Object[] objectArray = new Object[classArray.length];
                        if (classArray.length == 1) {
                            objectArray[0] = Boolean.TRUE;
                        }
                        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                            method.setAccessible(true);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Invoking custom destroy method on bean with name '" + this.beanName + "'"));
                        }
                        try {
                            method.invoke(this.bean, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            logger.error((Object)("Couldn't invoke destroy method '" + this.destroyMethodName + "' of bean with name '" + this.beanName + "'"), invocationTargetException.getTargetException());
                        }
                        catch (Throwable throwable) {
                            logger.error((Object)("Couldn't invoke destroy method '" + this.destroyMethodName + "' of bean with name '" + this.beanName + "'"), throwable);
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)("Couldn't find a unique destroy method on bean with name '" + this.beanName + ": " + illegalArgumentException.getMessage()));
            }
        }
    }

    protected Object writeReplace() {
        ArrayList arrayList = null;
        if (this.beanPostProcessors != null) {
            arrayList = new ArrayList();
            Iterator iterator = this.beanPostProcessors.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Serializable)) continue;
                arrayList.add(e);
            }
        }
        return new DisposableBeanAdapter(this.bean, this.beanName, this.destroyMethodName, this.enforceDestroyMethod, arrayList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

