/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.util;

import cn.com.voltronic.solar.configure.EmailConfig;
import cn.com.voltronic.solar.util.SendMail;
import javax.mail.MessagingException;

public class EmailSendUtil {
    private String to;
    private String from;
    private String host;
    private int port;
    private String username;
    private String password;
    private Boolean needAuth = true;

    public EmailSendUtil(EmailConfig info) {
        this.host = info.getSmtp();
        this.port = info.getPort();
        this.username = info.getAccount();
        this.needAuth = info.getNeedAuth();
        this.password = info.getPassword();
        this.from = info.getSender();
    }

    public boolean sendMail(String to, String subject, String content) {
        boolean isSuccess = true;
        SendMail themail = new SendMail(this.host, this.port, true);
        themail.setNeedAuth(this.needAuth);
        try {
            themail.setSubject(subject);
            themail.setBody(content);
            themail.setTo(to);
            themail.setFrom(this.from);
            themail.setNamePass(this.username, this.password);
            themail.sendout();
        }
        catch (MessagingException e) {
            isSuccess = false;
        }
        if (isSuccess) {
            return true;
        }
        SendMail themail2 = new SendMail(this.host, this.port, false);
        themail2.setNeedAuth(this.needAuth);
        try {
            themail2.setSubject(subject);
            themail2.setBody(content);
            themail2.setTo(to);
            themail2.setFrom(this.from);
            themail2.setNamePass(this.username, this.password);
            themail2.sendout();
        }
        catch (MessagingException e) {
            return false;
        }
        return true;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getNeedAuth() {
        return this.needAuth;
    }

    public void setNeedAuth(Boolean needAuth) {
        this.needAuth = needAuth;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static void main(String[] args) {
        String mailbody = "hello java mail!";
        SendMail themail = new SendMail("voltronic.com.tw", 25, true);
        themail.setNeedAuth(true);
        try {
            themail.setSubject("test mail send");
            themail.setBody(mailbody);
            themail.setTo("lincoln_jia@voltronicpower.com.cn");
            themail.setFrom("lincoln_jia@voltronicpower.com.cn");
            themail.setNamePass("lincoln_jia", "admin111");
            themail.sendout();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }
}

