/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.DestructuringForm;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class ArrayLiteral
extends AstNode
implements DestructuringForm {
    private static final List<AstNode> NO_ELEMS = Collections.unmodifiableList(new ArrayList());
    private List<AstNode> elements;
    private int destructuringLength;
    private int skipCount;
    private boolean isDestructuring;

    public ArrayLiteral() {
        this.type = 65;
    }

    public ArrayLiteral(int n) {
        super(n);
        this.type = 65;
    }

    public ArrayLiteral(int n, int n2) {
        super(n, n2);
        this.type = 65;
    }

    public List<AstNode> getElements() {
        return this.elements != null ? this.elements : NO_ELEMS;
    }

    public void setElements(List<AstNode> list) {
        if (list == null) {
            this.elements = null;
        } else {
            if (this.elements != null) {
                this.elements.clear();
            }
            for (AstNode astNode : list) {
                this.addElement(astNode);
            }
        }
    }

    public void addElement(AstNode astNode) {
        this.assertNotNull(astNode);
        if (this.elements == null) {
            this.elements = new ArrayList<AstNode>();
        }
        this.elements.add(astNode);
        astNode.setParent(this);
    }

    public int getSize() {
        return this.elements == null ? 0 : this.elements.size();
    }

    public AstNode getElement(int n) {
        if (this.elements == null) {
            throw new IndexOutOfBoundsException("no elements");
        }
        return this.elements.get(n);
    }

    public int getDestructuringLength() {
        return this.destructuringLength;
    }

    public void setDestructuringLength(int n) {
        this.destructuringLength = n;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public void setSkipCount(int n) {
        this.skipCount = n;
    }

    @Override
    public void setIsDestructuring(boolean bl) {
        this.isDestructuring = bl;
    }

    @Override
    public boolean isDestructuring() {
        return this.isDestructuring;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("[");
        if (this.elements != null) {
            this.printList(this.elements, stringBuilder);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            for (AstNode astNode : this.getElements()) {
                astNode.visit(nodeVisitor);
            }
        }
    }
}

