/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.test;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;

public class TestComm {
    private InputStream input = null;
    private OutputStream output = null;
    private SerialPort serialPort;

    public TestComm(SerialPort serialPort) throws IOException, TooManyListenersException, UnsupportedCommOperationException {
        this.serialPort = serialPort;
        this.input = serialPort.getInputStream();
        this.output = serialPort.getOutputStream();
        this.serialPort.setSerialPortParams(2400, 8, 1, 0);
        this.serialPort.notifyOnDataAvailable(true);
        this.serialPort.notifyOnCTS(true);
        this.serialPort.notifyOnDSR(true);
    }

    public synchronized String excuteCommand(String command, boolean isResponse) {
        String returnValue;
        block7: {
            returnValue = "";
            try {
                try {
                    byte[] bytes = command.getBytes();
                    this.output.write(bytes);
                    this.output.write(13);
                    this.output.flush();
                    if (isResponse) {
                        long end = System.currentTimeMillis() + 3000L;
                        StringBuilder sb = new StringBuilder();
                        while (System.currentTimeMillis() < end) {
                            int ch = this.input.read();
                            if (ch <= 0) continue;
                            if (ch == 13) break;
                            sb.append((char)ch);
                        }
                        returnValue = sb.toString();
                        break block7;
                    }
                    returnValue = null;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.close();
                }
            }
            finally {
                this.close();
            }
        }
        return returnValue;
    }

    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serialPort != null) {
            try {
                this.serialPort.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        while (en.hasMoreElements()) {
            CommPortIdentifier portId = (CommPortIdentifier)en.nextElement();
            if (portId.getPortType() != 1 || !portId.getName().equalsIgnoreCase("COM5")) continue;
            System.out.println(portId.getName());
            try {
                SerialPort serialPort = (SerialPort)portId.open("Arista", 2400);
                TestComm comm = new TestComm(serialPort);
                comm.excuteCommand("QID", true);
                Thread.sleep(2000L);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

