/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.console.linux;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.debug.Debug;
import cn.com.voltronic.solar.socket.UdpClient;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.upgrade.StartUpgrade;
import cn.com.voltronic.solar.view.ConfigFrame;
import cn.com.voltronic.solar.view.MainJFrame;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Desktop;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;

public class LinuxConsoleTray
extends SolarPowerTray {
    private static final long serialVersionUID = -6566853073476480618L;
    public static PopupMenu popup;
    private MenuItem configItem;
    private Menu updateItem;
    public MenuItem updateOnline;
    public MenuItem updateByUser;
    private MenuItem openItem;
    private MenuItem exitItem;
    private CheckboxMenuItem debugItem;

    public LinuxConsoleTray() {
        try {
            this.initTray();
            String language = "en_US";
            try {
                language = GlobalVariables.globalConfig.getLanguage();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.changeLanguage(language);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initTray() throws AWTException {
        if (SystemTray.isSupported()) {
            try {
                this.tray = SystemTray.getSystemTray();
                popup = new PopupMenu();
                this.initMenu();
                String softwareName = GlobalVariables.customerConfig.getCustomerName();
                trayIcon = new TrayIcon(Constants.CONNECTEDIMG, softwareName, popup);
                this.addToSystemTray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addToSystemTray() {
        try {
            this.tray.remove(trayIcon);
            this.tray.add(trayIcon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public void initMenu() throws Exception {
        this.configItem = new MenuItem("Configuration");
        this.updateItem = new Menu("Software Upgrade");
        this.updateOnline = new MenuItem("Online Upgrade");
        this.updateByUser = new MenuItem("Manually Upgrade");
        this.updateItem.add(this.updateOnline);
        this.updateItem.add(this.updateByUser);
        this.openItem = new MenuItem("Open Monitor");
        this.exitItem = new MenuItem("Exit");
        this.debugItem = new CheckboxMenuItem("Debug");
        popup.add(this.configItem);
        popup.add(this.updateItem);
        popup.add(this.debugItem);
        popup.add("-");
        popup.add(this.openItem);
        popup.add("-");
        popup.add(this.exitItem);
        this.configItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigFrame.getInstance();
            }
        });
        this.updateOnline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpgrade start = new StartUpgrade();
                start.updateOnline();
            }
        });
        this.updateByUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpgrade start = new StartUpgrade();
                start.updateByUser();
            }
        });
        this.debugItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Debug.setDebug(true);
                    try {
                        Desktop.getDesktop().open(new File(Debug.URL));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                } else {
                    Debug.setDebug(false);
                }
            }
        });
        this.openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainJFrame.getNewInstance().setVisible(true);
                MainJFrame.getNewInstance().setState(0);
            }
        });
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UdpClient client = null;
                String port = "38694";
                try {
                    port = GlobalVariables.globalConfig.getUdpPort();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                try {
                    try {
                        client = new UdpClient("localhost", port);
                        client.send("(exit:myself");
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (client != null) {
                            client.disconnect();
                        }
                    }
                }
                finally {
                    if (client != null) {
                        client.disconnect();
                    }
                }
            }
        });
    }

    @Override
    public void refreshUpgrade(boolean online, boolean manually) {
        this.updateOnline.setEnabled(online);
        this.updateByUser.setEnabled(manually);
    }
}

