/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view.component;

import cn.com.voltronic.solar.view.component.DefaultGridBagTableModel;
import cn.com.voltronic.solar.view.component.GridBagModel;
import cn.com.voltronic.solar.view.component.GridBagTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GridBagTable
extends JTable {
    private static final long serialVersionUID = -2795793946785144254L;
    GridBagModel gridBagModel;

    public GridBagModel getGridBagModel() {
        return this.gridBagModel;
    }

    public void setGridBagModel(GridBagModel gridBagModel) {
        if (gridBagModel != null && gridBagModel != this.gridBagModel) {
            this.gridBagModel = gridBagModel;
        }
    }

    public GridBagTable(AbstractTableModel dm) {
        super(dm);
        this.getTableHeader().setReorderingAllowed(false);
        this.gridBagModel = new DefaultGridBagTableModel(dm);
        this.getTableHeader().setForeground(Color.white);
    }

    public void clearMergence() {
        if (this.gridBagModel != null) {
            this.gridBagModel.clearMergence();
        }
    }

    private void updateSubComponentUI(Object componentShell) {
        if (componentShell == null) {
            return;
        }
        Component component = null;
        if (componentShell instanceof Component) {
            component = (Component)componentShell;
        }
        if (componentShell instanceof DefaultCellEditor) {
            component = ((DefaultCellEditor)componentShell).getComponent();
        }
        if (component != null) {
            SwingUtilities.updateComponentTreeUI(component);
        }
    }

    @Override
    public void updateUI() {
        TableColumnModel cm = this.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            TableColumn aColumn = cm.getColumn(column);
            this.updateSubComponentUI(aColumn.getCellRenderer());
            this.updateSubComponentUI(aColumn.getCellEditor());
            this.updateSubComponentUI(aColumn.getHeaderRenderer());
            ++column;
        }
        Enumeration defaultRenderers = this.defaultRenderersByColumnClass.elements();
        while (defaultRenderers.hasMoreElements()) {
            this.updateSubComponentUI(defaultRenderers.nextElement());
        }
        Enumeration defaultEditors = this.defaultEditorsByColumnClass.elements();
        while (defaultEditors.hasMoreElements()) {
            this.updateSubComponentUI(defaultEditors.nextElement());
        }
        if (this.tableHeader != null && this.tableHeader.getParent() == null) {
            this.tableHeader.updateUI();
        }
        this.setUI(new GridBagTableUI());
    }

    public Rectangle getGridCellRect(int row, int column, boolean includeSpacing) {
        return super.getCellRect(row, column, includeSpacing);
    }

    @Override
    public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
        Rectangle cellRect = super.getCellRect(row, column, includeSpacing);
        int cols = this.gridBagModel.getColumnGrid(row, column);
        TableColumnModel cm = this.getColumnModel();
        int n = 1;
        while (n < cols) {
            cellRect.width += cm.getColumn(column + n).getWidth();
            ++n;
        }
        int rows = this.gridBagModel.getRowGrid(row, column);
        int n2 = 1;
        while (n2 < rows) {
            cellRect.height += this.getRowHeight(row + n2);
            ++n2;
        }
        return cellRect;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    public boolean mergeCells(int startRow, int endRow, int startColumn, int endColumn) {
        if (this.gridBagModel.mergeCells(startRow, endRow, startColumn, endColumn)) {
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean mergeCells(int[] rows, int[] columns) {
        if (this.gridBagModel.mergeCells(rows, columns)) {
            this.repaint();
            return true;
        }
        return false;
    }

    public boolean spliteCellAt(int row, int column) {
        if (this.gridBagModel.spliteCellAt(row, column)) {
            this.repaint();
            return true;
        }
        return false;
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.gridBagModel.getCellState(rowIndex, columnIndex) != -1) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        }
        int rowraw = rowIndex;
        int col = 0;
        while (col < this.getColumnCount()) {
            int status = this.gridBagModel.getCellState(rowIndex, col);
            if (status == -1 || status == 1) {
                columnIndex = col;
                break;
            }
            ++col;
        }
        int row = rowIndex;
        while (row >= 0) {
            int col2 = columnIndex;
            while (col2 >= 0) {
                Point p = this.gridBagModel.getGrid(row, col2);
                if (col2 + p.x > columnIndex && row + p.y > rowIndex) {
                    rowIndex = row;
                    columnIndex = col2;
                    break;
                }
                --col2;
            }
            --row;
        }
        row = rowIndex + 1;
        while (row < this.getRowCount()) {
            if (this.gridBagModel.getCellState(row, columnIndex) != -1) break;
            rowraw = row++;
        }
        super.changeSelection(rowIndex, columnIndex, toggle, extend);
        if (rowraw != rowIndex) {
            super.changeSelection(rowraw, 0, toggle, true);
        }
        this.repaint();
    }

    @Override
    public boolean editCellAt(int rowIndex, int columnIndex, EventObject e) {
        if (this.gridBagModel.getCellState(rowIndex, columnIndex) != -1) {
            return super.editCellAt(rowIndex, columnIndex, e);
        }
        int row = rowIndex;
        while (row >= 0) {
            int col = columnIndex;
            while (col >= 0) {
                Point p = this.gridBagModel.getGrid(row, col);
                if (col + p.x > columnIndex && row + p.y > rowIndex) {
                    rowIndex = row;
                    columnIndex = col;
                    break;
                }
                --col;
            }
            --row;
        }
        return super.editCellAt(rowIndex, columnIndex, e);
    }
}

