/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HighLow {
    public static final int OPEN = 0;
    public static final int CLOSE = 1;
    private Line2D line;
    private Rectangle2D bounds;
    private double open;
    private double close;
    private Stroke stroke;
    private Paint paint;
    private double tickSize = 2.0;

    public HighLow(double x, double high, double low) {
        this(x, high, low, high, low, new BasicStroke(), Color.blue);
    }

    public HighLow(double x, double high, double low, double open, double close) {
        this(x, high, low, open, close, new BasicStroke(), Color.blue);
    }

    public HighLow(double x, double high, double low, double open, double close, Stroke stroke, Paint paint) {
        this.line = new Line2D.Double(x, high, x, low);
        this.bounds = new Rectangle2D.Double(x - this.tickSize, high, 2.0 * this.tickSize, low - high);
        this.open = open;
        this.close = close;
        this.stroke = stroke;
        this.paint = paint;
    }

    public void setTickSize(double newSize) {
        this.tickSize = newSize;
    }

    public double getTickSize() {
        return this.tickSize;
    }

    public Line2D getLine() {
        return this.line;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public double getValue(int valueType) {
        if (valueType == 0) {
            return this.open;
        }
        return this.close;
    }

    public void setValue(int type, double value) {
        if (type == 0) {
            this.open = value;
        } else {
            this.close = value;
        }
    }

    public Line2D getOpenTickLine() {
        return this.getTickLine(this.getLine().getX1(), this.getValue(0), -1.0 * this.getTickSize());
    }

    public Line2D getCloseTickLine() {
        return this.getTickLine(this.getLine().getX1(), this.getValue(1), this.getTickSize());
    }

    private Line2D getTickLine(double x, double value, double width) {
        return new Line2D.Double(x, value, x + width, value);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Paint getPaint() {
        return this.paint;
    }
}

