/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import net.wimpi.modbus.Modbus;
import net.wimpi.modbus.io.ModbusTCPTransport;
import net.wimpi.modbus.io.ModbusTransport;

public class TCPMasterConnection {
    private Socket m_Socket;
    private int m_Timeout = 1000;
    private boolean m_Connected;
    private InetAddress m_Address;
    private int m_Port = 502;
    private ModbusTCPTransport m_ModbusTransport;

    public TCPMasterConnection(InetAddress adr) {
        this.m_Address = adr;
    }

    public synchronized void connect() throws Exception {
        if (!this.m_Connected) {
            if (Modbus.debug) {
                System.out.println("connect()");
            }
            this.m_Socket = new Socket(this.m_Address, this.m_Port);
            this.setTimeout(this.m_Timeout);
            this.prepareTransport();
            this.m_Connected = true;
        }
    }

    public void close() {
        if (this.m_Connected) {
            block3: {
                try {
                    this.m_ModbusTransport.close();
                }
                catch (IOException ex) {
                    if (!Modbus.debug) break block3;
                    System.out.println("close()");
                }
            }
            this.m_Connected = false;
        }
    }

    public ModbusTransport getModbusTransport() {
        return this.m_ModbusTransport;
    }

    private void prepareTransport() throws IOException {
        if (this.m_ModbusTransport == null) {
            this.m_ModbusTransport = new ModbusTCPTransport(this.m_Socket);
        } else {
            this.m_ModbusTransport.setSocket(this.m_Socket);
        }
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int timeout) {
        this.m_Timeout = timeout;
        if (this.m_Socket != null) {
            try {
                this.m_Socket.setSoTimeout(this.m_Timeout);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int port) {
        this.m_Port = port;
    }

    public InetAddress getAddress() {
        return this.m_Address;
    }

    public void setAddress(InetAddress adr) {
        this.m_Address = adr;
    }

    public boolean isConnected() {
        return this.m_Connected;
    }
}

