/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class SetOpResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private final NoPutResultSet leftSource;
    private final NoPutResultSet rightSource;
    private final Activation activation;
    private final int opType;
    private final boolean all;
    private final int resultSetNumber;
    private DataValueDescriptor[] prevCols;
    private int rightDuplicateCount;
    private ExecRow leftInputRow;
    private ExecRow rightInputRow;
    private final int[] intermediateOrderByColumns;
    private final int[] intermediateOrderByDirection;
    private final boolean[] intermediateOrderByNullsLow;
    private int rowsSeenLeft;
    private int rowsSeenRight;
    private int rowsReturned;

    SetOpResultSet(NoPutResultSet noPutResultSet, NoPutResultSet noPutResultSet2, Activation activation, int n, long l, double d, int n2, boolean bl, int n3, int n4, int n5) {
        super(activation, n, l, d);
        this.leftSource = noPutResultSet;
        this.rightSource = noPutResultSet2;
        this.activation = activation;
        this.resultSetNumber = n;
        this.opType = n2;
        this.all = bl;
        ExecPreparedStatement execPreparedStatement = activation.getPreparedStatement();
        this.intermediateOrderByColumns = (int[])execPreparedStatement.getSavedObject(n3);
        this.intermediateOrderByDirection = (int[])execPreparedStatement.getSavedObject(n4);
        this.intermediateOrderByNullsLow = (boolean[])execPreparedStatement.getSavedObject(n5);
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        this.leftSource.openCore();
        this.rightSource.openCore();
        this.rightInputRow = this.rightSource.getNextRowCore();
        if (this.rightInputRow != null) {
            ++this.rowsSeenRight;
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            while ((this.leftInputRow = this.leftSource.getNextRowCore()) != null) {
                ++this.rowsSeenLeft;
                DataValueDescriptor[] dataValueDescriptorArray = this.leftInputRow.getRowArray();
                if (!this.all) {
                    if (this.isDuplicate(dataValueDescriptorArray)) continue;
                    this.prevCols = this.leftInputRow.getRowArrayClone();
                }
                int n = 0;
                while (this.rightInputRow != null && (n = this.compare(dataValueDescriptorArray, this.rightInputRow.getRowArray())) > 0) {
                    this.rightInputRow = this.rightSource.getNextRowCore();
                    if (this.rightInputRow == null) continue;
                    ++this.rowsSeenRight;
                }
                if (this.rightInputRow == null || n < 0) {
                    if (this.opType != 2) continue;
                    break;
                }
                if (this.all) {
                    this.rightInputRow = this.rightSource.getNextRowCore();
                    if (this.rightInputRow != null) {
                        ++this.rowsSeenRight;
                    }
                }
                if (this.opType != 1) continue;
                break;
            }
        }
        this.setCurrentRow(this.leftInputRow);
        if (this.currentRow != null) {
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return this.currentRow;
    }

    private void advanceRightPastDuplicates(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        while ((this.rightInputRow = this.rightSource.getNextRowCore()) != null) {
            ++this.rowsSeenRight;
            if (this.compare(dataValueDescriptorArray, this.rightInputRow.getRowArray()) != 0) continue;
        }
    }

    private int compare(DataValueDescriptor[] dataValueDescriptorArray, DataValueDescriptor[] dataValueDescriptorArray2) throws StandardException {
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            int n = this.intermediateOrderByColumns[i];
            if (dataValueDescriptorArray[n].compare(1, dataValueDescriptorArray2[n], true, this.intermediateOrderByNullsLow[i], false)) {
                return -1 * this.intermediateOrderByDirection[i];
            }
            if (dataValueDescriptorArray[n].compare(2, dataValueDescriptorArray2[n], true, this.intermediateOrderByNullsLow[i], false)) continue;
            return this.intermediateOrderByDirection[i];
        }
        return 0;
    }

    private boolean isDuplicate(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        if (this.prevCols == null) {
            return false;
        }
        for (int i = 0; i < this.intermediateOrderByColumns.length; ++i) {
            int n = this.intermediateOrderByColumns[i];
            if (dataValueDescriptorArray[n].compare(2, this.prevCols[n], true, false)) continue;
            return false;
        }
        return true;
    }

    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.prevCols = null;
            this.leftSource.close();
            this.rightSource.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public void finish() throws StandardException {
        this.leftSource.finish();
        this.rightSource.finish();
        this.finishAndRTS();
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.leftSource.getTimeSpent(1) - this.rightSource.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.leftSource)).getRowLocation();
    }

    public int getOpType() {
        return this.opType;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public NoPutResultSet getLeftSourceInput() {
        return this.leftSource;
    }

    public NoPutResultSet getRightSourceInput() {
        return this.rightSource;
    }

    public int getRowsSeenLeft() {
        return this.rowsSeenLeft;
    }

    public int getRowsSeenRight() {
        return this.rowsSeenRight;
    }

    public int getRowsReturned() {
        return this.rowsReturned;
    }
}

