/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PluggableSchemaResolver
implements EntityResolver {
    public static final String DEFAULT_SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$xml$PluggableSchemaResolver == null ? (class$org$springframework$beans$factory$xml$PluggableSchemaResolver = PluggableSchemaResolver.class$("org.springframework.beans.factory.xml.PluggableSchemaResolver")) : class$org$springframework$beans$factory$xml$PluggableSchemaResolver));
    private final ClassLoader classLoader;
    private final Properties schemaMappings;
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$PluggableSchemaResolver;

    public PluggableSchemaResolver(ClassLoader classLoader) {
        this(classLoader, DEFAULT_SCHEMA_MAPPINGS_LOCATION);
    }

    public PluggableSchemaResolver(ClassLoader classLoader, String string) {
        Assert.hasText((String)string, (String)"'schemaMappingsLocation' must not be empty");
        this.classLoader = classLoader;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Loading schema mappings from [" + string + "]"));
        }
        try {
            this.schemaMappings = PropertiesLoaderUtils.loadAllProperties((String)string, (ClassLoader)classLoader);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loaded schema mappings: " + this.schemaMappings));
            }
        }
        catch (IOException iOException) {
            throw new FatalBeanException("Unable to load schema mappings from location [" + string + "]", iOException);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws IOException {
        String string3;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Trying to resolve XML entity with public id [" + string + "] and system id [" + string2 + "]"));
        }
        if (string2 != null && (string3 = this.schemaMappings.getProperty(string2)) != null) {
            ClassPathResource classPathResource = new ClassPathResource(string3, this.classLoader);
            InputSource inputSource = new InputSource(classPathResource.getInputStream());
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found XML schema [" + string2 + "] in classpath: " + string3));
            }
            return inputSource;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

