/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.URLConverter;
import com.sun.javafx.scene.layout.region.Repeat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.text.Font;

public class BackgroundImage {
    private final Image image;
    private final Repeat repeatX;
    private final Repeat repeatY;
    private final double left;
    private final double top;
    private final double right;
    private final double bottom;
    private final boolean proportionalHPos;
    private final boolean proportionalVPos;
    private final double width;
    private final double height;
    private final boolean proportionalWidth;
    private final boolean proportionalHeight;
    private final boolean contain;
    private final boolean cover;

    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return BackgroundImage.impl_CSS_STYLEABLES();
    }

    public Image getImage() {
        return this.image;
    }

    public Repeat getRepeatX() {
        return this.repeatX;
    }

    public Repeat getRepeatY() {
        return this.repeatY;
    }

    public double getLeft() {
        return this.left;
    }

    public double getTop() {
        return this.top;
    }

    public double getRight() {
        return this.right;
    }

    public double getBottom() {
        return this.bottom;
    }

    public boolean isProportionalHPos() {
        return this.proportionalHPos;
    }

    public boolean isProportionalVPos() {
        return this.proportionalVPos;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isProportionalWidth() {
        return this.proportionalWidth;
    }

    public boolean isProportionalHeight() {
        return this.proportionalHeight;
    }

    public boolean isContain() {
        return this.contain;
    }

    public boolean isCover() {
        return this.cover;
    }

    private BackgroundImage(Image image, Repeat repeat, Repeat repeat2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.image = image;
        this.repeatX = repeat;
        this.repeatY = repeat2;
        this.left = d4;
        this.top = d;
        this.right = d2;
        this.bottom = d3;
        this.width = d5;
        this.height = d6;
        this.proportionalHPos = bl;
        this.proportionalVPos = bl2;
        this.proportionalWidth = bl3;
        this.proportionalHeight = bl4;
        this.contain = bl5;
        this.cover = bl6;
    }

    public static final class BackgroundSizeConverter
    extends StyleConverter<ParsedValue[], BackgroundSize> {
        public static BackgroundSizeConverter getInstance() {
            return Holder.BACKGROUND_SIZE_CONVERTER;
        }

        private BackgroundSizeConverter() {
        }

        @Override
        public BackgroundSize convert(ParsedValue<ParsedValue[], BackgroundSize> parsedValue, Font font) {
            ParsedValue[] parsedValueArray = parsedValue.getValue();
            Size size = parsedValueArray[0] != null ? (Size)parsedValueArray[0].convert(font) : null;
            Size size2 = parsedValueArray[1] != null ? (Size)parsedValueArray[1].convert(font) : null;
            boolean bl = false;
            boolean bl2 = false;
            if (size != null) {
                boolean bl3 = bl = size.getUnits() == SizeUnits.PERCENT;
            }
            if (size2 != null) {
                bl2 = size2.getUnits() == SizeUnits.PERCENT;
            }
            double d = size != null ? size.pixels(font) : 0.0;
            double d2 = size2 != null ? size2.pixels(font) : 0.0;
            boolean bl4 = parsedValueArray[2] != null ? (Boolean)BooleanConverter.getInstance().convert(parsedValueArray[2], font) : false;
            boolean bl5 = parsedValueArray[3] != null ? (Boolean)BooleanConverter.getInstance().convert(parsedValueArray[3], font) : false;
            return new BackgroundSize(d, d2, bl, bl2, bl4, bl5);
        }

        public String toString() {
            return "BackgroundSizeConverter";
        }
    }

    public static final class LayeredBackgroundSizeConverter
    extends StyleConverter<ParsedValue<ParsedValue[], BackgroundSize>[], BackgroundSize[]> {
        public static LayeredBackgroundSizeConverter getInstance() {
            return Holder.LAYERED_BACKGROUND_SIZE_CONVERTER;
        }

        private LayeredBackgroundSizeConverter() {
        }

        @Override
        public BackgroundSize[] convert(ParsedValue<ParsedValue<ParsedValue[], BackgroundSize>[], BackgroundSize[]> parsedValue, Font font) {
            ParsedValue<ParsedValue[], BackgroundSize>[] parsedValueArray = parsedValue.getValue();
            BackgroundSize[] backgroundSizeArray = new BackgroundSize[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                backgroundSizeArray[i] = parsedValueArray[i].convert(font);
            }
            return backgroundSizeArray;
        }
    }

    public static final class BackgroundSize {
        public static final BackgroundSize AUTO_SIZE = new BackgroundSize(0.0, 0.0, true, true, false, false);
        public static final BackgroundSize COVER = new BackgroundSize(0.0, 0.0, true, true, true, false);
        public static final BackgroundSize CONTAIN = new BackgroundSize(0.0, 0.0, true, true, false, true);
        private final boolean proportionalWidth;
        private final boolean proportionalHeight;
        private final double width;
        private final double height;
        private final boolean cover;
        private final boolean contain;

        public BackgroundSize(double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.width = d;
            this.height = d2;
            this.proportionalWidth = bl;
            this.proportionalHeight = bl2;
            this.contain = bl4;
            this.cover = bl3;
        }

        private BackgroundSize() {
            this(0.0, 0.0, false, false, false, false);
        }

        public boolean isProportionalWidth() {
            return this.proportionalWidth;
        }

        public boolean isProportionalHeight() {
            return this.proportionalHeight;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isCover() {
            return this.cover;
        }

        public boolean isContain() {
            return this.contain;
        }
    }

    public static final class BackgroundPositionConverter
    extends StyleConverter<ParsedValue<?, Size>[], BackgroundPosition> {
        public static BackgroundPositionConverter getInstance() {
            return Holder.BACKGROUND_POSITION_CONVERTER;
        }

        private BackgroundPositionConverter() {
        }

        @Override
        public BackgroundPosition convert(ParsedValue<ParsedValue<?, Size>[], BackgroundPosition> parsedValue, Font font) {
            ParsedValue<?, Size>[] parsedValueArray = parsedValue.getValue();
            Size size = parsedValueArray[0].convert(font);
            Size size2 = parsedValueArray[1].convert(font);
            Size size3 = parsedValueArray[2].convert(font);
            Size size4 = parsedValueArray[3].convert(font);
            boolean bl = size3.getValue() > 0.0 && size3.getUnits() == SizeUnits.PERCENT || size.getUnits() == SizeUnits.PERCENT;
            boolean bl2 = size2.getValue() > 0.0 && size2.getUnits() == SizeUnits.PERCENT || size4.getUnits() == SizeUnits.PERCENT;
            double d = size != null ? size.pixels(font) : 0.0;
            double d2 = size2 != null ? size2.pixels(font) : 0.0;
            double d3 = size3 != null ? size3.pixels(font) : 0.0;
            double d4 = size4 != null ? size4.pixels(font) : 0.0;
            return new BackgroundPosition(d, d2, d3, d4, bl2, bl);
        }

        public String toString() {
            return "BackgroundPositionConverter";
        }
    }

    public static final class LayeredBackgroundPositionConverter
    extends StyleConverter<ParsedValue<ParsedValue<?, Size>[], BackgroundPosition>[], BackgroundPosition[]> {
        public static LayeredBackgroundPositionConverter getInstance() {
            return Holder.LAYERED_BACKGROUND_POSITION_CONVERTER;
        }

        private LayeredBackgroundPositionConverter() {
        }

        @Override
        public BackgroundPosition[] convert(ParsedValue<ParsedValue<ParsedValue<?, Size>[], BackgroundPosition>[], BackgroundPosition[]> parsedValue, Font font) {
            ParsedValue<ParsedValue<?, Size>[], BackgroundPosition>[] parsedValueArray = parsedValue.getValue();
            BackgroundPosition[] backgroundPositionArray = new BackgroundPosition[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                backgroundPositionArray[i] = parsedValueArray[i].convert(font);
            }
            return backgroundPositionArray;
        }

        public String toString() {
            return "LayeredBackgroundPositionConverter";
        }
    }

    public static final class BackgroundPosition {
        public static final Size ZERO_PERCENT = new Size(0.0, SizeUnits.PERCENT);
        public static final Size FIFTY_PERCENT = new Size(50.0, SizeUnits.PERCENT);
        public static final Size ONE_HUNDRED_PERCENT = new Size(100.0, SizeUnits.PERCENT);
        private final double top;
        private final double right;
        private final double bottom;
        private final double left;
        private boolean proportionalHPos;
        private boolean proportionalVPos;

        private BackgroundPosition() {
            this(0.0, 0.0, 0.0, 0.0, false, false);
        }

        public double getTop() {
            return this.top;
        }

        public double getRight() {
            return this.right;
        }

        public double getBottom() {
            return this.bottom;
        }

        public double getLeft() {
            return this.left;
        }

        public boolean isProportionalHPos() {
            return this.proportionalHPos;
        }

        public boolean isProportionalVPos() {
            return this.proportionalVPos;
        }

        public BackgroundPosition(double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
            this.top = d;
            this.right = d2;
            this.bottom = d3;
            this.left = d4;
            this.proportionalHPos = bl;
            this.proportionalVPos = bl2;
        }
    }

    public static final class BackgroundRepeat {
        private final Repeat repeatX;
        private final Repeat repeatY;

        public BackgroundRepeat(Repeat repeat, Repeat repeat2) {
            this.repeatX = repeat;
            this.repeatY = repeat2;
        }

        public Repeat getRepeatX() {
            return this.repeatX;
        }

        public Repeat getRepeatY() {
            return this.repeatY;
        }
    }

    public static final class BackgroundRepeatConverter
    extends StyleConverter<ParsedValue<String, Repeat>[][], BackgroundRepeat[]> {
        private final EnumConverter<Repeat> converter = new EnumConverter(Repeat.class);

        public static BackgroundRepeatConverter getInstance() {
            return Holder.BACKGROUND_REPEAT_CONVERTER;
        }

        private BackgroundRepeatConverter() {
        }

        @Override
        public BackgroundRepeat[] convert(ParsedValue<ParsedValue<String, Repeat>[][], BackgroundRepeat[]> parsedValue, Font font) {
            ParsedValue<String, Repeat>[][] parsedValueArray = parsedValue.getValue();
            BackgroundRepeat[] backgroundRepeatArray = new BackgroundRepeat[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                ParsedValue<String, Repeat>[] parsedValueArray2 = parsedValueArray[i];
                Repeat repeat = (Repeat)((Object)this.converter.convert((ParsedValue)parsedValueArray2[0], (Font)null));
                Repeat repeat2 = (Repeat)((Object)this.converter.convert((ParsedValue)parsedValueArray2[1], (Font)null));
                backgroundRepeatArray[i] = new BackgroundRepeat(repeat, repeat2);
            }
            return backgroundRepeatArray;
        }

        public String toString() {
            return "BackgroundRepeatType";
        }
    }

    public static class Builder {
        private Image image;
        private Repeat repeatX = Repeat.REPEAT;
        private Repeat repeatY = Repeat.REPEAT;
        private double top;
        private double right;
        private double bottom;
        private double left;
        private double width;
        private double height;
        private boolean proportionalHPos = true;
        private boolean proportionalVPos = true;
        private boolean proportionalWidth = true;
        private boolean proportionalHeight = true;
        private boolean contain = false;
        private boolean cover = false;

        public Builder setImage(Image image) {
            this.image = image;
            return this;
        }

        public Builder setRepeatX(Repeat repeat) {
            this.repeatX = repeat;
            return this;
        }

        public Builder setRepeatY(Repeat repeat) {
            this.repeatY = repeat;
            return this;
        }

        public Builder setTop(double d) {
            this.top = d;
            return this;
        }

        public Builder setRight(double d) {
            this.right = d;
            return this;
        }

        public Builder setBottom(double d) {
            this.bottom = d;
            return this;
        }

        public Builder setLeft(double d) {
            this.left = d;
            return this;
        }

        public Builder setWidth(double d) {
            this.width = d;
            return this;
        }

        public Builder setHeight(double d) {
            this.height = d;
            return this;
        }

        public Builder setProportionalHPos(boolean bl) {
            this.proportionalHPos = bl;
            return this;
        }

        public Builder setProportionalVPos(boolean bl) {
            this.proportionalVPos = bl;
            return this;
        }

        public Builder setProportionalWidth(boolean bl) {
            this.proportionalWidth = bl;
            return this;
        }

        public Builder setProportionalHeight(boolean bl) {
            this.proportionalHeight = bl;
            return this;
        }

        public Builder setContain(boolean bl) {
            this.contain = bl;
            return this;
        }

        public Builder setCover(boolean bl) {
            this.cover = bl;
            return this;
        }

        public BackgroundImage build() {
            return new BackgroundImage(this.image, this.repeatX, this.repeatY, this.top, this.right, this.bottom, this.left, this.width, this.height, this.proportionalHPos, this.proportionalVPos, this.proportionalWidth, this.proportionalHeight, this.contain, this.cover);
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<Node, Image[]> BACKGROUND_IMAGE = new StyleableProperty<Node, Image[]>("-fx-background-image", (StyleConverter)URLConverter.SequenceConverter.getInstance()){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<Image[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, BackgroundRepeat[]> BACKGROUND_REPEAT = new StyleableProperty<Node, BackgroundRepeat[]>("-fx-background-repeat", (StyleConverter)BackgroundRepeatConverter.getInstance(), new BackgroundRepeat[]{new BackgroundRepeat(Repeat.REPEAT, Repeat.REPEAT)}){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<BackgroundRepeat[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, BackgroundPosition[]> BACKGROUND_POSITION = new StyleableProperty<Node, BackgroundPosition[]>("-fx-background-position", (StyleConverter)LayeredBackgroundPositionConverter.getInstance(), new BackgroundPosition[]{new BackgroundPosition()}){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<BackgroundPosition[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final StyleableProperty<Node, BackgroundSize[]> BACKGROUND_SIZE = new StyleableProperty<Node, BackgroundSize[]>("-fx-background-size", (StyleConverter)LayeredBackgroundSizeConverter.getInstance(), new BackgroundSize[]{new BackgroundSize()}){

            @Override
            public boolean isSettable(Node node) {
                return false;
            }

            @Override
            public WritableValue<BackgroundSize[]> getWritableValue(Node node) {
                return null;
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList();
            Collections.addAll(arrayList, BACKGROUND_IMAGE, BACKGROUND_REPEAT, BACKGROUND_POSITION, BACKGROUND_SIZE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }

    private static class Holder {
        private static final BackgroundRepeatConverter BACKGROUND_REPEAT_CONVERTER = new BackgroundRepeatConverter();
        private static final BackgroundPositionConverter BACKGROUND_POSITION_CONVERTER = new BackgroundPositionConverter();
        private static final LayeredBackgroundPositionConverter LAYERED_BACKGROUND_POSITION_CONVERTER = new LayeredBackgroundPositionConverter();
        private static final BackgroundSizeConverter BACKGROUND_SIZE_CONVERTER = new BackgroundSizeConverter();
        private static final LayeredBackgroundSizeConverter LAYERED_BACKGROUND_SIZE_CONVERTER = new LayeredBackgroundSizeConverter();

        private Holder() {
        }
    }
}

