/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Date;
import org.springframework.util.ResponseTimeMonitor;

public class ResponseTimeMonitorImpl
implements ResponseTimeMonitor {
    private final long initedMillis = System.currentTimeMillis();
    private volatile int accessCount;
    private volatile int totalResponseTimeMillis = 0;
    private volatile int bestResponseTimeMillis = Integer.MAX_VALUE;
    private volatile int worstResponseTimeMillis = Integer.MIN_VALUE;

    public Date getLoadDate() {
        return new Date(this.initedMillis);
    }

    public int getAccessCount() {
        return this.accessCount;
    }

    public long getUptimeMillis() {
        return System.currentTimeMillis() - this.initedMillis;
    }

    public int getAverageResponseTimeMillis() {
        if (this.getAccessCount() == 0) {
            return 0;
        }
        return this.totalResponseTimeMillis / this.getAccessCount();
    }

    public int getBestResponseTimeMillis() {
        return this.bestResponseTimeMillis;
    }

    public int getWorstResponseTimeMillis() {
        return this.worstResponseTimeMillis;
    }

    public synchronized void recordResponseTime(long l) {
        ++this.accessCount;
        int n = (int)l;
        this.totalResponseTimeMillis += n;
        if (n < this.bestResponseTimeMillis) {
            this.bestResponseTimeMillis = n;
        }
        if (n > this.worstResponseTimeMillis) {
            this.worstResponseTimeMillis = n;
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("hits=[").append(this.getAccessCount()).append("]; ");
        stringBuffer.append("average=[").append(this.getAverageResponseTimeMillis()).append("ms]; ");
        stringBuffer.append("best=[").append(this.getBestResponseTimeMillis()).append("ms]; ");
        stringBuffer.append("worst=[").append(this.getWorstResponseTimeMillis()).append("ms]");
        return stringBuffer.toString();
    }
}

