/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.control.IP16ControlModule;
import cn.com.voltronic.solar.control.P15ComUSBControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.ModelPlanBean;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;

public class P16ComUSBControlModule
extends P15ComUSBControlModule
implements IP16ControlModule {
    public P16ComUSBControlModule(Object handler, ConfigData config, Capability capa) {
        super(handler, config, capa);
    }

    @Override
    public boolean setLCD(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("LST", this.getFomatStr(String.valueOf(value), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean cancelShutdown() {
        return false;
    }

    @Override
    public boolean cancelTest() {
        return false;
    }

    @Override
    public boolean remoteTurnOff() {
        boolean result = true;
        try {
            result = this.excuteCommand("SOFF", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean remoteTurnOn() {
        boolean result = true;
        try {
            result = this.excuteCommand("SON", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBatteryGroupNumber(int number) {
        return false;
    }

    @Override
    public boolean setBatteryPieceNumber(int number) {
        return false;
    }

    @Override
    public boolean setBatteryVoltageAdjust(int value) {
        return false;
    }

    @Override
    public boolean setBatteryVoltageSampling(int value) {
        return false;
    }

    @Override
    public boolean setChargingcurrent(int number) {
        return false;
    }

    @Override
    public boolean shutdown(int minutes) {
        return false;
    }

    @Override
    public boolean shutdownRestore(int shutdowntime, int restoretime) {
        return false;
    }

    @Override
    public boolean tenSencondsBatteryTestCtrl() {
        return false;
    }

    @Override
    public boolean testSpecifiedTime(int time) {
        return false;
    }

    @Override
    public boolean testUntilBatteryLow() {
        return false;
    }

    @Override
    public boolean setMaxChargingCurrent(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("MCHGC", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setMaxAcChargingCurrent(double value) {
        boolean result = true;
        try {
            String formatStr = String.format("%02.1f", value);
            if (formatStr.length() < 4) {
                formatStr = "0" + formatStr;
            }
            result = this.excuteCommand("ACCHC", formatStr);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxChargingVoltage(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("BCHGV", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setFloatingVoltage(double value) {
        boolean result = true;
        try {
            ConfigData config;
            result = this.excuteCommand("MCHGV", String.format("%04.01f", value));
            AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
            if (processor != null && result && value < (config = (ConfigData)processor.getBeanBag().getBean("configdata")).getGridChargingLowestBatVol()) {
                this.excuteCommand("ACCV", String.format("%04.1f", value));
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOutputRatingVoltage(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("V", String.format("%03d", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setGNTM(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("GNTM", String.valueOf(value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setChargingTimeH(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("CHTH", this.getFomatStr(String.valueOf(value), 4));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setChargingTimeL(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("CHTL", this.getFomatStr(String.valueOf(value), 4));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setFeefInReactivePower(double value) {
        boolean result = true;
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        ConfigData configdata = (ConfigData)processor.getBeanBag().getBean("configdata");
        try {
            result = value >= 0.0 ? this.excuteCommand("FPRA", String.format("%+05d", (int)value)) : this.excuteCommand("FPRA", String.format("%05d", (int)value));
            Constants.finalNum = value;
            configdata.setFeefInReactivePower(Constants.finalNum);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMaxPowerFeedingGrid(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("GPMP", String.format("%05d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setModelChange(ModelPlanBean bean, ConfigData configData, IProtocol protocol) {
        AbstractProcessor processor;
        boolean goStandby = false;
        boolean nextStep = true;
        boolean bchangePvPlan = false;
        boolean needToRefresh = false;
        int time_i = 0;
        if (!bean.getModelID().equals(configData.getModelID())) {
            goStandby = true;
        } else if ((int)bean.getNominalVoltage() != (int)configData.getNominalVoltage() || (int)bean.getNominalFreq() != (int)configData.getNominalFreq()) {
            goStandby = true;
        } else if ((bean.getModeltype().equalsIgnoreCase("10") || bean.getModeltype().equalsIgnoreCase("01")) && !bean.getPlanID().equals("00") && !bean.getPlanID().equalsIgnoreCase(configData.getPlanID())) {
            goStandby = true;
            bchangePvPlan = true;
        }
        if (goStandby) {
            try {
                nextStep = false;
                time_i = 0;
                while (time_i < 3) {
                    if (this.excuteCommand("GTS", "1")) {
                        try {
                            Thread.sleep(1500L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String re = "(NAK";
                        IComUSBHandler handler = this.getHandler();
                        re = handler.excuteCommand("QMOD", true);
                        if (re.startsWith("(S")) {
                            nextStep = true;
                            break;
                        }
                    }
                    ++time_i;
                }
                if (nextStep) {
                    if (!bean.getModelID().equals(configData.getModelID())) {
                        nextStep = false;
                        if (this.excuteCommand("OEEPB", "") && this.excuteCommand("DMODEL", bean.getModelID())) {
                            configData.setModelID(bean.getModelID());
                            protocol.setDeviceModel(bean.getModelID());
                            protocol.setModelType(bean.getModeltype());
                            needToRefresh = true;
                            nextStep = true;
                            if (bean.getModeltype().equals("10") || bean.getModeltype().equals("01")) {
                                nextStep = false;
                                if (this.excuteCommand("PRIO", bean.getPlanID())) {
                                    configData.setPlanID(bean.getPlanID());
                                    nextStep = true;
                                }
                            }
                        }
                    } else if ((bean.getModeltype().equals("10") || bean.getModeltype().equals("01")) && !bean.getPlanID().equals("00") && !bean.getPlanID().equalsIgnoreCase(configData.getPlanID())) {
                        nextStep = false;
                        if (this.excuteCommand("PRIO", bean.getPlanID())) {
                            configData.setPlanID(bean.getPlanID());
                            nextStep = true;
                        }
                    }
                    if (nextStep && (int)bean.getNominalVoltage() != (int)configData.getNominalVoltage()) {
                        nextStep = false;
                        if (this.excuteCommand("OEEPB", "") && this.excuteCommand("V", String.format("%03d", (int)bean.getNominalVoltage()))) {
                            configData.setNominalVoltage(bean.getNominalVoltage());
                            nextStep = true;
                        }
                    }
                    if (nextStep && (int)bean.getNominalFreq() != (int)configData.getNominalFreq()) {
                        nextStep = false;
                        if (this.excuteCommand("OEEPB", "") && this.excuteCommand("F", String.format("%02d", (int)bean.getNominalFreq()))) {
                            configData.setNominalFreq(bean.getNominalFreq());
                            nextStep = true;
                        }
                    }
                }
            }
            catch (Exception re) {
                // empty catch block
            }
        }
        try {
            if (nextStep) {
                if (!bean.getModeltype().equals("00")) {
                    System.out.println(" set model change 3 " + nextStep);
                    if (nextStep && bean.getCheck_charge() != configData.getCheck_charge() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteCommand("ENFA", String.valueOf(bean.getCheck_charge()))) {
                            configData.setCheck_charge(bean.getCheck_charge());
                            nextStep = true;
                        }
                    }
                    System.out.println(" set model change 4 " + nextStep);
                    if (nextStep && bean.getCheck_accharge() != configData.getCheck_accharge() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteCommand("ENFB", String.valueOf(bean.getCheck_accharge()))) {
                            configData.setCheck_accharge(bean.getCheck_accharge());
                            nextStep = true;
                        }
                    }
                }
                if (bean.getModeltype().equals("10") || bean.getModeltype().equals("01")) {
                    if (nextStep && bean.getCheck_batdispvon() != configData.getCheck_batdispvon() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteCommand("ENFD", String.valueOf(bean.getCheck_batdispvon()))) {
                            configData.setCheck_batdispvon(bean.getCheck_batdispvon());
                            nextStep = true;
                        }
                    }
                    if (nextStep && bean.getCheck_batdispvloss() != configData.getCheck_batdispvloss() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteCommand("ENFE", String.valueOf(bean.getCheck_batdispvloss()))) {
                            configData.setCheck_batdispvloss(bean.getCheck_batdispvloss());
                            nextStep = true;
                        }
                    }
                }
                if ((bean.getModeltype().equals("10") || bean.getModeltype().equals("11")) && nextStep && (bean.getCheck_pvfeedgrid() != configData.getCheck_pvfeedgrid() || bchangePvPlan)) {
                    nextStep = false;
                    if (this.excuteCommand("ENFC", String.valueOf(bean.getCheck_pvfeedgrid()))) {
                        configData.setCheck_pvfeedgrid(bean.getCheck_pvfeedgrid());
                        nextStep = true;
                    }
                }
                if (bean.getModeltype().equals("10")) {
                    if (nextStep && bean.getCheck_batfeedpvon() != configData.getCheck_batfeedpvon() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteCommand("ENFF", String.valueOf(bean.getCheck_batfeedpvon()))) {
                            configData.setCheck_batfeedpvon(bean.getCheck_batfeedpvon());
                            nextStep = true;
                        }
                    }
                    System.out.println(" set model change 5 " + nextStep);
                    if (nextStep && bean.getCheck_batfeedpvloss() != configData.getCheck_batfeedpvloss() || bchangePvPlan) {
                        nextStep = false;
                        if (this.excuteCommand("ENFG", String.valueOf(bean.getCheck_batfeedpvloss()))) {
                            configData.setCheck_batfeedpvloss(bean.getCheck_batfeedpvloss());
                            nextStep = true;
                        }
                    }
                }
                if (bean.getCheck_accharge() == 1) {
                    if (nextStep && !bean.getAcChargingStarttime().equals(configData.getAcChargeStarttime()) || !bean.getAcChargingEndtime().equals(configData.getAcChargeEndtime())) {
                        nextStep = false;
                        if (this.excuteCommand("PKT", String.valueOf(bean.getAcChargingStarttime()) + " " + bean.getAcChargingEndtime())) {
                            nextStep = true;
                            configData.setAcChargeStarttime(bean.getAcChargingStarttime());
                            configData.setAcChargeEndtime(bean.getAcChargingEndtime());
                        }
                    }
                    if (nextStep && bean.getCheck_gridChargingLowestBatVol() != configData.getCheck_gridChargingLowestBatVol()) {
                        nextStep = false;
                        if (this.excuteCommand("ENFJ", String.valueOf(bean.getCheck_gridChargingLowestBatVol()))) {
                            nextStep = true;
                            configData.setCheck_gridChargingLowestBatVol(bean.getCheck_gridChargingLowestBatVol());
                        }
                    }
                    if (nextStep && bean.getCheck_gridChargingLowestBatVol() == 1 && bean.getGridChargingLowestBatVol() != configData.getGridChargingLowestBatVol()) {
                        nextStep = false;
                        if (this.excuteCommand("ACCV", String.format("%04.1f", bean.getGridChargingLowestBatVol()))) {
                            nextStep = true;
                            configData.setGridChargingLowestBatVol(bean.getGridChargingLowestBatVol());
                        }
                    }
                    if (bean.getModelID().equals("01") && nextStep) {
                        bean.getAcchargelimit();
                        configData.getAcChargingLimit();
                    }
                }
                if (!bean.getModeltype().equals("00") && (nextStep && !bean.getAcoutputStarttime().equals(configData.getAcoutputStarttime()) || !bean.getAcoutputEndtime().equals(configData.getAcoutputEndtime())) && this.excuteCommand("LDT", String.valueOf(bean.getAcoutputStarttime()) + " " + bean.getAcoutputEndtime())) {
                    nextStep = true;
                    configData.setAcoutputStarttime(bean.getAcoutputStarttime());
                    configData.setAcoutputEndtime(bean.getAcoutputEndtime());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("nextstep= " + nextStep);
        if (goStandby) {
            try {
                time_i = 0;
                while (time_i < 3) {
                    if (!this.excuteCommand("GTS", "0")) {
                        ++time_i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (nextStep && needToRefresh && (processor = GlobalProcessors.getCurrentProcessor()) != null) {
            WorkInfo workInfo = (WorkInfo)processor.getBeanBag().getBean("workinfo");
            workInfo.setNeedToReresh(true);
            IComUSBHandler _handler = (IComUSBHandler)((Object)processor.getHandler());
            String modelType = _handler.getModeType();
            if (modelType.equals("01")) {
                this.setFeedinPowerFactor(1.0);
            }
        }
        return nextStep;
    }

    @Override
    public boolean setCutoffVoltage(double volGridloss, double volGridon) {
        boolean result = true;
        try {
            result = this.excuteCommand("BSDV", String.format("%04.01f %04.01f", volGridloss, volGridon));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        return result;
    }

    @Override
    public boolean setLiBatterySetting(double mincurrent, double recovervoltage, double time) {
        boolean result = true;
        try {
            result = this.excuteCommand("OFFC", String.format("%04.01f %04.01f %03d", mincurrent, recovervoltage, (int)time));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setRecoverVoltage(double volGridloss, double volGridon) {
        boolean result = true;
        try {
            result = this.excuteCommand("DSUBV", String.format("%04.01f %04.01f", volGridloss, volGridon));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean activeLifeBattery() {
        boolean result = true;
        try {
            result = this.excuteCommand("EO1", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setLBF(int value) {
        boolean result = true;
        try {
            result = this.excuteCommand("LBF", String.valueOf(value));
            if (value == 1) {
                this._configdata.setLiFeBattery(true);
            } else {
                this._configdata.setLiFeBattery(false);
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setBDRWF(String isFull) {
        boolean result = true;
        try {
            result = this.excuteCommand("BDRWF", isFull);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setGridPowerDeviation(double gridPowerDeviation) {
        boolean result = true;
        try {
            String deviationStr = gridPowerDeviation < 0.0 ? String.valueOf((int)gridPowerDeviation).substring(1) : String.valueOf((int)gridPowerDeviation);
            String param = gridPowerDeviation < 0.0 ? "-" + String.format("%03d", VolUtil.parseInt(deviationStr)) : "+" + String.format("%03d", VolUtil.parseInt(deviationStr));
            result = this.excuteCommand("ABGP", param);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setFeedinPowerFactor(double value) {
        boolean result = true;
        try {
            value *= 100.0;
            String valueStr = "";
            if (value > 0.0) {
                valueStr = "+" + String.format("%03d", (int)value);
            } else {
                value = Math.abs(value);
                valueStr = "-" + String.format("%03d", (int)value);
            }
            result = this.excuteCommand("SOPF", valueStr);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setBatDischargeMaxCurrentInHybridMode(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("SMDCC", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setGOLV(double value, boolean isCheck) {
        boolean result = true;
        try {
            result = this.excuteCommand("GOLV", String.format("%05.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public boolean setATPF(int isEnabled, double valueA, double valueB) {
        boolean result = true;
        try {
            int vA = (int)valueA;
            String value1 = String.format("%02d", vA);
            valueB = Math.abs(valueB) * 100.0 + 100.0;
            int value2 = (int)valueB;
            result = this.excuteCommand("ATPF", String.valueOf(isEnabled) + " " + value1 + " " + value2);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

