/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.CannotLoadBeanClassException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.PropertiesPersister;
import org.springframework.util.StringUtils;

public class PropertiesBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    public static final String TRUE_VALUE = "true";
    public static final String SEPARATOR = ".";
    public static final String CLASS_KEY = "(class)";
    private static final String DEPRECATED_CLASS_KEY = "class";
    public static final String PARENT_KEY = "(parent)";
    public static final String ABSTRACT_KEY = "(abstract)";
    public static final String SINGLETON_KEY = "(singleton)";
    public static final String LAZY_INIT_KEY = "(lazy-init)";
    public static final String REF_SUFFIX = "(ref)";
    public static final String REF_PREFIX = "*";
    public static final String CONSTRUCTOR_ARG_PREFIX = "$";
    private String defaultParentBean;
    private PropertiesPersister propertiesPersister = new DefaultPropertiesPersister();

    public PropertiesBeanDefinitionReader(BeanDefinitionRegistry beanDefinitionRegistry) {
        super(beanDefinitionRegistry);
    }

    public void setDefaultParentBean(String string) {
        this.defaultParentBean = string;
    }

    public String getDefaultParentBean() {
        return this.defaultParentBean;
    }

    public void setPropertiesPersister(PropertiesPersister propertiesPersister) {
        this.propertiesPersister = propertiesPersister != null ? propertiesPersister : new DefaultPropertiesPersister();
    }

    public PropertiesPersister getPropertiesPersister() {
        return this.propertiesPersister;
    }

    public int loadBeanDefinitions(Resource resource) throws BeansException {
        return this.loadBeanDefinitions(new EncodedResource(resource), null);
    }

    public int loadBeanDefinitions(Resource resource, String string) throws BeansException {
        return this.loadBeanDefinitions(new EncodedResource(resource), string);
    }

    public int loadBeanDefinitions(EncodedResource encodedResource) throws BeansException {
        return this.loadBeanDefinitions(encodedResource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBeanDefinitions(EncodedResource encodedResource, String string) throws BeansException {
        Properties properties = new Properties();
        try {
            InputStream inputStream = encodedResource.getResource().getInputStream();
            try {
                if (encodedResource.getEncoding() != null) {
                    this.getPropertiesPersister().load(properties, (Reader)new InputStreamReader(inputStream, encodedResource.getEncoding()));
                } else {
                    this.getPropertiesPersister().load(properties, inputStream);
                }
            }
            finally {
                inputStream.close();
            }
            return this.registerBeanDefinitions(properties, string, encodedResource.getResource().getDescription());
        }
        catch (IOException iOException) {
            throw new BeanDefinitionStoreException("Could not parse properties from " + encodedResource.getResource(), iOException);
        }
    }

    public int registerBeanDefinitions(ResourceBundle resourceBundle) throws BeanDefinitionStoreException {
        return this.registerBeanDefinitions(resourceBundle, null);
    }

    public int registerBeanDefinitions(ResourceBundle resourceBundle, String string) throws BeanDefinitionStoreException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            hashMap.put(string2, resourceBundle.getObject(string2));
        }
        return this.registerBeanDefinitions(hashMap, string);
    }

    public int registerBeanDefinitions(Map map) throws BeansException {
        return this.registerBeanDefinitions(map, null);
    }

    public int registerBeanDefinitions(Map map, String string) throws BeansException {
        return this.registerBeanDefinitions(map, string, "Map " + map);
    }

    public int registerBeanDefinitions(Map map, String string, String string2) throws BeansException {
        if (string == null) {
            string = "";
        }
        int n = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof String)) {
                throw new IllegalArgumentException("Illegal key [" + k + "]: only Strings allowed");
            }
            String string3 = (String)k;
            if (!string3.startsWith(string)) continue;
            String string4 = string3.substring(string.length());
            int n2 = -1;
            int n3 = string4.indexOf("[");
            n2 = n3 != -1 ? string4.lastIndexOf(SEPARATOR, n3) : string4.lastIndexOf(SEPARATOR);
            if (n2 != -1) {
                String string5 = string4.substring(0, n2);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Found bean name '" + string5 + "'"));
                }
                if (this.getBeanFactory().containsBeanDefinition(string5)) continue;
                this.registerBeanDefinition(string5, map, string + string5, string2);
                ++n;
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Invalid bean name and property [" + string4 + "]"));
        }
        return n;
    }

    protected void registerBeanDefinition(String string, Map map, String string2, String string3) throws BeansException {
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
        MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
        Object object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = object.next();
            String string6 = StringUtils.trimWhitespace((String)((String)entry.getKey()));
            if (!string6.startsWith(string2 + SEPARATOR)) continue;
            String string7 = string6.substring(string2.length() + SEPARATOR.length());
            if (this.isClassKey(string7)) {
                string4 = StringUtils.trimWhitespace((String)((String)entry.getValue()));
                continue;
            }
            if (PARENT_KEY.equals(string7)) {
                string5 = StringUtils.trimWhitespace((String)((String)entry.getValue()));
                continue;
            }
            if (ABSTRACT_KEY.equals(string7)) {
                String string8 = StringUtils.trimWhitespace((String)((String)entry.getValue()));
                bl = TRUE_VALUE.equals(string8);
                continue;
            }
            if (SINGLETON_KEY.equals(string7)) {
                String string9 = StringUtils.trimWhitespace((String)((String)entry.getValue()));
                bl2 = string9 == null || TRUE_VALUE.equals(string9);
                continue;
            }
            if (LAZY_INIT_KEY.equals(string7)) {
                String string10 = StringUtils.trimWhitespace((String)((String)entry.getValue()));
                bl3 = TRUE_VALUE.equals(string10);
                continue;
            }
            if (string7.startsWith(CONSTRUCTOR_ARG_PREFIX)) {
                if (string7.endsWith(REF_SUFFIX)) {
                    int n = Integer.parseInt(string7.substring(1, string7.length() - REF_SUFFIX.length()));
                    constructorArgumentValues.addIndexedArgumentValue(n, new RuntimeBeanReference(entry.getValue().toString()));
                    continue;
                }
                int n = Integer.parseInt(string7.substring(1));
                constructorArgumentValues.addIndexedArgumentValue(n, this.readValue(entry));
                continue;
            }
            if (string7.endsWith(REF_SUFFIX)) {
                string7 = string7.substring(0, string7.length() - REF_SUFFIX.length());
                String string11 = StringUtils.trimWhitespace((String)((String)entry.getValue()));
                RuntimeBeanReference runtimeBeanReference = new RuntimeBeanReference(string11);
                mutablePropertyValues.addPropertyValue(string7, runtimeBeanReference);
                continue;
            }
            mutablePropertyValues.addPropertyValue(string7, this.readValue(entry));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering bean definition for bean name '" + string + "' with " + mutablePropertyValues));
        }
        if (string5 == null && string4 == null && !string.equals(this.defaultParentBean)) {
            string5 = this.defaultParentBean;
        }
        try {
            object = BeanDefinitionReaderUtils.createBeanDefinition(string5, string4, this.getBeanClassLoader());
            ((AbstractBeanDefinition)object).setAbstract(bl);
            ((AbstractBeanDefinition)object).setSingleton(bl2);
            ((AbstractBeanDefinition)object).setLazyInit(bl3);
            ((AbstractBeanDefinition)object).setConstructorArgumentValues(constructorArgumentValues);
            ((AbstractBeanDefinition)object).setPropertyValues(mutablePropertyValues);
            this.getBeanFactory().registerBeanDefinition(string, (BeanDefinition)object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CannotLoadBeanClassException(string3, string, string4, classNotFoundException);
        }
        catch (LinkageError linkageError) {
            throw new CannotLoadBeanClassException(string3, string, string4, linkageError);
        }
    }

    private boolean isClassKey(String string) {
        if (CLASS_KEY.equals(string)) {
            return true;
        }
        if (DEPRECATED_CLASS_KEY.equals(string)) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Use of 'class' property in [" + this.getClass().getName() + "] is deprecated in favor of '(class)'"));
            }
            return true;
        }
        return false;
    }

    private Object readValue(Map.Entry entry) {
        String string;
        Object object = entry.getValue();
        if (object instanceof String && (string = (String)object).startsWith(REF_PREFIX)) {
            String string2 = string.substring(1);
            object = string2.startsWith(REF_PREFIX) ? string2 : new RuntimeBeanReference(string2);
        }
        return object;
    }
}

