/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XKeyboardControl
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 32;
    }

    @Override
    public int getDataSize() {
        return XKeyboardControl.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XKeyboardControl(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XKeyboardControl() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XKeyboardControl.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_key_click_percent() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_key_click_percent(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public int get_bell_percent() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_bell_percent(int n) {
        log.finest("");
        Native.putInt(this.pData + 4L, n);
    }

    public int get_bell_pitch() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_bell_pitch(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public int get_bell_duration() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_bell_duration(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public int get_led() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_led(int n) {
        log.finest("");
        Native.putInt(this.pData + 16L, n);
    }

    public int get_led_mode() {
        log.finest("");
        return Native.getInt(this.pData + 20L);
    }

    public void set_led_mode(int n) {
        log.finest("");
        Native.putInt(this.pData + 20L, n);
    }

    public int get_key() {
        log.finest("");
        return Native.getInt(this.pData + 24L);
    }

    public void set_key(int n) {
        log.finest("");
        Native.putInt(this.pData + 24L, n);
    }

    public int get_auto_repeat_mode() {
        log.finest("");
        return Native.getInt(this.pData + 28L);
    }

    public void set_auto_repeat_mode(int n) {
        log.finest("");
        Native.putInt(this.pData + 28L, n);
    }

    @Override
    String getName() {
        return "XKeyboardControl";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(320);
        stringBuilder.append("key_click_percent = ").append(this.get_key_click_percent()).append(", ");
        stringBuilder.append("bell_percent = ").append(this.get_bell_percent()).append(", ");
        stringBuilder.append("bell_pitch = ").append(this.get_bell_pitch()).append(", ");
        stringBuilder.append("bell_duration = ").append(this.get_bell_duration()).append(", ");
        stringBuilder.append("led = ").append(this.get_led()).append(", ");
        stringBuilder.append("led_mode = ").append(this.get_led_mode()).append(", ");
        stringBuilder.append("key = ").append(this.get_key()).append(", ");
        stringBuilder.append("auto_repeat_mode = ").append(this.get_auto_repeat_mode()).append(", ");
        return stringBuilder.toString();
    }
}

