/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class OverridingClassLoader
extends ClassLoader {
    private static final String CLASS_FILE_SUFFIX = ".class";
    private final Set excludedPackages = Collections.synchronizedSet(new HashSet());
    private final Set excludedClasses = Collections.synchronizedSet(new HashSet());

    public OverridingClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.excludedPackages.add("java.");
        this.excludedPackages.add("javax.");
    }

    public void excludePackage(String string) {
        Assert.notNull(string, "Package name must not be null");
        this.excludedPackages.add(string);
    }

    public void excludeClass(String string) {
        Assert.notNull(string, "Class name must not be null");
        this.excludedClasses.add(string);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.isEligibleForOverriding(string) && (clazz = this.findLoadedClass(string)) == null) {
            String string2 = string.replace('.', '/') + CLASS_FILE_SUFFIX;
            InputStream inputStream = this.getParent().getResourceAsStream(string2);
            if (inputStream != null) {
                try {
                    byte[] byArray = FileCopyUtils.copyToByteArray(inputStream);
                    byte[] byArray2 = this.transformIfNecessary(string, byArray);
                    clazz = this.defineClass(string, byArray2, 0, byArray2.length);
                }
                catch (IOException iOException) {
                    throw new ClassNotFoundException("Cannot load resource for class [" + string + "]", iOException);
                }
            }
        }
        if (clazz != null) {
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return super.loadClass(string, bl);
    }

    protected boolean isEligibleForOverriding(String string) {
        if (this.excludedClasses.contains(string)) {
            return false;
        }
        Iterator iterator = this.excludedPackages.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string.startsWith(string2)) continue;
            return false;
        }
        return true;
    }

    protected byte[] transformIfNecessary(String string, byte[] byArray) {
        return byArray;
    }
}

