/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.Serializable;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.core.AttributeAccessor;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PropertyValue
extends AttributeAccessorSupport
implements BeanMetadataElement,
Serializable {
    private final String name;
    private final Object value;
    private Object source;
    private boolean converted = false;
    private Object convertedValue;
    volatile Object resolvedTokens;

    public PropertyValue(String string, Object object) {
        this.name = string;
        this.value = object;
    }

    public PropertyValue(PropertyValue propertyValue) {
        Assert.notNull((Object)propertyValue, (String)"Original must not be null");
        this.name = propertyValue.getName();
        this.value = propertyValue.getValue();
        this.source = propertyValue.getSource();
        this.copyAttributesFrom((AttributeAccessor)propertyValue);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public synchronized boolean isConverted() {
        return this.converted;
    }

    public synchronized void setConvertedValue(Object object) {
        this.converted = true;
        this.convertedValue = object;
    }

    public synchronized Object getConvertedValue() {
        return this.convertedValue;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PropertyValue)) {
            return false;
        }
        PropertyValue propertyValue = (PropertyValue)object;
        return this.name.equals(propertyValue.name) && ObjectUtils.nullSafeEquals((Object)this.value, (Object)propertyValue.value) && ObjectUtils.nullSafeEquals((Object)this.source, (Object)propertyValue.source);
    }

    public int hashCode() {
        return this.name.hashCode() * 29 + (this.value == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        return "PropertyValue: name='" + this.name + "', value=[" + this.value + "]";
    }
}

