/*
 * Decompiled with CFR 0.152.
 */
package com.apple.concurrent;

import com.apple.concurrent.LibDispatchNative;
import com.apple.concurrent.LibDispatchQueue;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;

class LibDispatchSerialQueue
extends AbstractExecutorService {
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int TERMINATED = 3;
    final Object lock = new Object();
    LibDispatchQueue nativeQueueWrapper;
    volatile int runState;

    LibDispatchSerialQueue(long l) {
        this.nativeQueueWrapper = new LibDispatchQueue(l);
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.nativeQueueWrapper == null) {
            return;
        }
        LibDispatchNative.nativeExecuteAsync(this.nativeQueueWrapper.ptr, runnable);
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.runState != 0) {
                return;
            }
            this.runState = 1;
            this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = LibDispatchSerialQueue.this.lock;
                    synchronized (object) {
                        LibDispatchSerialQueue.this.runState = 3;
                        LibDispatchSerialQueue.this.lock.notifyAll();
                    }
                }
            });
            this.nativeQueueWrapper = null;
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        if (this.runState == 3) {
            return true;
        }
        long l2 = timeUnit.toMillis(l);
        if (l2 <= 0L) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.runState == 3) {
                return true;
            }
            this.lock.wait(l);
            if (this.runState == 3) {
                return true;
            }
        }
        return false;
    }
}

