/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XTextProperty
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 16 : 32;
    }

    @Override
    public int getDataSize() {
        return XTextProperty.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XTextProperty(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XTextProperty() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XTextProperty.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public byte get_value(int n) {
        log.finest("");
        return Native.getByte(Native.getLong(this.pData + 0L) + (long)(n * 1));
    }

    public long get_value() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_value(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_encoding() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_encoding(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    public int get_format() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16));
    }

    public void set_format(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16), n);
    }

    public long get_nitems() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24));
    }

    public void set_nitems(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24), l);
    }

    @Override
    String getName() {
        return "XTextProperty";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(160);
        stringBuilder.append("value = ").append(this.get_value()).append(", ");
        stringBuilder.append("encoding = ").append(this.get_encoding()).append(", ");
        stringBuilder.append("format = ").append(this.get_format()).append(", ");
        stringBuilder.append("nitems = ").append(this.get_nitems()).append(", ");
        return stringBuilder.toString();
    }
}

