/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Iterator;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.beans.factory.support.MethodOverrides;
import org.springframework.core.AttributeAccessorSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractBeanDefinition
extends AttributeAccessorSupport
implements BeanDefinition {
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    public static final int AUTOWIRE_CONSTRUCTOR = 3;
    public static final int AUTOWIRE_AUTODETECT = 4;
    public static final int DEPENDENCY_CHECK_NONE = 0;
    public static final int DEPENDENCY_CHECK_OBJECTS = 1;
    public static final int DEPENDENCY_CHECK_SIMPLE = 2;
    public static final int DEPENDENCY_CHECK_ALL = 3;
    private Object beanClass;
    private String scope = "singleton";
    private boolean singleton = true;
    private boolean prototype = false;
    private boolean abstractFlag = false;
    private boolean lazyInit = false;
    private boolean autowireCandidate = true;
    private int autowireMode = 0;
    private int dependencyCheck = 0;
    private String[] dependsOn;
    private ConstructorArgumentValues constructorArgumentValues;
    private MutablePropertyValues propertyValues;
    private MethodOverrides methodOverrides = new MethodOverrides();
    private String factoryBeanName;
    private String factoryMethodName;
    private String initMethodName;
    private String destroyMethodName;
    private boolean enforceInitMethod = true;
    private boolean enforceDestroyMethod = true;
    private boolean synthetic = false;
    private String resourceDescription;
    private Object source;
    private int role = 0;

    protected AbstractBeanDefinition() {
        this(null, null);
    }

    protected AbstractBeanDefinition(ConstructorArgumentValues constructorArgumentValues, MutablePropertyValues mutablePropertyValues) {
        this.setConstructorArgumentValues(constructorArgumentValues);
        this.setPropertyValues(mutablePropertyValues);
    }

    protected AbstractBeanDefinition(AbstractBeanDefinition abstractBeanDefinition) {
        this.beanClass = abstractBeanDefinition.beanClass;
        this.setScope(abstractBeanDefinition.getScope());
        this.setAbstract(abstractBeanDefinition.isAbstract());
        this.setLazyInit(abstractBeanDefinition.isLazyInit());
        this.setAutowireCandidate(abstractBeanDefinition.isAutowireCandidate());
        this.setAutowireMode(abstractBeanDefinition.getAutowireMode());
        this.setDependencyCheck(abstractBeanDefinition.getDependencyCheck());
        this.setDependsOn(abstractBeanDefinition.getDependsOn());
        this.setConstructorArgumentValues(new ConstructorArgumentValues(abstractBeanDefinition.getConstructorArgumentValues()));
        this.setPropertyValues(new MutablePropertyValues(abstractBeanDefinition.getPropertyValues()));
        this.setMethodOverrides(new MethodOverrides(abstractBeanDefinition.getMethodOverrides()));
        this.setFactoryBeanName(abstractBeanDefinition.getFactoryBeanName());
        this.setFactoryMethodName(abstractBeanDefinition.getFactoryMethodName());
        this.setInitMethodName(abstractBeanDefinition.getInitMethodName());
        this.setEnforceInitMethod(abstractBeanDefinition.isEnforceInitMethod());
        this.setDestroyMethodName(abstractBeanDefinition.getDestroyMethodName());
        this.setEnforceDestroyMethod(abstractBeanDefinition.isEnforceDestroyMethod());
        this.setSynthetic(abstractBeanDefinition.isSynthetic());
        this.setResourceDescription(abstractBeanDefinition.getResourceDescription());
        this.setSource(abstractBeanDefinition.getSource());
        this.setRole(abstractBeanDefinition.getRole());
        this.copyAttributesFrom(abstractBeanDefinition);
    }

    public void overrideFrom(AbstractBeanDefinition abstractBeanDefinition) {
        if (abstractBeanDefinition.beanClass != null) {
            this.beanClass = abstractBeanDefinition.beanClass;
        }
        this.setScope(abstractBeanDefinition.getScope());
        this.setAbstract(abstractBeanDefinition.isAbstract());
        this.setLazyInit(abstractBeanDefinition.isLazyInit());
        this.setAutowireCandidate(abstractBeanDefinition.isAutowireCandidate());
        this.setAutowireMode(abstractBeanDefinition.getAutowireMode());
        this.setDependencyCheck(abstractBeanDefinition.getDependencyCheck());
        this.setDependsOn(abstractBeanDefinition.getDependsOn());
        this.getConstructorArgumentValues().addArgumentValues(abstractBeanDefinition.getConstructorArgumentValues());
        this.getPropertyValues().addPropertyValues(abstractBeanDefinition.getPropertyValues());
        this.getMethodOverrides().addOverrides(abstractBeanDefinition.getMethodOverrides());
        if (abstractBeanDefinition.getFactoryBeanName() != null) {
            this.setFactoryBeanName(abstractBeanDefinition.getFactoryBeanName());
        }
        if (abstractBeanDefinition.getFactoryMethodName() != null) {
            this.setFactoryMethodName(abstractBeanDefinition.getFactoryMethodName());
        }
        if (abstractBeanDefinition.getInitMethodName() != null) {
            this.setInitMethodName(abstractBeanDefinition.getInitMethodName());
            this.setEnforceInitMethod(abstractBeanDefinition.isEnforceInitMethod());
        }
        if (abstractBeanDefinition.getDestroyMethodName() != null) {
            this.setDestroyMethodName(abstractBeanDefinition.getDestroyMethodName());
            this.setEnforceDestroyMethod(abstractBeanDefinition.isEnforceDestroyMethod());
        }
        this.setSynthetic(abstractBeanDefinition.isSynthetic());
        this.setResourceDescription(abstractBeanDefinition.getResourceDescription());
        this.setSource(abstractBeanDefinition.getSource());
        this.setRole(abstractBeanDefinition.getRole());
        this.copyAttributesFrom(abstractBeanDefinition);
    }

    public boolean hasBeanClass() {
        return this.beanClass instanceof Class;
    }

    public void setBeanClass(Class clazz) {
        this.beanClass = clazz;
    }

    public Class getBeanClass() throws IllegalStateException {
        if (this.beanClass == null) {
            throw new IllegalStateException("No bean class specified on bean definition");
        }
        if (!(this.beanClass instanceof Class)) {
            throw new IllegalStateException("Bean class name [" + this.beanClass + "] has not been resolved into an actual Class");
        }
        return (Class)this.beanClass;
    }

    public void setBeanClassName(String string) {
        this.beanClass = string;
    }

    public String getBeanClassName() {
        if (this.beanClass instanceof Class) {
            return ((Class)this.beanClass).getName();
        }
        return (String)this.beanClass;
    }

    public Class resolveBeanClass(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.beanClass == null) {
            return null;
        }
        Class clazz = ClassUtils.forName((String)this.getBeanClassName(), (ClassLoader)classLoader);
        this.beanClass = clazz;
        return clazz;
    }

    public void setScope(String string) {
        Assert.notNull((Object)string, (String)"Scope must not be null");
        this.scope = string;
        this.singleton = "singleton".equals(string);
        this.prototype = "prototype".equals(string);
    }

    public String getScope() {
        return this.scope;
    }

    public void setSingleton(boolean bl) {
        this.scope = bl ? "singleton" : "prototype";
        this.singleton = bl;
        this.prototype = !bl;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public void setAbstract(boolean bl) {
        this.abstractFlag = bl;
    }

    public boolean isAbstract() {
        return this.abstractFlag;
    }

    public void setLazyInit(boolean bl) {
        this.lazyInit = bl;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setAutowireCandidate(boolean bl) {
        this.autowireCandidate = bl;
    }

    public boolean isAutowireCandidate() {
        return this.autowireCandidate;
    }

    public void setAutowireMode(int n) {
        this.autowireMode = n;
    }

    public int getAutowireMode() {
        return this.autowireMode;
    }

    public int getResolvedAutowireMode() {
        if (this.autowireMode == 4) {
            Constructor<?>[] constructorArray = this.getBeanClass().getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                if (constructorArray[i].getParameterTypes().length != 0) continue;
                return 2;
            }
            return 3;
        }
        return this.autowireMode;
    }

    public void setDependencyCheck(int n) {
        this.dependencyCheck = n;
    }

    public int getDependencyCheck() {
        return this.dependencyCheck;
    }

    public void setDependsOn(String[] stringArray) {
        this.dependsOn = stringArray;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public void setConstructorArgumentValues(ConstructorArgumentValues constructorArgumentValues) {
        this.constructorArgumentValues = constructorArgumentValues != null ? constructorArgumentValues : new ConstructorArgumentValues();
    }

    public ConstructorArgumentValues getConstructorArgumentValues() {
        return this.constructorArgumentValues;
    }

    public boolean hasConstructorArgumentValues() {
        return !this.constructorArgumentValues.isEmpty();
    }

    public void setPropertyValues(MutablePropertyValues mutablePropertyValues) {
        this.propertyValues = mutablePropertyValues != null ? mutablePropertyValues : new MutablePropertyValues();
    }

    public MutablePropertyValues getPropertyValues() {
        return this.propertyValues;
    }

    public void setMethodOverrides(MethodOverrides methodOverrides) {
        this.methodOverrides = methodOverrides != null ? methodOverrides : new MethodOverrides();
    }

    public MethodOverrides getMethodOverrides() {
        return this.methodOverrides;
    }

    public void setFactoryBeanName(String string) {
        this.factoryBeanName = string;
    }

    public String getFactoryBeanName() {
        return this.factoryBeanName;
    }

    public void setFactoryMethodName(String string) {
        this.factoryMethodName = string;
    }

    public String getFactoryMethodName() {
        return this.factoryMethodName;
    }

    public void setInitMethodName(String string) {
        this.initMethodName = string;
    }

    public String getInitMethodName() {
        return this.initMethodName;
    }

    public void setEnforceInitMethod(boolean bl) {
        this.enforceInitMethod = bl;
    }

    public boolean isEnforceInitMethod() {
        return this.enforceInitMethod;
    }

    public void setDestroyMethodName(String string) {
        this.destroyMethodName = string;
    }

    public String getDestroyMethodName() {
        return this.destroyMethodName;
    }

    public void setEnforceDestroyMethod(boolean bl) {
        this.enforceDestroyMethod = bl;
    }

    public boolean isEnforceDestroyMethod() {
        return this.enforceDestroyMethod;
    }

    public void setSynthetic(boolean bl) {
        this.synthetic = bl;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setResourceDescription(String string) {
        this.resourceDescription = string;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public void setRole(int n) {
        this.role = n;
    }

    public int getRole() {
        return this.role;
    }

    public void validate() throws BeanDefinitionValidationException {
        if (!this.getMethodOverrides().isEmpty() && this.getFactoryMethodName() != null) {
            throw new BeanDefinitionValidationException("Cannot combine static factory method with method overrides: the static factory method must create the instance");
        }
        if (this.hasBeanClass()) {
            this.prepareMethodOverrides();
        }
    }

    public void prepareMethodOverrides() throws BeanDefinitionValidationException {
        Iterator iterator = this.getMethodOverrides().getOverrides().iterator();
        while (iterator.hasNext()) {
            MethodOverride methodOverride = (MethodOverride)iterator.next();
            this.prepareMethodOverride(methodOverride);
        }
    }

    protected void prepareMethodOverride(MethodOverride methodOverride) throws BeanDefinitionValidationException {
        int n = ClassUtils.getMethodCountForName((Class)this.getBeanClass(), (String)methodOverride.getMethodName());
        if (n == 0) {
            throw new BeanDefinitionValidationException("Invalid method override: no method with name '" + methodOverride.getMethodName() + "' on class [" + this.getBeanClassName() + "]");
        }
        if (n == 1) {
            methodOverride.setOverloaded(false);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractBeanDefinition)) {
            return false;
        }
        AbstractBeanDefinition abstractBeanDefinition = (AbstractBeanDefinition)object;
        if (!ObjectUtils.nullSafeEquals((Object)this.beanClass, (Object)abstractBeanDefinition.beanClass)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.scope, (Object)abstractBeanDefinition.scope)) {
            return false;
        }
        if (this.abstractFlag != abstractBeanDefinition.abstractFlag) {
            return false;
        }
        if (this.lazyInit != abstractBeanDefinition.lazyInit) {
            return false;
        }
        if (this.autowireCandidate != abstractBeanDefinition.autowireCandidate) {
            return false;
        }
        if (this.autowireMode != abstractBeanDefinition.autowireMode) {
            return false;
        }
        if (this.dependencyCheck != abstractBeanDefinition.dependencyCheck) {
            return false;
        }
        if (!Arrays.equals(this.dependsOn, abstractBeanDefinition.dependsOn)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.constructorArgumentValues, (Object)abstractBeanDefinition.constructorArgumentValues)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.propertyValues, (Object)abstractBeanDefinition.propertyValues)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.methodOverrides, (Object)abstractBeanDefinition.methodOverrides)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.factoryBeanName, (Object)abstractBeanDefinition.factoryBeanName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.factoryMethodName, (Object)abstractBeanDefinition.factoryMethodName)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.initMethodName, (Object)abstractBeanDefinition.initMethodName)) {
            return false;
        }
        if (this.enforceInitMethod != abstractBeanDefinition.enforceInitMethod) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.destroyMethodName, (Object)abstractBeanDefinition.destroyMethodName)) {
            return false;
        }
        if (this.enforceDestroyMethod != abstractBeanDefinition.enforceDestroyMethod) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.resourceDescription, (Object)abstractBeanDefinition.resourceDescription)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.source, (Object)abstractBeanDefinition.source)) {
            return false;
        }
        if (this.role != abstractBeanDefinition.role) {
            return false;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int n = ObjectUtils.nullSafeHashCode((Object)this.beanClass);
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object)this.scope);
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object)this.constructorArgumentValues);
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object)this.propertyValues);
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object)this.factoryBeanName);
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object)this.factoryMethodName);
        n = 29 * n + super.hashCode();
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("class [");
        stringBuffer.append(this.getBeanClassName()).append("]");
        stringBuffer.append("; scope=").append(this.scope);
        stringBuffer.append("; abstract=").append(this.abstractFlag);
        stringBuffer.append("; lazyInit=").append(this.lazyInit);
        stringBuffer.append("; autowireCandidate=").append(this.autowireCandidate);
        stringBuffer.append("; autowireMode=").append(this.autowireMode);
        stringBuffer.append("; dependencyCheck=").append(this.dependencyCheck);
        stringBuffer.append("; factoryBeanName=").append(this.factoryBeanName);
        stringBuffer.append("; factoryMethodName=").append(this.factoryMethodName);
        stringBuffer.append("; initMethodName=").append(this.initMethodName);
        stringBuffer.append("; destroyMethodName=").append(this.destroyMethodName);
        if (this.resourceDescription != null) {
            stringBuffer.append("; defined in ").append(this.resourceDescription);
        }
        return stringBuffer.toString();
    }
}

