/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class BridgeMethodResolver {
    static /* synthetic */ Class class$java$lang$Object;

    public static Method findBridgedMethod(Method method) {
        Assert.notNull(method, "Method must not be null");
        if (!method.isBridge()) {
            return method;
        }
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = ReflectionUtils.getAllDeclaredMethods(method.getDeclaringClass());
        for (int i = 0; i < methodArray.length; ++i) {
            Method method2 = methodArray[i];
            if (!BridgeMethodResolver.isBridgedCandidateFor(method2, method)) continue;
            arrayList.add(method2);
        }
        Method method3 = arrayList.size() == 1 ? (Method)arrayList.get(0) : BridgeMethodResolver.searchCandidates(arrayList, method);
        if (method3 == null) {
            throw new IllegalStateException("Unable to locate bridged method for bridge method '" + method + "'");
        }
        return method3;
    }

    private static Method searchCandidates(List list, Method method) {
        Map map = BridgeMethodResolver.createTypeVariableMap(method.getDeclaringClass());
        for (int i = 0; i < list.size(); ++i) {
            Method method2 = (Method)list.get(i);
            if (!BridgeMethodResolver.isBridgeMethodFor(method, method2, map)) continue;
            return method2;
        }
        return null;
    }

    private static boolean isBridgedCandidateFor(Method method, Method method2) {
        return !method.isBridge() && !method.equals(method2) && method.getName().equals(method2.getName()) && method.getParameterTypes().length == method2.getParameterTypes().length;
    }

    static boolean isBridgeMethodFor(Method method, Method method2, Map map) {
        if (BridgeMethodResolver.isResolvedTypeMatch(method2, method, map)) {
            return true;
        }
        Method method3 = BridgeMethodResolver.findGenericDeclaration(method);
        return method3 != null ? BridgeMethodResolver.isResolvedTypeMatch(method3, method2, map) : false;
    }

    private static Method findGenericDeclaration(Method method) {
        Class[] classArray;
        Class<?> clazz = method.getDeclaringClass().getSuperclass();
        while (!(class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object).equals(clazz)) {
            classArray = BridgeMethodResolver.searchForMatch(clazz, method);
            if (classArray != null && !classArray.isBridge()) {
                return classArray;
            }
            clazz = clazz.getSuperclass();
        }
        classArray = ClassUtils.getAllInterfacesForClass(method.getDeclaringClass());
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz2 = classArray[i];
            Method method2 = BridgeMethodResolver.searchForMatch(clazz2, method);
            if (method2 == null || method2.isBridge()) continue;
            return method2;
        }
        return null;
    }

    private static boolean isResolvedTypeMatch(Method method, Method method2, Map map) {
        Class<?>[] classArray;
        Type[] typeArray = method.getGenericParameterTypes();
        if (typeArray.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            Class<?> clazz = classArray[i];
            if (!(type instanceof GenericArrayType && clazz.isArray() ? !clazz.getComponentType().equals(BridgeMethodResolver.getRawType(((GenericArrayType)type).getGenericComponentType(), map)) : !clazz.equals(BridgeMethodResolver.getRawType(type, map)))) continue;
            return false;
        }
        return true;
    }

    private static Type getRawType(Type type, Map map) {
        if (type instanceof TypeVariable) {
            Type type2;
            TypeVariable typeVariable = (TypeVariable)type;
            Type type3 = (Type)map.get(typeVariable);
            if (type3 != null) {
                type2 = type3;
            } else if (class$java$lang$Object == null) {
                class$java$lang$Object = BridgeMethodResolver.class$("java.lang.Object");
                type2 = class$java$lang$Object;
            } else {
                type2 = class$java$lang$Object;
            }
            return type2;
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType();
        }
        return type;
    }

    private static Method searchForMatch(Class clazz, Method method) {
        return ReflectionUtils.findMethod(clazz, method.getName(), method.getParameterTypes());
    }

    static Map createTypeVariableMap(Class clazz) {
        ParameterizedType parameterizedType;
        HashMap hashMap = new HashMap();
        BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(clazz.getGenericInterfaces(), hashMap);
        Type type = clazz.getGenericSuperclass();
        Class<Object> clazz2 = clazz.getSuperclass();
        while (!(class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object).equals(clazz2)) {
            if (type instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)type;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(hashMap, parameterizedType);
            }
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(clazz2.getGenericInterfaces(), hashMap);
            type = clazz2.getGenericSuperclass();
            clazz2 = clazz2.getSuperclass();
        }
        clazz2 = clazz;
        while (clazz2.isMemberClass()) {
            type = clazz2.getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                parameterizedType = (ParameterizedType)type;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(hashMap, parameterizedType);
            }
            clazz2 = clazz2.getEnclosingClass();
        }
        return hashMap;
    }

    private static void extractTypeVariablesFromGenericInterfaces(Type[] typeArray, Map map) {
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(map, parameterizedType);
                continue;
            }
            if (!(type instanceof Class)) continue;
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(((Class)type).getGenericInterfaces(), map);
        }
    }

    private static void populateTypeMapFromParameterizedType(Map map, ParameterizedType parameterizedType) {
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariableArray = ((Class)parameterizedType.getRawType()).getTypeParameters();
        for (int i = 0; i < typeArray.length; ++i) {
            Type type = typeArray[i];
            TypeVariable typeVariable = typeVariableArray[i];
            if (type instanceof Class) {
                map.put(typeVariable, (Class)type);
                continue;
            }
            if (type instanceof ParameterizedType) {
                map.put(typeVariable, ((ParameterizedType)type).getRawType());
                continue;
            }
            if (!(type instanceof TypeVariable)) continue;
            TypeVariable typeVariable2 = (TypeVariable)type;
            Type type2 = (Type)map.get(typeVariable2);
            if (type2 == null) {
                type2 = BridgeMethodResolver.extractClassTypeVariable(typeVariable2);
            }
            if (type2 == null) continue;
            map.put(typeVariable, type2);
        }
    }

    private static Class extractClassTypeVariable(TypeVariable typeVariable) {
        Type[] typeArray = typeVariable.getBounds();
        Type type = null;
        if (typeArray.length > 0) {
            Type type2 = typeArray[0];
            if (type2 instanceof ParameterizedType) {
                type = ((ParameterizedType)type2).getRawType();
            } else if (type2 instanceof Class) {
                type = type2;
            } else if (type2 instanceof TypeVariable) {
                type = BridgeMethodResolver.extractClassTypeVariable((TypeVariable)type2);
            }
        }
        return type instanceof Class ? (Class)type : null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

