/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.CachingMapDecorator;
import org.springframework.util.ReflectionUtils;

public final class ReflectiveVisitorHelper {
    private static final String VISIT_METHOD = "visit";
    private static final String VISIT_NULL = "visitNull";
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$core$ReflectiveVisitorHelper == null ? (class$org$springframework$core$ReflectiveVisitorHelper = ReflectiveVisitorHelper.class$("org.springframework.core.ReflectiveVisitorHelper")) : class$org$springframework$core$ReflectiveVisitorHelper));
    private CachingMapDecorator visitorClassVisitMethods = new CachingMapDecorator(){

        public Object create(Object object) {
            return new ClassVisitMethods((Class)object);
        }
    };
    static /* synthetic */ Class class$org$springframework$core$ReflectiveVisitorHelper;
    static /* synthetic */ Class class$java$lang$Object;

    public Object invokeVisit(Object object, Object object2) {
        Assert.notNull(object, "The visitor to visit is required");
        Method method = this.getMethod(object.getClass(), object2);
        if (method == null) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("No method found by reflection for visitor class [" + object.getClass().getName() + "] and argument of type [" + (object2 != null ? object2.getClass().getName() : "") + "]"));
            }
            return null;
        }
        try {
            Object[] objectArray = null;
            if (object2 != null) {
                objectArray = new Object[]{object2};
            }
            if (!Modifier.isPublic(method.getModifiers()) && !method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            ReflectionUtils.handleReflectionException(exception);
            throw new IllegalStateException("Should never get here");
        }
    }

    private Method getMethod(Class clazz, Object object) {
        ClassVisitMethods classVisitMethods = (ClassVisitMethods)this.visitorClassVisitMethods.get(clazz);
        return classVisitMethods.getVisitMethod(object != null ? object.getClass() : null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClassVisitMethods {
        private final Class visitorClass;
        private CachingMapDecorator visitMethodCache = new CachingMapDecorator(){

            public Object create(Object object) {
                if (object == null) {
                    return ClassVisitMethods.this.findNullVisitorMethod();
                }
                Method method = ClassVisitMethods.this.findVisitMethod((Class)object);
                if (method == null) {
                    method = ClassVisitMethods.this.findDefaultVisitMethod();
                }
                return method;
            }
        };

        private ClassVisitMethods(Class clazz) {
            this.visitorClass = clazz;
        }

        private Method findNullVisitorMethod() {
            for (Class clazz = this.visitorClass; clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    return clazz.getDeclaredMethod(ReflectiveVisitorHelper.VISIT_NULL, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            return this.findDefaultVisitMethod();
        }

        private Method findDefaultVisitMethod() {
            Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ReflectiveVisitorHelper.class$("java.lang.Object")) : class$java$lang$Object};
            for (Class clazz = this.visitorClass; clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    return clazz.getDeclaredMethod(ReflectiveVisitorHelper.VISIT_METHOD, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"No default 'visit' method found.  Returning <null>");
            }
            return null;
        }

        private Method getVisitMethod(Class clazz) {
            return (Method)this.visitMethodCache.get(clazz);
        }

        private Method findVisitMethod(Class clazz) {
            if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = ReflectiveVisitorHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
                return null;
            }
            LinkedList linkedList = new LinkedList();
            linkedList.addFirst(clazz);
            while (!linkedList.isEmpty()) {
                Class clazz2 = (Class)linkedList.removeLast();
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Looking for method visit(" + clazz2 + ")"));
                    }
                    return this.findVisitMethod(this.visitorClass, clazz2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!clazz2.isInterface() && clazz2.getSuperclass() != (class$java$lang$Object == null ? ReflectiveVisitorHelper.class$("java.lang.Object") : class$java$lang$Object)) {
                        linkedList.addFirst(clazz2.getSuperclass());
                    }
                    Class<?>[] classArray = clazz2.getInterfaces();
                    for (int i = 0; i < classArray.length; ++i) {
                        linkedList.addFirst(classArray[i]);
                    }
                }
            }
            return this.findDefaultVisitMethod();
        }

        private Method findVisitMethod(Class clazz, Class clazz2) throws NoSuchMethodException {
            try {
                return clazz.getDeclaredMethod(ReflectiveVisitorHelper.VISIT_METHOD, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clazz.getSuperclass() != (class$java$lang$Object == null ? (class$java$lang$Object = ReflectiveVisitorHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
                    return this.findVisitMethod(clazz.getSuperclass(), clazz2);
                }
                throw noSuchMethodException;
            }
        }
    }
}

