/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;

public class InputStreamResource
extends AbstractResource {
    private final InputStream inputStream;
    private final String description;
    private boolean read = false;

    public InputStreamResource(InputStream inputStream) {
        this(inputStream, "resource loaded through InputStream");
    }

    public InputStreamResource(InputStream inputStream, String string) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream must not be null");
        }
        this.inputStream = inputStream;
        this.description = string != null ? string : "";
    }

    public boolean exists() {
        return true;
    }

    public boolean isOpen() {
        return true;
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        if (this.read) {
            throw new IllegalStateException("InputStream has already been read - do not use InputStreamResource if a stream needs to be read multiple times");
        }
        this.read = true;
        return this.inputStream;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof InputStreamResource && ((InputStreamResource)object).inputStream.equals(this.inputStream);
    }

    public int hashCode() {
        return this.inputStream.hashCode();
    }
}

