/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;

public class ResourceEditor
extends PropertyEditorSupport {
    private final ResourceLoader resourceLoader;

    public ResourceEditor() {
        this(new DefaultResourceLoader());
    }

    public ResourceEditor(ResourceLoader resourceLoader) {
        Assert.notNull(resourceLoader, "ResourceLoader must not be null");
        this.resourceLoader = resourceLoader;
    }

    public void setAsText(String string) {
        if (StringUtils.hasText(string)) {
            String string2 = this.resolvePath(string).trim();
            this.setValue(this.resourceLoader.getResource(string2));
        } else {
            this.setValue(null);
        }
    }

    protected String resolvePath(String string) {
        return SystemPropertyUtils.resolvePlaceholders(string);
    }

    public String getAsText() {
        Resource resource = (Resource)this.getValue();
        try {
            return resource != null ? resource.getURL().toExternalForm() : "";
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

