/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.springframework.util.Assert;

public class AutoPopulatingList
implements List {
    private final List backingList;
    private final ElementFactory elementFactory;

    public AutoPopulatingList(Class clazz) {
        this(new ArrayList(), clazz);
    }

    public AutoPopulatingList(List list, Class clazz) {
        this(list, new ReflectiveElementFactory(clazz));
    }

    public AutoPopulatingList(ElementFactory elementFactory) {
        this(new ArrayList(), elementFactory);
    }

    public AutoPopulatingList(List list, ElementFactory elementFactory) {
        Assert.notNull(list, "Backing List must not be null");
        Assert.notNull(elementFactory, "Element factory must not be null");
        this.backingList = list;
        this.elementFactory = elementFactory;
    }

    public void add(int n, Object object) {
        this.backingList.add(n, object);
    }

    public boolean add(Object object) {
        return this.backingList.add(object);
    }

    public boolean addAll(Collection collection) {
        return this.backingList.addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        return this.backingList.addAll(n, collection);
    }

    public void clear() {
        this.backingList.clear();
    }

    public boolean contains(Object object) {
        return this.backingList.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.backingList.containsAll(collection);
    }

    public boolean equals(Object object) {
        return ((Object)this.backingList).equals(object);
    }

    public Object get(int n) {
        int n2 = this.backingList.size();
        Object object = null;
        if (n < n2) {
            object = this.backingList.get(n);
            if (object == null) {
                object = this.elementFactory.createElement(n);
                this.backingList.set(n, object);
            }
        } else {
            for (int i = n2; i < n; ++i) {
                this.backingList.add(null);
            }
            object = this.elementFactory.createElement(n);
            this.backingList.add(object);
        }
        return object;
    }

    public int hashCode() {
        return ((Object)this.backingList).hashCode();
    }

    public int indexOf(Object object) {
        return this.backingList.indexOf(object);
    }

    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }

    public Iterator iterator() {
        return this.backingList.iterator();
    }

    public int lastIndexOf(Object object) {
        return this.backingList.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.backingList.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.backingList.listIterator(n);
    }

    public Object remove(int n) {
        return this.backingList.remove(n);
    }

    public boolean remove(Object object) {
        return this.backingList.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return this.backingList.removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.backingList.retainAll(collection);
    }

    public Object set(int n, Object object) {
        return this.backingList.set(n, object);
    }

    public int size() {
        return this.backingList.size();
    }

    public List subList(int n, int n2) {
        return this.backingList.subList(n, n2);
    }

    public Object[] toArray() {
        return this.backingList.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.backingList.toArray(objectArray);
    }

    public static interface ElementFactory {
        public Object createElement(int var1) throws ElementInstantiationException;
    }

    public static class ElementInstantiationException
    extends RuntimeException {
        public ElementInstantiationException(String string) {
            super(string);
        }
    }

    private static class ReflectiveElementFactory
    implements ElementFactory {
        private final Class elementClass;

        public ReflectiveElementFactory(Class clazz) {
            Assert.notNull(clazz, "Element clas must not be null");
            Assert.isTrue(!clazz.isInterface(), "Element class must not be an interface type");
            Assert.isTrue(!Modifier.isAbstract(clazz.getModifiers()), "Element class cannot be an abstract class");
            this.elementClass = clazz;
        }

        public Object createElement(int n) {
            try {
                return this.elementClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new ElementInstantiationException("Unable to instantiate element class [" + this.elementClass.getName() + "]. Root cause is " + instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ElementInstantiationException("Cannot access element class [" + this.elementClass.getName() + "]. Root cause is " + illegalAccessException);
            }
        }
    }
}

