/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.comusbprocessor;

import cn.com.voltronic.solar.beanbag.P16BeanBag;
import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.AbstractComUSBProcessor;
import cn.com.voltronic.solar.control.P16ComUSBControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.DefaultData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProtocolInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.webservice.WebServices;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class P16ComUSBProcessor
extends AbstractComUSBProcessor {
    private Logger logger = Logger.getLogger(P16ComUSBProcessor.class);
    private Object query_hour = new Integer(0);
    private Object query_day = new Integer(1);
    private Object query_month = new Integer(2);
    private Object query_year = new Integer(3);

    public P16ComUSBProcessor(ICommunicateDevice handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P16BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P16ComUSBControlModule(this.getHandler(), (ConfigData)this._beanbag.getBean("configdata"), (Capability)this._beanbag.getBean("capability"));
    }

    @Override
    public void initProtocol() {
        ProtocolInfo info = (ProtocolInfo)this.getBeanBag().getBean("protocolinfo");
        info.setProdid(this._protocol.getProtocolID());
        info.setBaseInfo(this._protocol.getBaseInfo());
        info.setProductInfo(this._protocol.getProductInfo());
        info.setRatingInfo(this._protocol.getRatingInfo());
        try {
            info.setSerialno(this._protocol.getSerialNo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        info.setMoreInfo(this._protocol.getMoreInfo());
        info.setMpptTrackNumber(this._protocol.getMpptTrackNumber());
    }

    @Override
    public P16BeanBag getBeanBag() {
        return (P16BeanBag)this._beanbag;
    }

    @Override
    public boolean pollQueryStatus() {
        if (!super.pollQueryStatus()) {
            ++this.reconnectTimes;
            return false;
        }
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String qpifs;
            String qpiws;
            workinfo.setProdid(this.getProtocol().getProtocolID());
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            if (this.currenttime != null) {
                workinfo.setCurrentTime(this.currenttime.getTime());
            }
            if (!"".equals(qpiws = handler.excuteCommand("QPIWS", true)) && !qpiws.equals("(NAK")) {
                String qpiwsStr = qpiws.substring(1);
                this.hasFault = qpiwsStr.charAt(0) == '1';
                if (qpiwsStr.charAt(1) == '1') {
                    if (!workinfo.getWarnings().contains("2001")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2001");
                        workinfo.addWarning("2001");
                    }
                } else if (workinfo.getWarnings().contains("2001")) {
                    workinfo.getWarnings().remove("2001");
                }
                if (qpiwsStr.charAt(2) == '1') {
                    if (!workinfo.getWarnings().contains("2002")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2002");
                        workinfo.addWarning("2002");
                    }
                } else if (workinfo.getWarnings().contains("2002")) {
                    workinfo.getWarnings().remove("2002");
                }
                if (qpiwsStr.charAt(3) == '1') {
                    if (!workinfo.getWarnings().contains("2003")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2003");
                        workinfo.addWarning("2003");
                    }
                } else if (workinfo.getWarnings().contains("2003")) {
                    workinfo.getWarnings().remove("2003");
                }
                if (qpiwsStr.charAt(4) == '1') {
                    if (!workinfo.getWarnings().contains("2004")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2004");
                        workinfo.addWarning("2004");
                    }
                } else if (workinfo.getWarnings().contains("2004")) {
                    workinfo.getWarnings().remove("2004");
                }
                if (qpiwsStr.charAt(5) == '1') {
                    if (!workinfo.getWarnings().contains("2005")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2005");
                        workinfo.addWarning("2005");
                    }
                } else if (workinfo.getWarnings().contains("2005")) {
                    workinfo.getWarnings().remove("2005");
                }
                if (qpiwsStr.charAt(6) == '1') {
                    if (!workinfo.getWarnings().contains("2006")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2006");
                        workinfo.addWarning("2006");
                    }
                } else if (workinfo.getWarnings().contains("2006")) {
                    workinfo.getWarnings().remove("2006");
                }
                if (qpiwsStr.charAt(7) == '1') {
                    if (!workinfo.getWarnings().contains("2007")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2007");
                        workinfo.addWarning("2007");
                    }
                } else if (workinfo.getWarnings().contains("2007")) {
                    workinfo.getWarnings().remove("2007");
                }
                if (qpiwsStr.charAt(8) == '1') {
                    if (!workinfo.getWarnings().contains("2008")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2008");
                        workinfo.addWarning("2008");
                    }
                } else if ((qpiwsStr.charAt(10) == '1' || qpiwsStr.charAt(9) == '1' || qpiwsStr.charAt(8) == '1' || qpiwsStr.charAt(7) == '1') && workinfo.getWarnings().contains("2008")) {
                    workinfo.getWarnings().remove("2008");
                }
                if (qpiwsStr.charAt(9) == '1') {
                    if (!workinfo.getWarnings().contains("2009")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2009");
                        workinfo.addWarning("2009");
                    }
                } else if (workinfo.getWarnings().contains("2009")) {
                    workinfo.getWarnings().remove("2009");
                }
                if (qpiwsStr.charAt(10) == '1') {
                    if (!workinfo.getWarnings().contains("2010")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2010");
                        workinfo.addWarning("2010");
                    }
                } else if ((qpiwsStr.charAt(10) == '1' || qpiwsStr.charAt(9) == '1' || qpiwsStr.charAt(8) == '1' || qpiwsStr.charAt(7) == '1') && workinfo.getWarnings().contains("2010")) {
                    workinfo.getWarnings().remove("2010");
                }
                if (qpiwsStr.charAt(11) == '1') {
                    if (!workinfo.getWarnings().contains("2011")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2011");
                        workinfo.addWarning("2011");
                    }
                } else if (workinfo.getWarnings().contains("2011")) {
                    workinfo.getWarnings().remove("2011");
                }
                if (qpiwsStr.charAt(12) == '1') {
                    if (!workinfo.getWarnings().contains("2012")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2012");
                        workinfo.addWarning("2012");
                    }
                } else if (workinfo.getWarnings().contains("2012")) {
                    workinfo.getWarnings().remove("2012");
                }
                if (qpiwsStr.charAt(13) == '1') {
                    if (!workinfo.getWarnings().contains("2013")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2013");
                        workinfo.addWarning("2013");
                    }
                } else if (workinfo.getWarnings().contains("2013")) {
                    workinfo.removeWarning("2013");
                }
                if (qpiwsStr.charAt(14) == '1') {
                    if (!workinfo.getWarnings().contains("2014")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2014");
                        workinfo.addWarning("2014");
                    }
                } else if (workinfo.getWarnings().contains("2014")) {
                    workinfo.removeWarning("2014");
                }
                if (qpiwsStr.charAt(15) == '1') {
                    if (!workinfo.getWarnings().contains("2015")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2015");
                        workinfo.addWarning("2015");
                    }
                } else if (workinfo.getWarnings().contains("2015")) {
                    workinfo.removeWarning("2015");
                }
                if (qpiwsStr.charAt(16) == '1') {
                    if (!workinfo.getWarnings().contains("2016")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2016");
                        workinfo.addWarning("2016");
                    }
                } else if (workinfo.getWarnings().contains("2016")) {
                    workinfo.removeWarning("2016");
                }
                if (qpiwsStr.charAt(17) == '1') {
                    if (!workinfo.getWarnings().contains("2017")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2017");
                        workinfo.addWarning("2017");
                    }
                } else if (workinfo.getWarnings().contains("2017")) {
                    workinfo.removeWarning("2017");
                }
                if (qpiwsStr.charAt(18) == '1') {
                    if (!workinfo.getWarnings().contains("2018")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2018");
                        workinfo.addWarning("2018");
                    }
                } else if (workinfo.getWarnings().contains("2018")) {
                    workinfo.removeWarning("2018");
                }
                if (qpiwsStr.charAt(19) == '1') {
                    if (!workinfo.getWarnings().contains("2019")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2019");
                        workinfo.addWarning("2019");
                    }
                } else if (workinfo.getWarnings().contains("2019")) {
                    workinfo.removeWarning("2019");
                }
                if (qpiwsStr.charAt(22) == '1') {
                    if (!workinfo.getWarnings().contains("2022")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2022");
                        workinfo.addWarning("2022");
                    }
                } else if (workinfo.getWarnings().contains("2022")) {
                    workinfo.removeWarning("2022");
                }
                if (qpiwsStr.charAt(23) == '1') {
                    if (!workinfo.getWarnings().contains("2023")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2023");
                        workinfo.addWarning("2023");
                    }
                } else if (workinfo.getWarnings().contains("2023")) {
                    workinfo.removeWarning("2023");
                }
                if (qpiwsStr.charAt(24) == '1') {
                    if (!workinfo.getWarnings().contains("2024")) {
                        EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2024");
                        workinfo.addWarning("2024");
                    }
                } else if (workinfo.getWarnings().contains("2024")) {
                    workinfo.removeWarning("2024");
                }
                if (qpiwsStr.charAt(10) != '1' && qpiwsStr.charAt(9) != '1' && qpiwsStr.charAt(8) != '1' && qpiwsStr.charAt(7) != '1') {
                    try {
                        if (qpiwsStr.charAt(25) == '1') {
                            if (!workinfo.getWarnings().contains("2008")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2008");
                                workinfo.addWarning("2008");
                            }
                        } else if (workinfo.getWarnings().contains("2008")) {
                            workinfo.getWarnings().remove("2008");
                        }
                        if (qpiwsStr.charAt(26) == '1') {
                            if (!workinfo.getWarnings().contains("2010")) {
                                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "2010");
                                workinfo.addWarning("2010");
                            }
                        } else if (workinfo.getWarnings().contains("2010")) {
                            workinfo.getWarnings().remove("2010");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (qpiwsStr.charAt(11) == '1' || qpiwsStr.charAt(10) == '1' || qpiwsStr.charAt(9) == '1' || qpiwsStr.charAt(8) == '1' || qpiwsStr.charAt(7) == '1') {
                    workinfo.setLineLoss(true);
                } else {
                    workinfo.setLineLoss(false);
                }
                if (qpiwsStr.charAt(3) == '1') {
                    workinfo.setPvLoss(true);
                } else {
                    workinfo.setPvLoss(false);
                }
                if (qpiwsStr.charAt(16) == '1') {
                    workinfo.setNoBattery(true);
                } else {
                    workinfo.setNoBattery(false);
                }
                if (qpiwsStr.charAt(18) == '1') {
                    workinfo.setOverLoad(true);
                } else {
                    workinfo.setOverLoad(false);
                }
            }
            Calendar machineTime = Calendar.getInstance();
            machineTime.setTime(workinfo.getCurrentTime());
            Calendar serverTime = Calendar.getInstance(usLocale);
            if (Math.abs(machineTime.getTimeInMillis() - serverTime.getTimeInMillis()) > (long)(GlobalVariables.globalConfig.getShowWarningForDatetime() * 60 * 1000)) {
                EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), "3003");
            }
            if (this.getFWVersion() >= 0.3f) {
                String qpicf = handler.excuteCommand("QPICF", true);
                if (!"".equals(qpicf) && !qpicf.equals("(NAK")) {
                    String[] qpicfArr = qpicf.split(" ");
                    String faultStatus = qpicfArr[0].substring(1);
                    String faultID = qpicfArr[1];
                    if (faultStatus.equals("00")) {
                        String qpihf;
                        if (!(faultID.equals(this._faultID) || "".equals(qpihf = handler.excuteCommand("QPIHF" + faultID, true)) || qpihf.equals("(NAK") || qpihf.startsWith("(00"))) {
                            this._faultID = faultID;
                            String[] qpifsArr = qpihf.split(" ");
                            String faultstr = qpifsArr[0].substring(1);
                            int kind = VolUtil.parseInt(faultstr);
                            if (kind > 0 && kind < 32) {
                                DataBeforeFault data = new DataBeforeFault();
                                String timeStr = qpifsArr[1];
                                data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                                data.setProdid(this.getProtocol().getProtocolID());
                                data.setSerialno(this.getProtocol().getSerialNo());
                                data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                                data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                                data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                                data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                                data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                                data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                                data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                                data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                                data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                                data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                                data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                                data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                                data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                                data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                                data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                                data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                                data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                                String runStatus = new String(qpifsArr[19]);
                                data.setRunStatus(runStatus);
                                FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                            }
                            workinfo.setFaultInfo(faultstr);
                        }
                    } else {
                        String qpihf = handler.excuteCommand("QPIHF" + faultID, true);
                        if (!("".equals(qpihf) || qpihf.equals("(NAK") || qpihf.startsWith("(00"))) {
                            this._faultID = faultID;
                            String[] qpifsArr = qpihf.split(" ");
                            String faultstr = qpifsArr[0].substring(1);
                            int kind = VolUtil.parseInt(faultstr);
                            if (kind > 0 && kind < 32) {
                                DataBeforeFault data = new DataBeforeFault();
                                String timeStr = qpifsArr[1];
                                data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                                data.setProdid(this.getProtocol().getProtocolID());
                                data.setSerialno(this.getProtocol().getSerialNo());
                                data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                                data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                                data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                                data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                                data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                                data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                                data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                                data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                                data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                                data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                                data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                                data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                                data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                                data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                                data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                                data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                                data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                                String runStatus = new String(qpifsArr[19]);
                                data.setRunStatus(runStatus);
                                FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                            }
                            workinfo.setFaultInfo(faultstr);
                        }
                    }
                }
            } else if (this.hasFault && !"".equals(qpifs = handler.excuteCommand("QPIFS", true)) && !qpifs.equals("(NAK") && !qpifs.equals("(OK")) {
                String[] qpifsArr = qpifs.split(" ");
                String faultstr = qpifsArr[0].substring(1);
                int kind = VolUtil.parseInt(faultstr);
                if (kind > 0 && kind < 28) {
                    DataBeforeFault data = new DataBeforeFault();
                    String timeStr = qpifsArr[1];
                    data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                    data.setProdid(this.getProtocol().getProtocolID());
                    data.setSerialno(this.getProtocol().getSerialNo());
                    data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                    data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                    data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                    data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                    data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                    data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                    data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                    data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                    data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                    data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                    data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                    data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                    data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                    data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                    data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                    data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                    data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                    String runStatus = new String(qpifsArr[19]);
                    data.setRunStatus(runStatus);
                    FaultHandler.doFaultEvent(faultstr, workinfo.getProdid(), workinfo.getSerialno(), data);
                } else {
                    this.logger.info((Object)("Fault:" + kind));
                }
                workinfo.setFaultInfo(faultstr);
            }
            this.reconnectTimes = 0;
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
            workinfo.clear();
            ++this.reconnectTimes;
        }
        return result;
    }

    @Override
    public boolean pollQuery() {
        if (!super.pollQuery()) {
            ++this.reconnectTimes;
            return false;
        }
        boolean result = true;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            this.close();
            return false;
        }
        WorkInfo workInfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            String qchgsStr;
            String qpibiStr;
            String qpigsStr;
            workInfo.setProdid(this.getProtocol().getProtocolID());
            workInfo.setSerialno(handler.getSerialNo());
            workInfo.setModelName(this.getProtocol().getModelName());
            if (this.currenttime != null) {
                workInfo.setCurrentTime(this.currenttime.getTime());
            }
            int mpptTrackNumber = 2;
            String qpiriStr = handler.excuteCommand("QPIRI", true);
            if (qpiriStr != null && !"".equals(qpiriStr) && !qpiriStr.equals("QPIRI")) {
                String[] arr = qpiriStr.split(" ");
                mpptTrackNumber = Integer.parseInt(arr[7]);
            }
            this.getProtocol().setMpptTrackNumber(mpptTrackNumber);
            String qmodStrs = handler.excuteCommand("QMOD", true);
            if (!"".equals(qmodStrs) && !qmodStrs.equals("(NAK")) {
                String qmodStr = qmodStrs.substring(1);
                String workMode = "Standby";
                workInfo.setFault(false);
                String modeType = this.getProtocol().getModelType();
                if (modeType.equals("00")) {
                    if (qmodStr.equals("P")) {
                        workMode = "Power On";
                    } else if (qmodStr.equals("S")) {
                        workMode = "Standby";
                    } else if (qmodStr.equals("Y")) {
                        workMode = "Bypass";
                    } else if (qmodStr.equals("L")) {
                        workMode = "Line";
                    } else if (!qmodStr.equals("B") && !qmodStr.equals("T")) {
                        if (qmodStr.equals("F")) {
                            workMode = "Fault";
                        } else if (qmodStr.equals("D")) {
                            workMode = "Shutdown";
                        } else if (qmodStr.equals("G")) {
                            workMode = "Grid";
                        } else {
                            qmodStr.equals("C");
                        }
                    }
                    workInfo.setWorkMode(workMode);
                } else {
                    boolean hasLoad = workInfo.isHasLoad();
                    boolean isLineLoss = workInfo.isLineLoss();
                    boolean isPvLoss = workInfo.isPvLoss();
                    if (qmodStr.equals("P")) {
                        workMode = "Power On";
                    } else if (qmodStr.equals("B")) {
                        workMode = "Inverter";
                    } else if (qmodStr.equals("G") && !isPvLoss) {
                        String grid = workInfo.getLineDirection();
                        workMode = this._protocol.getModelType().equals("01") && grid.equals("10") ? "Off-Grid with backup" : "Grid-tie with backup";
                    } else if (qmodStr.equals("G") && isPvLoss) {
                        String inv = workInfo.getInvDirection();
                        String bat = workInfo.getBatteryStatus();
                        String grid = workInfo.getLineDirection();
                        if (inv.equals("1") && hasLoad && bat.equals("01") && grid.equals("01")) {
                            workMode = "Bypass with AC charging";
                        } else if (inv.equals("1") && !hasLoad && bat.equals("01") && grid.equals("01")) {
                            workMode = "Standby with AC charging";
                        } else if (hasLoad && !bat.equals("01") && grid.equals("01")) {
                            workMode = "Bypass without charging";
                        } else if (!hasLoad && bat.equals("00")) {
                            workMode = "Standby without charging";
                        } else {
                            int check_pvfeedgrid = 1;
                            String retString = handler.excuteCommand("QENF", true);
                            if (!"".equals(retString) && !retString.equals("(NAK") && retString.length() > 15) {
                                check_pvfeedgrid = VolUtil.parseInt(retString.substring(6, 7));
                            }
                            workMode = this._protocol.getModelType().equals("01") || check_pvfeedgrid == 0 ? "Off-Grid with backup" : "Grid-tie with backup";
                        }
                    } else if (qmodStr.equals("C")) {
                        workMode = !isLineLoss && workInfo.getBatteryStatus().equals("01") && hasLoad ? "Bypass with PV charging" : "Standby with PV charging";
                    } else if (qmodStr.equals("S")) {
                        workMode = "Standby without charging";
                    } else if (qmodStr.equals("Y")) {
                        workMode = "Bypass without charging";
                    } else if (qmodStr.equals("F")) {
                        workInfo.setFault(true);
                        workMode = !isLineLoss && hasLoad ? (!isPvLoss && workInfo.getBatteryStatus().equals("01") ? "Bypass with PV charging" : "Bypass without charging") : (!isPvLoss && workInfo.getBatteryStatus().equals("01") ? "Standby with PV charging" : "Standby without charging");
                    }
                    workInfo.setWorkMode(workMode);
                }
            }
            if (!"".equals(qpigsStr = handler.excuteCommand("QPIGS", true)) && !qpigsStr.equals("(NAK")) {
                String[] qpigsArr = qpigsStr.split(" ");
                double gridVoltageR = VolUtil.parseDouble(qpigsArr[0].substring(1));
                workInfo.setGridVoltageR(gridVoltageR);
                String gridPowerRStr = qpigsArr[1];
                double gridPowerR = 0.0;
                gridPowerR = gridPowerRStr.charAt(0) == '0' ? VolUtil.parseDouble(gridPowerRStr.substring(1)) : -VolUtil.parseDouble(gridPowerRStr.substring(1));
                workInfo.setGridPowerR(gridPowerR);
                double gridFrequency = VolUtil.parseDouble(qpigsArr[2]);
                workInfo.setGridFrequency(gridFrequency);
                String gridCurrentRStr = qpigsArr[3];
                double gridCurrentR = 0.0;
                gridCurrentR = gridCurrentRStr.charAt(0) == '0' ? VolUtil.parseDouble(gridCurrentRStr.substring(1)) : -VolUtil.parseDouble(gridCurrentRStr.substring(1));
                workInfo.setGridCurrentR(gridCurrentR);
                double acOutputVoltageR = VolUtil.parseDouble(qpigsArr[4]);
                workInfo.setAcOutputVoltageR(acOutputVoltageR);
                int acOutputPowerR = VolUtil.parseInt(qpigsArr[5]);
                workInfo.setAcOutputPowerR(acOutputPowerR);
                double acOutputFrequency = VolUtil.parseDouble(qpigsArr[6]);
                workInfo.setAcOutputFrequency(acOutputFrequency);
                double acOutputCurrentR = VolUtil.parseDouble(qpigsArr[7]);
                workInfo.setAcOutputCurrentR(acOutputCurrentR);
                int outputLoadPercent = VolUtil.parseInt(qpigsArr[8]);
                workInfo.setOutputLoadPercent(outputLoadPercent);
                double pBusVoltage = VolUtil.parseDouble(qpigsArr[9]);
                workInfo.setPBUSVoltage(pBusVoltage);
                double sBusVoltage = VolUtil.parseDouble(qpigsArr[10]);
                workInfo.setSBUSVoltage(sBusVoltage);
                double pBatteryVoltage = VolUtil.parseDouble(qpigsArr[11]);
                workInfo.setPBatteryVoltage(pBatteryVoltage);
                double nBatteryVoltage = VolUtil.parseDouble(qpigsArr[12]);
                workInfo.setNBatteryVoltage(nBatteryVoltage);
                int batteryCapacity = VolUtil.parseInt(qpigsArr[13]);
                workInfo.setBatteryCapacity(batteryCapacity);
                int pvInputPower1 = VolUtil.parseInt(qpigsArr[14]);
                workInfo.setPvInputPower1(pvInputPower1);
                int pvInputPower2 = VolUtil.parseInt(qpigsArr[15]);
                workInfo.setPvInputPower2(pvInputPower2);
                int pvInputPower3 = VolUtil.parseInt(qpigsArr[16]);
                workInfo.setPvInputPower3(pvInputPower3);
                double pvInputVoltage1 = VolUtil.parseDouble(qpigsArr[17]);
                workInfo.setPvInputVoltage1(pvInputVoltage1);
                double pvInputVoltage2 = VolUtil.parseDouble(qpigsArr[18]);
                workInfo.setPvInputVoltage2(pvInputVoltage2);
                double pvInputVoltage3 = VolUtil.parseDouble(qpigsArr[19]);
                workInfo.setPvInputVoltage3(pvInputVoltage3);
                double maxTemperature = VolUtil.parseDouble(qpigsArr[20]);
                workInfo.setMaxTemperature(maxTemperature);
                String deviceStatus = qpigsArr[21];
                if (deviceStatus.charAt(1) == '1') {
                    workInfo.setEpoActive(true);
                } else {
                    workInfo.setEpoActive(false);
                }
                if (deviceStatus.charAt(4) == '1') {
                    workInfo.setHasLoad(true);
                } else {
                    workInfo.setHasLoad(false);
                }
                String batteryStatus = deviceStatus.substring(5, 7);
                if (batteryStatus.equals("00")) {
                    workInfo.setBatteryStatus("00");
                } else if (batteryStatus.equals("01")) {
                    workInfo.setBatteryStatus("01");
                } else if (batteryStatus.equals("10")) {
                    workInfo.setBatteryStatus("10");
                }
                if (deviceStatus.charAt(7) == '1') {
                    workInfo.setInvDirection("1");
                } else {
                    workInfo.setInvDirection("0");
                }
                String lineDirection = deviceStatus.substring(8, 10);
                if (lineDirection.equals("00")) {
                    workInfo.setLineDirection("00");
                } else if (lineDirection.equals("01")) {
                    workInfo.setLineDirection("01");
                } else if (lineDirection.equals("10")) {
                    workInfo.setLineDirection("10");
                }
            }
            if (!"".equals(qpibiStr = handler.excuteCommand("QPIBI", true)) && !qpibiStr.equals("(NAK")) {
                String[] qpibiArr = qpibiStr.split(" ");
                int batteryPieceNumber = VolUtil.parseInt(qpibiArr[1]);
                int batteryTotalCapacity = VolUtil.parseInt(qpibiArr[2]);
                int batteryRemainTime = VolUtil.parseInt(qpibiArr[4]);
                workInfo.setBatteryPieceNumber(batteryPieceNumber);
                workInfo.setBatteryTotalCapacity(batteryTotalCapacity);
                workInfo.setBatteryRemainTime(batteryRemainTime);
            }
            if (!"".equals(qchgsStr = handler.excuteCommand("QCHGS", true)) && !qchgsStr.equals("(NAK")) {
                String[] qchgsArr = qchgsStr.split(" ");
                double chargingCurrent = VolUtil.parseDouble(qchgsArr[0].substring(1));
                workInfo.setChargingCurrent(chargingCurrent);
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean queryMachineInfo() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        boolean result = true;
        MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        try {
            Date date;
            String qpiriStr;
            String qmdStr;
            String slaveFirmwareVersion;
            String mainFirmwareVersion = handler.excuteCommand("QVFW", true);
            if (!"".equals(mainFirmwareVersion) && !mainFirmwareVersion.equals("(NAK")) {
                machineInfo.setMainFirmwareVersion(mainFirmwareVersion.substring(7));
            }
            if (!"".equals(slaveFirmwareVersion = handler.excuteCommand("QVFW2", true)) && !slaveFirmwareVersion.equals("(NAK")) {
                machineInfo.setSlaveFirmwareVersion(slaveFirmwareVersion.substring(8));
            }
            if (!"".equals(qmdStr = handler.excuteCommand("QMD", true)) && !qmdStr.equals("(NAK")) {
                String[] deviceMode = qmdStr.split(" ");
                String outputVAStr = deviceMode[1];
                if (outputVAStr.indexOf("#") != -1) {
                    outputVAStr = outputVAStr.substring(outputVAStr.lastIndexOf("#") + 1);
                }
                double outputRateVA = VolUtil.parseDouble(outputVAStr);
                double outputPowerFactor = VolUtil.parseDouble(deviceMode[2]);
                String ioPhase = deviceMode[3];
                double nominalInputVoltage = VolUtil.parseDouble(deviceMode[4]);
                double nominalOutputVoltage = VolUtil.parseDouble(deviceMode[5]);
                int batteryPieceNumber = VolUtil.parseInt(deviceMode[6]);
                double batteryStandVoltage = VolUtil.parseDouble(deviceMode[7]);
                machineInfo.setOutputRateVA(outputRateVA);
                machineInfo.setOutputPowerFactor(outputPowerFactor);
                machineInfo.setIoPhase(ioPhase);
                machineInfo.setNominalInputVoltage(nominalInputVoltage);
                machineInfo.setNominalOutputVoltage(nominalOutputVoltage);
                machineInfo.setBatteryPieceNumber(batteryPieceNumber);
                machineInfo.setBatteryStandVoltage(batteryStandVoltage);
            }
            if (!"".equals(qpiriStr = handler.excuteCommand("QPIRI", true)) && !qpiriStr.equals("(NAK")) {
                String[] ratingInfo = qpiriStr.split(" ");
                double gridRatingVoltage = VolUtil.parseDouble(ratingInfo[0].substring(1));
                double gridRatingFrequency = VolUtil.parseDouble(ratingInfo[1]);
                double gridRatingCurrent = VolUtil.parseDouble(ratingInfo[2]);
                double acOutputRatingVoltage = VolUtil.parseDouble(ratingInfo[3]);
                double acOutputRatingCurrent = VolUtil.parseDouble(ratingInfo[4]);
                double perMPPTRatingCurrent = VolUtil.parseDouble(ratingInfo[5]);
                double batteryRatingVoltage = VolUtil.parseDouble(ratingInfo[6]);
                int mpptTrackNumber = VolUtil.parseInt(ratingInfo[7]);
                String machineTypeStr = ratingInfo[8];
                String topologyStr = ratingInfo[9];
                machineInfo.setGridRatingVoltage(gridRatingVoltage);
                machineInfo.setGridRatingFrequency(gridRatingFrequency);
                machineInfo.setAcOutputRatingVoltage(acOutputRatingVoltage);
                machineInfo.setAcOutputRatingCurrent(acOutputRatingCurrent);
                machineInfo.setGridRatingCurrent(gridRatingCurrent);
                machineInfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
                machineInfo.setBatteryRatingVoltage(batteryRatingVoltage);
                machineInfo.setMpptTrackNumber(mpptTrackNumber);
                String machineType = "";
                if (machineTypeStr.equals("00")) {
                    machineType = "Grid - Tie";
                } else if (machineTypeStr.equals("01")) {
                    machineType = "Off-Grid";
                } else if (machineTypeStr.equals("10")) {
                    machineType = "Hybrid";
                }
                machineInfo.setMachineType(machineType);
                this.getProtocol().setModelType(machineTypeStr);
                String topology = "";
                if (topologyStr.equals("0")) {
                    topology = "transformerless";
                } else if (topologyStr.equals("1")) {
                    topology = "transformer";
                }
                machineInfo.setTopology(topology);
            }
            if (machineInfo.getAcOutputRatingVoltage() > 180.0) {
                machineInfo.setMinACInputLowV(170.0);
                machineInfo.setMaxACInputHighV(280.0);
                if (machineInfo.getGridRatingFrequency() == 50.0) {
                    machineInfo.setMinACInputLowF(40.0);
                    machineInfo.setMaxACInputHighF(55.0);
                } else {
                    machineInfo.setMinACInputLowF(55.0);
                    machineInfo.setMaxACInputHighF(65.0);
                }
            } else {
                if (machineInfo.getAcOutputRatingVoltage() < 120.0) {
                    machineInfo.setMinACInputLowV(80.0);
                    machineInfo.setMaxACInputHighV(130.0);
                } else {
                    machineInfo.setMinACInputLowV(80.0);
                    machineInfo.setMaxACInputHighV(150.0);
                }
                if (machineInfo.getGridRatingFrequency() == 50.0) {
                    machineInfo.setMinACInputLowF(40.0);
                    machineInfo.setMaxACInputHighF(55.0);
                } else {
                    machineInfo.setMinACInputLowF(55.0);
                    machineInfo.setMaxACInputHighF(65.0);
                }
            }
            String qfetStr = handler.excuteCommand("QFET", true);
            if (!"".equals(qfetStr) && !qfetStr.equals("(NAK") && (date = DateUtils.parseDate(qfetStr.substring(1), "yyyyMMddHH")) != null) {
                this.enerystarttime = Calendar.getInstance();
                this.enerystarttime.setTime(date);
                WebServices web = new WebServices();
                if (!web.doEnergyBeginDate(this.getProtocol().getProtocolID(), this.getProtocol().getSerialNo(), this.enerystarttime)) {
                    result = false;
                }
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean queryCapability() {
        boolean result = true;
        boolean reversion = false;
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        try {
            String qbyv;
            String qflagStr = handler.excuteCommand("QFLAG", true);
            if (this._protocol.getMCUVersion().compareTo("13-05-16") >= 0 && this._protocol.getMCUVersion().compareTo("13-07-04") <= 0) {
                reversion = true;
            }
            if (!"".equals(qflagStr) && !qflagStr.equals("(NAK")) {
                String before = qflagStr.substring(qflagStr.indexOf("E"), qflagStr.indexOf("D"));
                if (before.indexOf(97) != -1) {
                    capability.setCapableA(!reversion);
                } else {
                    capability.setCapableA(reversion);
                }
                if (before.indexOf(98) != -1) {
                    capability.setCapableB(true);
                } else {
                    capability.setCapableB(false);
                }
                if (before.indexOf(112) != -1) {
                    capability.setCapableP(!reversion);
                } else {
                    capability.setCapableP(reversion);
                }
                if (before.indexOf(103) != -1) {
                    capability.setCapableG(true);
                } else {
                    capability.setCapableG(false);
                }
                if (before.indexOf(99) != -1) {
                    capability.setCapableC(true);
                } else {
                    capability.setCapableC(false);
                }
                if (before.indexOf(100) != -1) {
                    capability.setCapableD(true);
                } else {
                    capability.setCapableD(false);
                }
                if (before.indexOf(101) != -1) {
                    capability.setCapableE(true);
                } else {
                    capability.setCapableE(false);
                }
                if (before.indexOf(102) != -1) {
                    capability.setCapableF(true);
                } else {
                    capability.setCapableF(false);
                }
            }
            capability.setGntm(false);
            if (this.getProtocol().isSupportModelSetting() && !"".equals(qbyv = handler.excuteCommand("GNTMQ", true)) && !qbyv.equals("(NAK") && qbyv.length() >= 2 && qbyv.substring(2, 3).equals("1")) {
                capability.setGntm(true);
            }
        }
        catch (Exception e) {
            result = false;
            System.err.println(e.getMessage());
        }
        return result;
    }

    @Override
    public Calendar queryCurrentTime() {
        String timeStr;
        Calendar ca;
        block7: {
            block6: {
                IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
                if (handler == null) {
                    return null;
                }
                try {
                    ca = null;
                    timeStr = handler.excuteCommand("QT", true);
                    if (!"".equals(timeStr) && !timeStr.equals("(NAK")) break block6;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            if (timeStr.trim().length() == 15) break block7;
            return null;
        }
        Date date = DateUtils.parseDate(timeStr.substring(1), "yyyyMMddHHmmss");
        if (date != null) {
            ca = Calendar.getInstance();
            ca.setTime(date);
        }
        return ca;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyDay(Calendar trandate) throws Exception {
        Object object = this.query_day;
        synchronized (object) {
            double energyDay = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            Calendar calendar = (Calendar)trandate.clone();
            String value = DateUtils.getFormatDate(calendar.getTime(), "yyyyMMdd");
            String validate = this.getValidate("QED" + value);
            String qedStr = handler.excuteCommand("QED" + value + validate, true);
            if (qedStr == null || "".equals(qedStr) || qedStr.equals("(NAK") || qedStr.length() != 7) {
                throw new Exception("query day energy error");
            }
            String qedValue = qedStr.substring(1);
            energyDay = this.parseDoubleV(qedValue);
            return energyDay;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyHour(Calendar trandate, int hour) throws Exception {
        Object object = this.query_hour;
        synchronized (object) {
            double energyHour = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            Calendar calendar = (Calendar)trandate.clone();
            String hourStr = String.valueOf(hour).length() < 2 ? "0" + hour : String.valueOf(hour);
            String value = String.valueOf(DateUtils.getFormatDate(calendar.getTime(), "yyyyMMdd")) + hourStr;
            String validate = this.getValidate("QEH" + value);
            String qehStr = handler.excuteCommand("QEH" + value + validate, true);
            if (qehStr == null || "".equals(qehStr) || qehStr.equals("(NAK") || qehStr.length() != 6) {
                throw new Exception("query hour energy error");
            }
            String qehValue = qehStr.substring(1);
            energyHour = this.parseDoubleV(qehValue);
            return energyHour;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyMonth(int year, int month) throws Exception {
        Object object = this.query_month;
        synchronized (object) {
            double energyMonth = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String monthStr = String.valueOf(month).length() < 2 ? "0" + month : String.valueOf(month);
            String value = year + monthStr;
            String validate = this.getValidate("QEM" + value);
            String qemStr = handler.excuteCommand("QEM" + value + validate, true);
            if (qemStr == null || "".equals(qemStr) || qemStr.equals("(NAK") || qemStr.length() != 8) {
                throw new Exception("query month energy error");
            }
            String qemValue = qemStr.substring(1);
            energyMonth = this.parseDoubleV(qemValue);
            return energyMonth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double queryEnergyYear(int year) throws Exception {
        Object object = this.query_year;
        synchronized (object) {
            double energyYear = 0.0;
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            String value = "" + year;
            String validate = this.getValidate("QEY" + value);
            String qeyStr = handler.excuteCommand("QEY" + value + validate, true);
            if (qeyStr == null || "".equals(qeyStr) || qeyStr.equals("(NAK") || qeyStr.length() != 9) {
                throw new Exception("query year energy error");
            }
            String qeyValue = qeyStr.substring(1);
            energyYear = this.parseDoubleV(qeyValue);
            return energyYear;
        }
    }

    @Override
    public boolean queryConfigData() {
        boolean result = true;
        try {
            String qmdcc;
            String queryQOPF;
            String qacchc;
            String qaccv;
            String retString;
            String[] splitArray;
            String queryQPIRI;
            String qmpptv;
            String qlstStr;
            String qpvipv;
            String qopmpStr;
            String qmd;
            String qftStr;
            String qgof;
            String qgov;
            String qbsdvStr;
            String qchgsStr;
            String qbyf;
            String qbyv;
            String qfpra;
            ConfigData configdata = (ConfigData)this.getBeanBag().getBean("configdata");
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                throw new Exception("handler is null");
            }
            if (this.getFWVersion() >= 0.3f) {
                String qvftrStr = handler.excuteCommand("QVFTR", true);
                if (!"".equals(qvftrStr) && !qvftrStr.equals("(NAK")) {
                    String[] queryQvftrStr = qvftrStr.split(" ");
                    double maxGridOutputHighV = VolUtil.parseDouble(queryQvftrStr[0].substring(1));
                    double minGridOutputHighV = VolUtil.parseDouble(queryQvftrStr[1]);
                    double maxGridOutputLowV = VolUtil.parseDouble(queryQvftrStr[2]);
                    double minGridOutputLowV = VolUtil.parseDouble(queryQvftrStr[3]);
                    configdata.setMaxGridoutputhighV(maxGridOutputHighV);
                    configdata.setMinGridoutputhighV(minGridOutputHighV);
                    configdata.setMaxGridoutputlowV(maxGridOutputLowV);
                    configdata.setMinGridoutputlowV(minGridOutputLowV);
                    configdata.setMaxGridInputHighV(maxGridOutputHighV);
                    configdata.setMinGridInputHighV(minGridOutputHighV);
                    configdata.setMaxGridInputLowV(maxGridOutputLowV);
                    configdata.setMinGridInputLowV(minGridOutputLowV);
                    double maxGridOutputHighF = VolUtil.parseDouble(queryQvftrStr[4]);
                    double minGridOutputHighF = VolUtil.parseDouble(queryQvftrStr[5]);
                    double maxGridOutputLowF = VolUtil.parseDouble(queryQvftrStr[6]);
                    double minGridOutputLowF = VolUtil.parseDouble(queryQvftrStr[7]);
                    configdata.setMaxGridoutputhighF(maxGridOutputHighF);
                    configdata.setMinGridoutputhighF(minGridOutputHighF);
                    configdata.setMaxGridoutputlowF(maxGridOutputLowF);
                    configdata.setMinGridoutputlowF(minGridOutputLowF);
                    configdata.setMaxGridInputHighF(maxGridOutputHighF);
                    configdata.setMinGridInputHighF(minGridOutputHighF);
                    configdata.setMaxGridInputLowF(maxGridOutputLowF);
                    configdata.setMinGridInputLowF(minGridOutputLowF);
                    int maxWaittime = VolUtil.parseInt(queryQvftrStr[8]);
                    int minWaittime = VolUtil.parseInt(queryQvftrStr[9]);
                    configdata.setMaxGridWaittime(maxWaittime);
                    configdata.setMinGridWaittime(minWaittime);
                    double maxMaxFloatingV = VolUtil.parseDouble(queryQvftrStr[10]);
                    double minMaxFloatingV = VolUtil.parseDouble(queryQvftrStr[11]);
                    configdata.setMaxFloatingVoltage(maxMaxFloatingV);
                    configdata.setMinFloatingVoltage(minMaxFloatingV);
                    try {
                        double maxMaxChargingCurrent = Double.parseDouble(queryQvftrStr[12]);
                        double minMaxChargingCurrent = Double.parseDouble(queryQvftrStr[13]);
                        int maxPvInputHighV = Integer.parseInt(queryQvftrStr[14]);
                        int minPvInputHighV = Integer.parseInt(queryQvftrStr[15]);
                        int maxPvInputLowV = Integer.parseInt(queryQvftrStr[16]);
                        int minPvInputLowV = Integer.parseInt(queryQvftrStr[17]);
                        int maxMpptHighV = Integer.parseInt(queryQvftrStr[18]);
                        int minMpptHighV = Integer.parseInt(queryQvftrStr[19]);
                        int maxMpptLowV = Integer.parseInt(queryQvftrStr[20]);
                        int minMpptLowV = Integer.parseInt(queryQvftrStr[21]);
                        double maxMaxChargingV = VolUtil.parseDouble(queryQvftrStr[24]);
                        double minMaxChargingV = VolUtil.parseDouble(queryQvftrStr[25]);
                        configdata.setMaxMaxChargingCurrent(maxMaxChargingCurrent);
                        configdata.setMinMaxChargingCurrent(minMaxChargingCurrent);
                        configdata.setMaxPvInputHighV(maxPvInputHighV);
                        configdata.setMinPvInputHighV(minPvInputHighV);
                        configdata.setMaxPvInputLowV(maxPvInputLowV);
                        configdata.setMinPvInputLowV(minPvInputLowV);
                        configdata.setMaxMpptHighV(maxMpptHighV);
                        configdata.setMinMpptHighV(minMpptHighV);
                        configdata.setMaxMpptLowV(maxMpptLowV);
                        configdata.setMinMpptLowV(minMpptLowV);
                        configdata.setMaxMaxChargingVoltage(maxMaxChargingV);
                        configdata.setMinMaxChargingVoltage(minMaxChargingV);
                    }
                    catch (Exception ex) {
                        configdata.setMaxMaxChargingCurrent(25.0);
                        configdata.setMinMaxChargingCurrent(0.5);
                        configdata.setMaxPvInputHighV(510);
                        configdata.setMinPvInputHighV(450);
                        configdata.setMaxPvInputLowV(200);
                        configdata.setMinPvInputLowV(90);
                        configdata.setMaxMpptHighV(450);
                        configdata.setMinMpptHighV(400);
                        configdata.setMaxMpptLowV(200);
                        configdata.setMinMpptLowV(110);
                        configdata.setMaxMaxChargingVoltage(50.0);
                        configdata.setMinMaxChargingVoltage(57.0);
                    }
                }
                configdata.setMaxCutoffVoltage(51.0);
                if (this.getProtocol().getModelName().equals("000")) {
                    configdata.setMinCutoffVoltage(40.0);
                } else {
                    configdata.setMinCutoffVoltage(42.0);
                }
            } else {
                String queryFrequency = handler.excuteCommand("QPIRI", true);
                if (!"".equals(queryFrequency) && !queryFrequency.equals("(NAK")) {
                    String[] queryFrequencyStr = queryFrequency.split(" ");
                    double frequency = VolUtil.parseDouble(queryFrequencyStr[1]);
                    if (frequency == 50.0) {
                        configdata.setMinGridoutputlowF(45.0);
                        configdata.setMaxGridoutputlowF(49.8);
                        configdata.setMinGridoutputhighF(50.2);
                        configdata.setMaxGridoutputhighF(54.8);
                        configdata.setMinGridInputLowF(45.0);
                        configdata.setMaxGridInputLowF(49.8);
                        configdata.setMinGridInputHighF(50.2);
                        configdata.setMaxGridInputHighF(54.8);
                    } else if (frequency == 60.0) {
                        configdata.setMinGridoutputlowF(55.0);
                        configdata.setMaxGridoutputlowF(59.8);
                        configdata.setMinGridoutputhighF(60.2);
                        configdata.setMaxGridoutputhighF(64.8);
                        configdata.setMinGridInputLowF(55.0);
                        configdata.setMaxGridInputLowF(59.8);
                        configdata.setMinGridInputHighF(60.2);
                        configdata.setMaxGridInputHighF(64.8);
                        configdata.setMinMaxChargingVoltage(47.0);
                        configdata.setMaxMaxChargingVoltage(57.0);
                    }
                }
                configdata.setMinGridWaittime(5);
                configdata.setMaxGridWaittime(999);
                configdata.setMinGridoutputlowV(176.0);
                configdata.setMaxGridoutputlowV(220.0);
                configdata.setMinGridoutputhighV(240.0);
                configdata.setMaxGridoutputhighV(276.0);
                configdata.setMinGridInputLowV(175.0);
                configdata.setMaxGridInputLowV(220.0);
                configdata.setMinGridInputHighV(240.0);
                configdata.setMaxGridInputHighV(280.0);
                configdata.setMaxMaxChargingCurrent(25.0);
                configdata.setMinMaxChargingCurrent(0.5);
                configdata.setMaxPvInputHighV(510);
                configdata.setMinPvInputHighV(450);
                configdata.setMaxPvInputLowV(200);
                configdata.setMinPvInputLowV(90);
                configdata.setMaxMpptHighV(450);
                configdata.setMinMpptHighV(400);
                configdata.setMaxMpptLowV(200);
                configdata.setMinMpptLowV(110);
                configdata.setMaxCutoffVoltage(51.0);
                if (this.getProtocol().getModelName().equals("000")) {
                    configdata.setMinCutoffVoltage(40.0);
                } else {
                    configdata.setMinCutoffVoltage(42.0);
                }
            }
            if (this.getProtocol().getMCUVersion().compareTo("17-07-11") >= 0 && !"".equals(qfpra = handler.excuteCommand("QFPRA", true)) && !qfpra.equals("(NAK")) {
                double feefInReactivePower = 0.0;
                feefInReactivePower = VolUtil.parseDouble(qfpra.substring(1));
                if (feefInReactivePower > 3000.0) {
                    configdata.setFeefInReactivePower(0.0);
                } else {
                    configdata.setFeefInReactivePower(feefInReactivePower);
                }
                configdata.setMinfeefInReactivePower(-1500.0);
                configdata.setMaxfeefInReactivePower(1500.0);
            }
            if (!"".equals(qbyv = handler.excuteCommand("QGOV", true)) && !qbyv.equals("(NAK")) {
                String[] qbyvArr = qbyv.split(" ");
                double gridInputHighV = VolUtil.parseDouble(qbyvArr[0].substring(1));
                double gridInputLowV = VolUtil.parseDouble(qbyvArr[1]);
                configdata.setGridInputHighV(gridInputHighV);
                configdata.setGridInputLowV(gridInputLowV);
            }
            if (!"".equals(qbyf = handler.excuteCommand("QGOF", true)) && !qbyf.equals("(NAK")) {
                String[] qbyfArr = qbyf.split(" ");
                double gridInputHighF = VolUtil.parseDouble(qbyfArr[0].substring(1));
                double gridInputLowF = VolUtil.parseDouble(qbyfArr[1]);
                configdata.setGridInputHighF(gridInputHighF);
                configdata.setGridInputLowF(gridInputLowF);
            }
            if (!"".equals(qchgsStr = handler.excuteCommand("QCHGS", true)) && !qchgsStr.equals("(NAK")) {
                String[] qchgsArr = qchgsStr.split(" ");
                double floatVoltage = VolUtil.parseDouble(qchgsArr[1]);
                double maxChargingCurrent = VolUtil.parseDouble(qchgsArr[2]);
                double maxChargingVoltage = VolUtil.parseDouble(qchgsArr[3]);
                configdata.setFloatingVoltage(floatVoltage);
                configdata.setMaxChargingCurrent(maxChargingCurrent);
                configdata.setMaxChargingVoltage(maxChargingVoltage);
                if (!this.getProtocol().getModelName().equals("000")) {
                    configdata.setMaxFloatingVoltage(configdata.getMaxChargingVoltage());
                }
            }
            if (!"".equals(qbsdvStr = handler.excuteCommand("QBSDV", true)) && !qbsdvStr.equals("(NAK")) {
                String[] qchgsArr = qbsdvStr.split(" ");
                double cutoffVoltage = VolUtil.parseDouble(qchgsArr[0].substring(1));
                configdata.setCutoffVoltageGridLoss(cutoffVoltage);
                configdata.setMinCutoffVoltageGridLoss(40.0);
                configdata.setMaxCutoffVoltageGridLoss(51.0);
                if (qchgsArr.length >= 4) {
                    configdata.setCutoffVoltage(VolUtil.parseDouble(qchgsArr[1]));
                    if (this.getProtocol().getModelName().equals("000")) {
                        configdata.setMinCutoffVoltage(40.0);
                    } else {
                        configdata.setMinCutoffVoltage(42.0);
                    }
                    configdata.setMaxCutoffVoltage(51.0);
                    configdata.setRecoverVoltageGridLoss(VolUtil.parseDouble(qchgsArr[2]));
                    if (this.getProtocol().getModelName().equals("000")) {
                        configdata.setMinRecoverVoltageGridLoss(42.0);
                        configdata.setMaxRecoverVoltageGridLoss(62.0);
                    } else {
                        configdata.setMinRecoverVoltageGridLoss(configdata.getCutoffVoltageGridLoss());
                        configdata.setMaxRecoverVoltageGridLoss(configdata.getFloatingVoltage());
                    }
                    configdata.setRecoverVoltage(VolUtil.parseDouble(qchgsArr[3]));
                    if (this.getProtocol().getModelName().equals("000")) {
                        configdata.setMinRecoverVoltage(42.0);
                        configdata.setMaxRecoverVoltage(62.0);
                    } else {
                        configdata.setMinRecoverVoltage(configdata.getCutoffVoltage());
                        configdata.setMaxRecoverVoltage(configdata.getFloatingVoltage());
                    }
                }
            }
            if (!"".equals(qgov = handler.excuteCommand("QGOV", true)) && !qgov.equals("(NAK")) {
                String[] qgovStr = qgov.split(" ");
                double gridOutputHighV = VolUtil.parseDouble(qgovStr[0].substring(1));
                double gridOutputLowV = VolUtil.parseDouble(qgovStr[1]);
                configdata.setGridoutputhighV(gridOutputHighV);
                configdata.setGridoutputlowV(gridOutputLowV);
            }
            if (!"".equals(qgof = handler.excuteCommand("QGOF", true)) && !qgof.equals("(NAK")) {
                String[] qgofStr = qgof.split(" ");
                double gridOutputHighF = VolUtil.parseDouble(qgofStr[0].substring(1));
                double gridOutputLowF = VolUtil.parseDouble(qgofStr[1]);
                configdata.setGridoutputhighF(gridOutputHighF);
                configdata.setGridoutputlowF(gridOutputLowF);
            }
            if (!"".equals(qftStr = handler.excuteCommand("QFT", true)) && !qftStr.equals("(NAK")) {
                int waitingTime = VolUtil.parseInt(qftStr.substring(1));
                configdata.setGridwaittime(waitingTime);
            }
            if (!"".equals(qmd = handler.excuteCommand("QMD", true)) && !qmd.equals("(NAK")) {
                String[] deviceMode = qmd.split(" ");
                String outputVAStr = deviceMode[1];
                if (outputVAStr.indexOf("#") != -1) {
                    outputVAStr = outputVAStr.substring(outputVAStr.lastIndexOf("#") + 1);
                }
                int outputRateVA = VolUtil.parseInt(outputVAStr);
                configdata.setMinMaxoutputPower(0);
                configdata.setMaxMaxoutputPower(outputRateVA);
            }
            if (!"".equals(qopmpStr = handler.excuteCommand("QOPMP", true)) && !qopmpStr.equals("(NAK")) {
                int maxOutputPower = VolUtil.parseInt(qopmpStr.substring(1));
                configdata.setMaxoutputPower(maxOutputPower);
            }
            if (!"".equals(qpvipv = handler.excuteCommand("QPVIPV", true)) && !qpvipv.equals("(NAK")) {
                String[] qpvipvStr = qpvipv.split(" ");
                int upperLimitInputV = VolUtil.parseInt(qpvipvStr[0].substring(1));
                int lowestLimtInputV = VolUtil.parseInt(qpvipvStr[1]);
                configdata.setPvInputLowV(lowestLimtInputV);
                configdata.setPvInputHighV(upperLimitInputV);
            }
            if (!"".equals(qlstStr = handler.excuteCommand("QLST", true)) && !qlstStr.equals("(NAK")) {
                String lcdSleepTime = qlstStr.substring(1);
                configdata.setLcdSleepTime(lcdSleepTime);
            }
            configdata.setMaxGridAvgHighV(265);
            configdata.setMinGridAvgHighV(235);
            String qgltv = handler.excuteCommand("QGLTV", true);
            if (!"".equals(qgltv) && !qgltv.equals("(NAK")) {
                String[] qgltvStr = qgltv.split(" ");
                int gridInputAverageHighV = VolUtil.parseInt(qgltvStr[0].substring(1));
                int gridInputAverageLowV = VolUtil.parseInt(qgltvStr[1]);
                configdata.setGridAvgHighV(gridInputAverageHighV);
                configdata.setGridAvgLowV(gridInputAverageLowV);
            }
            if (!"".equals(qmpptv = handler.excuteCommand("QMPPTV", true)) && !qmpptv.equals("(NAK")) {
                String[] qmpptvStr = qmpptv.split(" ");
                int highVoltage = VolUtil.parseInt(qmpptvStr[0].substring(1));
                int lowVoltage = VolUtil.parseInt(qmpptvStr[1]);
                configdata.setMpptHighV(highVoltage);
                configdata.setMpptLowV(lowVoltage);
            }
            if (!"".equals(queryQPIRI = handler.excuteCommand("QPIRI", true)) && !queryQPIRI.equals("(NAK")) {
                String[] queryQPIRIStr = queryQPIRI.split(" ");
                int queryPVN = VolUtil.parseInt(queryQPIRIStr[7]);
                double gridRatingVoltage = VolUtil.parseDouble(queryQPIRIStr[0].substring(1));
                double gridRatingFrequency = VolUtil.parseDouble(queryQPIRIStr[1]);
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                configdata.setNominalVoltage(gridRatingVoltage);
                configdata.setNominalFreq(gridRatingFrequency);
                machineInfo.setGridRatingVoltage(gridRatingVoltage);
                machineInfo.setGridRatingFrequency(gridRatingFrequency);
                configdata.setPvnNumber(queryPVN);
                String machineTypeStr = queryQPIRIStr[8];
                if (machineTypeStr.equals("00")) {
                    machineInfo.setMachineType("Grid-Tie");
                } else if (machineTypeStr.equals("01")) {
                    machineInfo.setMachineType("Off-Grid");
                } else if (machineTypeStr.equals("10")) {
                    machineInfo.setMachineType("Hybrid");
                } else if (machineTypeStr.equals("11")) {
                    machineInfo.setMachineType("Self-Use");
                }
                this.getProtocol().setModelType(machineTypeStr);
            }
            if (this.getProtocol().isSupportModelSetting()) {
                String retString2;
                configdata.setMaxPowerFeedGrid(configdata.getMaxoutputPower());
                String qgpmp = handler.excuteCommand("QGPMP", true);
                if (!"".equals(qgpmp) && !qgpmp.equals("(NAK")) {
                    String[] qmpptvStr = qgpmp.split(" ");
                    int maxfeedgrid = VolUtil.parseInt(qmpptvStr[0].substring(1));
                    configdata.setMinMaxoutputPower(maxfeedgrid);
                    configdata.setPowerfeedGrid(maxfeedgrid);
                }
                if (!"".equals(retString2 = handler.excuteCommand("QPRIO", true)) && !retString2.equals("(NAK")) {
                    configdata.setPlanID(retString2.substring(1, 3));
                }
                if (!"".equals(retString2 = handler.excuteCommand("QENF", true)) && !retString2.equals("(NAK") && retString2.length() > 15) {
                    configdata.setCheck_charge(VolUtil.parseInt(retString2.substring(2, 3)));
                    configdata.setCheck_accharge(VolUtil.parseInt(retString2.substring(4, 5)));
                    configdata.setCheck_pvfeedgrid(VolUtil.parseInt(retString2.substring(6, 7)));
                    configdata.setCheck_batdispvon(VolUtil.parseInt(retString2.substring(8, 9)));
                    configdata.setCheck_batdispvloss(VolUtil.parseInt(retString2.substring(10, 11)));
                    configdata.setCheck_batfeedpvon(VolUtil.parseInt(retString2.substring(12, 13)));
                    configdata.setCheck_batfeedpvloss(VolUtil.parseInt(retString2.substring(14, 15)));
                    configdata.setCheck_gridChargingLowestBatVol(VolUtil.parseInt(retString2.substring(20, 21)));
                }
                if (!"".equals(retString2 = handler.excuteCommand("QPKT", true)) && !retString2.equals("(NAK") && retString2.length() >= 10) {
                    configdata.setAcChargeStarttime(retString2.substring(1, 5));
                    configdata.setAcChargeEndtime(retString2.substring(6, 10));
                }
                if (!"".equals(retString2 = handler.excuteCommand("QOFFC", true)) && !retString2.equals("(NAK") && retString2.length() >= 13) {
                    String[] splitArray2 = retString2.split(" ");
                    configdata.setLiFloatChargingCurrent(VolUtil.parseDouble(splitArray2[0].substring(1)));
                    configdata.setLimaxFloatChargingCurrent(configdata.getMaxChargingCurrent());
                    configdata.setMinMaxChargingCurrent(configdata.getLiFloatChargingCurrent());
                    configdata.setLiRecoverVoltage(VolUtil.parseDouble(splitArray2[1]));
                    configdata.setLimaxrecoverVoltage(configdata.getFloatingVoltage());
                    configdata.setLiRemainingtime(VolUtil.parseInt(splitArray2[2]));
                    configdata.setLimaxRemainingtime(900.0);
                }
                if (!"".equals(retString2 = handler.excuteCommand("QLDT", true)) && !retString2.equals("(NAK") && retString2.length() >= 10) {
                    String[] splitArray3 = retString2.split(" ");
                    configdata.setAcoutputStarttime(splitArray3[0].substring(1));
                    configdata.setAcoutputEndtime(splitArray3[1]);
                }
            }
            if (!this.getProtocol().getModelName().equals("000")) {
                configdata.setMinFloatingVoltage(Math.max(Math.max(configdata.getRecoverVoltage(), configdata.getRecoverVoltageGridLoss()), configdata.getLiRecoverVoltage()));
            }
            if (this.getProtocol().getMCUVersion().compareTo("14-01-15") >= 0 && (splitArray = (retString = handler.excuteCommand("QEBGP", true)).split(" ")).length >= 2) {
                int lifeSign = VolUtil.parseInt(splitArray[1]);
                if (lifeSign > 0) {
                    configdata.setLiFeBattery(true);
                } else {
                    configdata.setLiFeBattery(false);
                }
                String parseStr = splitArray[0].substring(1, 2).equals("+") ? splitArray[0].substring(2) : "-" + splitArray[0].substring(2);
                configdata.setGridPowerDeviation(VolUtil.parseInt(parseStr));
                configdata.setMaxGridPowerDeviation(300);
                configdata.setMinGridPowerDeviation(-300);
            }
            if (!"".equals(qaccv = handler.excuteCommand("QACCV", true)) && !qaccv.equals("(NAK")) {
                configdata.setGridChargingLowestBatVol(VolUtil.parseDouble(qaccv.substring(1)));
            }
            if (!"".equals(qacchc = handler.excuteCommand("QACCHC", true)) && !qacchc.equals("(NAK")) {
                configdata.setMaxAcChargingCurrent(VolUtil.parseDouble(qacchc.substring(1)));
                configdata.setMinMaxAcChargingCurrent(0.0);
                configdata.setMaxMaxAcChargingCurrent(25.0);
                MachineInfo machineInfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
                if (machineInfo.getOutputRateVA() == 5000.0) {
                    configdata.setMaxMaxAcChargingCurrent(30.0);
                }
                if (this.getProtocol().getModelName().equals("000")) {
                    configdata.setMinMaxAcChargingCurrent(0.0);
                    configdata.setMaxMaxAcChargingCurrent(60.0);
                }
            }
            if (!"".equals(queryQOPF = handler.excuteCommand("QOPF", true)) && !queryQOPF.equals("(NAK")) {
                int powerFactor = 0;
                powerFactor = VolUtil.parseInt(queryQOPF.substring(1));
                if (powerFactor > 100) {
                    powerFactor = -(powerFactor - 100);
                }
                configdata.setFeedinPowerFactor((double)powerFactor / 100.0);
                configdata.setMinFeedinPowerFactor(-0.99);
                configdata.setMaxFeedinPowerFactor(1.0);
            }
            if (!"".equals(qmdcc = handler.excuteCommand("QMDCC", true)) && !qmdcc.equals("(NAK")) {
                configdata.setBatDischargeMaxCurrentInHybridMode(VolUtil.parseInt(qmdcc.substring(1)));
                configdata.setMinBatDischargeMaxCurrentInHybridMode(10);
                configdata.setMaxBatDischargeMaxCurrentInHybridMode(150);
            }
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void queryEnergyBeginDate() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return;
        }
        try {
            Date date;
            String queryTime = handler.excuteCommand("QFET", true);
            if (!"".equals(queryTime) && !queryTime.equals("(NAK") && queryTime.trim().length() == 10 && (date = DateUtils.parseDate(queryTime, "yyyyMMddHH")) != null) {
                this.enerystarttime = Calendar.getInstance();
                this.enerystarttime.setTime(date);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void querySelfTestResult() {
    }

    @Override
    public boolean queryDefaultData() {
        boolean result;
        block12: {
            if (!this.getProtocol().getModelName().equals("000")) {
                return true;
            }
            DefaultData defaultData = (DefaultData)this.getBeanBag().getBean("defaultdata");
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                return false;
            }
            result = true;
            try {
                String qdi2Str;
                String qdiStr = handler.excuteCommand("QDI", true);
                if (!"".equals(qdiStr) && !qdiStr.equals("(NAK")) {
                    String[] qdiArr = qdiStr.split(" ");
                    double gridOutputHighV = VolUtil.parseDouble(qdiArr[0].substring(1));
                    double gridOutputLowV = VolUtil.parseDouble(qdiArr[1]);
                    double gridOutputHighF = VolUtil.parseDouble(qdiArr[2]);
                    double gridOutputLowF = VolUtil.parseDouble(qdiArr[3]);
                    double gridInputVoltageH = VolUtil.parseDouble(qdiArr[4]);
                    double gridInputVoltageL = VolUtil.parseDouble(qdiArr[5]);
                    double gridInputFrequencyH = VolUtil.parseDouble(qdiArr[6]);
                    double gridInputFrequencyL = VolUtil.parseDouble(qdiArr[7]);
                    int upperLimitInputV = VolUtil.parseInt(qdiArr[8]);
                    int lowestLimitInputV = VolUtil.parseInt(qdiArr[9]);
                    int mpptInputHighV = VolUtil.parseInt(qdiArr[10]);
                    int mpptInputLowV = VolUtil.parseInt(qdiArr[11]);
                    int maxoutputPower = VolUtil.parseInt(qdiArr[12]);
                    int timeGridAverageHighV = VolUtil.parseInt(qdiArr[13]);
                    int lcdSleepTime = VolUtil.parseInt(qdiArr[14]);
                    defaultData.setHighGridV(gridOutputHighV);
                    defaultData.setLowGridV(gridOutputLowV);
                    defaultData.setHighGridF(gridOutputHighF);
                    defaultData.setLowGridF(gridOutputLowF);
                    defaultData.setGridInputVoltageH(gridInputVoltageH);
                    defaultData.setGridInputVoltageL(gridInputVoltageL);
                    defaultData.setGridInputFrequencyH(gridInputFrequencyH);
                    defaultData.setGridInputFrequencyL(gridInputFrequencyL);
                    defaultData.setPvInputHighV(upperLimitInputV);
                    defaultData.setPvInputLowV(lowestLimitInputV);
                    defaultData.setMppHighV(mpptInputHighV);
                    defaultData.setMppLowV(mpptInputLowV);
                    defaultData.setMaxoutputPower(maxoutputPower);
                    defaultData.setGridAvgHighV(timeGridAverageHighV);
                    defaultData.setLcdSleepTime(String.valueOf(lcdSleepTime * 30));
                }
                if ("".equals(qdi2Str = handler.excuteCommand("QDI2", true)) || qdi2Str.equals("(NAK")) break block12;
                String[] qdi2Arr = qdi2Str.split(" ");
                double maxChargingCurrent = VolUtil.parseDouble(qdi2Arr[0].substring(1));
                double floatingVoltage = VolUtil.parseDouble(qdi2Arr[1]);
                defaultData.setMaxChargingCurrent(maxChargingCurrent);
                defaultData.setFloatingVoltage(floatingVoltage);
                if (this.getFWVersion() >= 0.3f) {
                    int gridwaittime = VolUtil.parseInt(qdi2Arr[2]);
                    defaultData.setGridwaittime(gridwaittime);
                } else {
                    String qftStr = handler.excuteCommand("QFT", true);
                    if (!"".equals(qftStr) && !qftStr.equals("(NAK")) {
                        int gridwaittime = 0;
                        try {
                            gridwaittime = Integer.parseInt(qftStr.substring(1));
                        }
                        catch (Exception ex) {
                            gridwaittime = 5;
                        }
                        defaultData.setGridwaittime(gridwaittime);
                    }
                }
                try {
                    double cutoffVoltage = VolUtil.parseDouble(qdi2Arr[3]);
                    double maxChargingVoltage = VolUtil.parseDouble(qdi2Arr[4]);
                    defaultData.setCutoffVoltage(cutoffVoltage);
                    defaultData.setMaxChargingVoltage(maxChargingVoltage);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public boolean supportSelfTest() {
        return false;
    }

    @Override
    public float getFWVersion() {
        return this._fwVersion;
    }

    @Override
    public float queryFWVersion() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return 0.0f;
        }
        String qsvfw2tr = handler.excuteCommand("QSVFW2", true);
        if (!"".equals(qsvfw2tr) && !qsvfw2tr.equals("(NAK")) {
            this._fwVersion = VolUtil.parseFloat(qsvfw2tr.substring(9));
            return this._fwVersion;
        }
        return 0.0f;
    }

    @Override
    public String getDeviceMode() {
        return this._deviceModel;
    }

    @Override
    public boolean queryDeviceModel() {
        IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
        if (handler == null) {
            return false;
        }
        try {
            String qdmStr = handler.excuteCommand("QDM", true);
            if (!"".equals(qdmStr) && !qdmStr.equals("(NAK")) {
                this._deviceModel = qdmStr = qdmStr.substring(1);
                this.getProtocol().setDeviceModel(this._deviceModel);
                ConfigData bean = (ConfigData)this.getBeanBag().getBean("configdata");
                bean.setModelID(this._deviceModel);
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    @Override
    public double queryEnergyTotal() {
        return 0.0;
    }
}

