/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.EnableSpinnerItem;
import cn.com.voltronic.solar.data.bean.EnableSpinnerParameter;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.P17;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class P175K
extends P17 {
    protected String dspversion = "";
    protected String mcuversion = "";

    @Override
    public String getProtocolID() {
        return "P175K";
    }

    @Override
    public boolean matchProtocol(Object handler) {
        if (!(handler instanceof IComUSBHandler)) {
            return false;
        }
        IComUSBHandler _handler = (IComUSBHandler)handler;
        String dataStr = _handler.excuteSimpleCommand("PI");
        if (StringUtils.isEmpty((String)dataStr) || !dataStr.startsWith("17")) {
            return false;
        }
        String qmdStr = _handler.excuteCommand("MD", true);
        if (StringUtils.isEmpty((String)qmdStr)) {
            return false;
        }
        String[] qmds = qmdStr.split(",");
        if (qmds.length < 2) {
            return false;
        }
        int outputRateVA = VolUtil.parseInt(qmds[1]);
        if (outputRateVA != 5000) {
            return false;
        }
        dataStr = "";
        int i = 0;
        while (i < 5 && (StringUtils.isEmpty((String)dataStr) || dataStr.startsWith("(NAK") || dataStr.indexOf("MCU:") < 0 || dataStr.indexOf("DSP:") < 0)) {
            dataStr = _handler.excuteSimpleCommand("VFWT");
            String[] index = dataStr.split(",");
            if (index.length > 0) {
                this.dspversion = index[0];
                this.mcuversion = index[1];
            } else {
                dataStr = "";
            }
            ++i;
        }
        String serialNoStr = _handler.getSerialNo();
        if (StringUtils.isEmpty((String)serialNoStr)) {
            return false;
        }
        this.serialNo = serialNoStr;
        this.mpptTrackNumber = _handler.getMpptTrackNumber();
        this.modelType = _handler.getModeType();
        this.deviceModel = _handler.getDeviceModel();
        return true;
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.pvInputVoltage2[:]", "{workInfo.getPvInputVoltage2}", "V"));
        item.add(new AutoLabelItem("message.gridVoltageR[:]", "{workInfo.getRGridVoltage}", "V"));
        item.add(new AutoLabelItem("message.gridFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            IComUSBHandler _handler = (IComUSBHandler)((Object)processor.getHandler());
            this.modelType = _handler.getModeType();
        }
        if (!this.modelType.equals("00")) {
            ConfigData configData;
            item.add(new AutoLabelItem("message.outputLoadPercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
            item.add(new AutoLabelItem("message.chargeCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
            item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getPBatteryVoltage}", "V"));
            item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
            if (processor != null && (configData = (ConfigData)processor.getBeanBag().getBean("configdata")).getBatTptCompensate() > 0.0) {
                item.add(new AutoLabelItem("message.externalBatteryTemperature[:]", "{workInfo.getExternalBatteryTemperature}", "\u2103"));
            }
            item.add(new AutoLabelItem("message.acOutputActivePower[:]", "{workInfo.getAcOutputActivePowerR}", "W"));
            item.add(new AutoLabelItem("message.acOutputApperentPower[:]", "{workInfo.getAcOutputApperentPowerR}", "VA"));
        }
        item.add(new AutoLabelItem("message.innerTemperature[:]", "{workInfo.getInnerTemperature}", "\u2103"));
        item.add(new AutoLabelItem("message.maxComponentTemperature[:]", "{workInfo.getMaxTemperature}", "\u2103"));
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public String getDSPVersion() {
        return this.dspversion;
    }

    @Override
    public String getMCUVersion() {
        return this.mcuversion;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.setPVIPLV[:]", "{configData.getMinPvInputLowV}", "{configData.getMaxPvInputLowV}", "1", "{configData.getPvInputLowV}", "V", "setPVIPLV", 0, false));
        list.add(new AutoSpinnerItem("message.setPVIPHV[:]", "{configData.getMinPvInputHighV}", "{configData.getMaxPvInputHighV}", "1", "{configData.getPvInputHighV}", "V", "setPVIPHV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTLV[:]", "{configData.getMinMpptLowV}", "{configData.getMaxMpptLowV}", "1", "{configData.getMpptLowV}", "V", "setMPPTLV", 0, false));
        list.add(new AutoSpinnerItem("message.setMPPTHV[:]", "{configData.getMinMpptHighV}", "{configData.getMaxMpptHighV}", "1", "{configData.getMpptHighV}", "V", "setMPPTHV", 0, false));
        if (!this.modelType.equals("00")) {
            list.add(new AutoSpinnerItem("message.maxChargingCurrent[:]", "{configData.getMinMaxChargingCurrent}", "{configData.getMaxMaxChargingCurrent}", "0.1", "{configData.getMaxChargingCurrent}", "A", "setMaxChargingCurrent", 0, false));
            list.add(new AutoSpinnerItem("message.maxACchargingCurrent[:]", "{configData.getMinMaxChargingCurrent}", "{configData.getMaxMaxChargingCurrent}", "0.1", "{configData.getMaxAcChargingCurrent}", "A", "setMaxAcChargingCurrent", 0, false));
            list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinMaxChargingVoltage}", "{configData.getMaxMaxChargingVoltage}", "0.1", "{configData.getMaxChargingVoltage}", "V", "setMCHGV", 1, false));
            list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinFloatingVoltage}", "{configData.getMaxFloatingVoltage}", "0.1", "{configData.getFloatingVoltage}", "V", "setMCHGV", 0, false));
            list.add(new AutoSpinnerItem("message.cutoffVolGridOn[:]", "{configData.getMinCutoffVoltage}", "{configData.getMaxCutoffVoltage}", "0.1", "{configData.getCutoffVoltage}", "V", "setBatDischargeVol", 2, false));
            list.add(new AutoSpinnerItem("message.recoverVolGridOn[:]", "{configData.getMinRecoverVoltage}", "{configData.getMaxRecoverVoltage}", "0.1", "{configData.getRecoverVoltage}", "V", "setBatDischargeVol", 3, false));
            list.add(new AutoSpinnerItem("message.cutoffVolGridLoss[:]", "{configData.getMinCutoffVoltageGridLoss}", "{configData.getMaxCutoffVoltageGridLoss}", "0.1", "{configData.getCutoffVoltageGridLoss}", "V", "setBatDischargeVol", 0, false));
            list.add(new AutoSpinnerItem("message.recoverVolGridLoss[:]", "{configData.getMinRecoverVoltageGridLoss}", "{configData.getMaxRecoverVoltageGridLoss}", "0.1", "{configData.getRecoverVoltageGridLoss}", "V", "setBatDischargeVol", 1, false));
            list.add(new AutoSpinnerItem("message.batTprCompensation[:]", "{configData.getMinBatTptCompensate}", "{configData.getMaxBatTptCompensate}", "0.1", "{configData.getBatTptCompensate}", "mV", "setBatTptCompensate", 0, false));
            list.add(new AutoSpinnerItem("message.batDischargeMaxCurrentInHybridMode[:]", "{configData.getMinBatDischargeMaxCurrentInHybridMode}", "{configData.getMaxBatDischargeMaxCurrentInHybridMode}", "1", "{configData.getBatDischargeMaxCurrentInHybridMode}", "A", "setBatDischargeMaxCurrentInHybridMode", 0, false));
            list.add(new AutoSpinnerItem("message.feedingGridPowerCalibration[:]", "{configData.getMinFeedingGridCalibrationPowerR}", "{configData.getMaxFeedingGridCalibrationPowerR}", "1", "{configData.getFeedingGridCalibrationPowerR}", "W", "setFeedingGridCalibrationPowerR", 0, false));
        }
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.pepdP[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        if (!this.modelType.equals("01") && this.getMCUVersion().compareTo("170711123000") >= 0 && (this.deviceModel.equals("064") || this.deviceModel.equals("114") || this.deviceModel.equals("065") || this.deviceModel.equals("115") || this.deviceModel.equals("066") || this.deviceModel.equals("116") || this.deviceModel.equals("067") || this.deviceModel.equals("117") || this.deviceModel.equals("068") || this.deviceModel.equals("118") || this.deviceModel.equals("069") || this.deviceModel.equals("119"))) {
            list.add(new AutoRadioItem("message.OverFrequencyDerating[:]", "message.enable", "message.disable", "{cappbility.isCapableG}", "CapableG", false));
            list.add(new AutoRadioItem("message.OverVoltageDerating[:]", "message.enable", "message.disable", "{cappbility.isCapableH}", "CapableH", false));
            list.add(new AutoRadioItem("message.rPControl[:]", "message.enable", "message.disable", "{cappbility.getCheck_reactivePowerAutoControl}", "ENFH", false));
        }
        if (!this.modelType.equals("00")) {
            list.add(new AutoRadioItem("message.pepdB[:]", "message.enable", "message.disable", "{cappbility.isCapableC}", "CapableC", false));
            list.add(new AutoRadioItem("message.BatteryTypeLiFe[:]", "message.yes", "message.no", "{configData.isLiFeBattery}", "LBF", false));
            list.add(new AutoRadioItem("message.GNTM[:]", "message.enable", "message.disable", "{cappbility.isCapableD}", "CapableD", false));
            list.add(new AutoRadioItem("message.wideAcInputRange[:]", "message.enable", "message.disable", "{cappbility.isCapableE}", "CapableE", false));
            list.add(new AutoRadioItem("message.parallelforoutput[:]", "message.enable", "message.disable", "{cappbility.isParallelOutput}", "ParallelFO", false));
        }
        list.add(new AutoRadioItem("message.pepdF[:]", "message.enable", "message.disable", "{cappbility.isCapableF}", "CapableF", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public EnableSpinnerParameter getEnableSpinnerParameter() {
        EnableSpinnerParameter params = new EnableSpinnerParameter();
        ArrayList<EnableSpinnerItem> list = new ArrayList<EnableSpinnerItem>();
        if (this.deviceModel.equals("058") || this.deviceModel.equals("108") || this.deviceModel.equals("051") || this.deviceModel.equals("101")) {
            EnableSpinnerItem itemAAPF = new EnableSpinnerItem("message.AutoAdjustPFWithPower", "{configData.isEnabledAAPF}", "setAAPF");
            itemAAPF.setSpinnerCaptionA("message.StartPowerPercentage");
            itemAAPF.setSpinnerUnitA("%");
            itemAAPF.setSpinnerMinValueA("{configData.getMinStartPowerPercentage}");
            itemAAPF.setSpinnerMaxValueA("{configData.getMaxStartPowerPercentage}");
            itemAAPF.setSpinnerValueA("{configData.getStartPowerPercentage}");
            itemAAPF.setSpinnerStepA(1);
            itemAAPF.setSpinnerCaptionB("message.MinmumPFValue");
            itemAAPF.setSpinnerUnitB("");
            itemAAPF.setSpinnerMinValueB("{configData.getMinMinmumPFValue}");
            itemAAPF.setSpinnerMaxValueB("{configData.getMaxMinmumPFValue}");
            itemAAPF.setSpinnerValueB("{configData.getMinmumPFValue}");
            itemAAPF.setSpinnerStepB(0.01);
            list.add(itemAAPF);
        }
        EnableSpinnerItem itemEPS = new EnableSpinnerItem("message.EmergencyPowerSupplyControl", "{configData.isEnabledEPS}", "setEPS");
        itemEPS.setSpinnerCaptionA("message.BatVoltoCutoffMainsOutput");
        itemEPS.setSpinnerUnitA("V");
        itemEPS.setSpinnerMinValueA("{configData.getMinBatCutOffMainOutputVol}");
        itemEPS.setSpinnerMaxValueA("{configData.getMaxBatCutOffMainOutputVol}");
        itemEPS.setSpinnerValueA("{configData.getBatCutOffMainOutputVol}");
        itemEPS.setSpinnerStepA(0.1);
        itemEPS.setSpinnerCaptionB("message.BatVoltoTurnOnMainsOutput");
        itemEPS.setSpinnerUnitB("V");
        itemEPS.setSpinnerMinValueB("{configData.getMinBatReConnectedMainOutputVol}");
        itemEPS.setSpinnerMaxValueB("{configData.getMaxBatReConnectedMainOutputVol}");
        itemEPS.setSpinnerValueB("{configData.getBatReConnectedMainOutputVol}");
        itemEPS.setSpinnerStepB(0.1);
        list.add(itemEPS);
        params.setParameters(list);
        return params;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", true, true));
        list.add(new HistoryData("message.pvInputPower1", "{workInfo.getPvInputPower1}", true, true));
        list.add(new HistoryData("message.pvInputPower2", "{workInfo.getPvInputPower2}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{workInfo.getRGridVoltage}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{workInfo.getGridFrequency}", true, true));
        if (!this.modelType.equals("00")) {
            list.add(new HistoryData("message.outputLoadPercent", "{workInfo.getOutputLoadPercent}", true, true));
            list.add(new HistoryData("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", true, true));
            list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
            list.add(new HistoryData("message.chargeCurrent", "{workInfo.getChargingCurrent}", true, true));
            list.add(new HistoryData("message.acOutputActivePower", "{workInfo.getAcOutputActivePowerR}", false, true));
            list.add(new HistoryData("message.acOutputApperentPower", "{workInfo.getAcOutputApperentPowerR}", false, true));
        }
        list.add(new HistoryData("message.innerTemperature", "{workInfo.getInnerTemperature}", true, true));
        list.add(new HistoryData("message.temperature", "{workInfo.getMaxTemperature}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", 1000.0, "V", true));
        list.add(new HistoryChart("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", 1000.0, "V", true));
        list.add(new HistoryChart("message.pvInputPower1", "{workInfo.getPvInputPower1}", 15000.0, "W", true));
        list.add(new HistoryChart("message.pvInputPower2", "{workInfo.getPvInputPower2}", 15000.0, "W", true));
        list.add(new HistoryChart("message.gridVoltageR", "{workInfo.getRGridVoltage}", 300.0, "V", true));
        list.add(new HistoryChart("message.gridFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        if (!this.modelType.equals("00")) {
            list.add(new HistoryChart("message.outputLoadPercent", "{workInfo.getOutputLoadPercent}", 100.0, "%", true));
            list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getPBatteryVoltage}", 500.0, "V", true));
            list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
            list.add(new HistoryChart("message.chargeCurrent", "{workInfo.getChargingCurrent}", 100.0, "A", true));
            list.add(new HistoryChart("message.acOutputActivePower", "{workInfo.getAcOutputActivePowerR}", 10000.0, "W", true));
            list.add(new HistoryChart("message.acOutputApperentPower", "{workInfo.getAcOutputApperentPowerR}", 10000.0, "VA", true));
        }
        list.add(new HistoryChart("message.innerTemperature", "{workInfo.getInnerTemperature}", 180.0, "\u2103", true));
        list.add(new HistoryChart("message.temperature", "{workInfo.getMaxTemperature}", 180.0, "\u2103", true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.pvInputVoltage", "{faultData.getPvinputvoltage1}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{faultData.getAcinputvoltager}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{faultData.getGridFrequency}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{faultData.getBatteryVoltage}", true, true));
        list.add(new HistoryData("message.chargeCurrent", "{faultData.getBatteryCurrent}", true, true));
        list.add(new HistoryData("message.gridOutputVoltage", "{faultData.getAcoutputvoltager}", true, true));
        list.add(new HistoryData("message.acOutputFrequency", "{faultData.getOutputLoadFrequency}", true, true));
        columns.setColumns(list);
        return columns;
    }
}

