/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.data.bean.EnergyData;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AATitleBorder;
import cn.com.voltronic.solar.view.panel.PowerPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PowerInfoJFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static PowerInfoJFrame instance = null;
    private JPanel mainPanel;
    private JScrollPane mainScrollPanel;
    private Map<String, PowerPanel> powerMap = new HashMap<String, PowerPanel>();
    private static final String SUM_POWER_PANEL = "sum_power_panel";
    private EnergyData sumEnergyData = new EnergyData();
    private WorkInfo sumworkInfo = new WorkInfo();
    private boolean isFrameOpened = false;
    private AALabel titleLabel;

    public PowerInfoJFrame(Frame parent) {
        this.initComponents();
        this.setIconImage(Constants.CONNECTEDIMG);
        this.setTitle(this.titleLabel.getText());
        this.setLocationRelative();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                PowerInfoJFrame.this.isFrameOpened = false;
                PowerInfoJFrame.this.powerMap.clear();
                instance = null;
            }
        });
    }

    private void setLocationRelative() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenWith = screenSize.width;
        int screenHeight = screenSize.height;
        this.setSize(new Dimension(screenWith - 200, screenHeight - 100));
        int with = this.getWidth();
        int height = this.getHeight();
        this.mainPanel.setPreferredSize(new Dimension(with - 300, height - 100));
        this.mainScrollPanel.setPreferredSize(new Dimension(this.mainPanel.getWidth() - 200, this.mainPanel.getHeight() - 100));
        int x = (screenWith - with) / 2;
        int y = (screenHeight - height) / 2;
        this.setLocation(x, y);
    }

    private void initComponents() {
        this.titleLabel = new AALabel();
        this.titleLabel.setText("message.powerNumber");
        this.mainPanel = new JPanel();
        this.mainScrollPanel = new JScrollPane();
        this.mainScrollPanel.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mainScrollPanel).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.mainScrollPanel).addContainerGap()));
        this.pack();
    }

    public void scheduleAction() {
        this.isFrameOpened = true;
        this.mainPanel.removeAll();
        this.mainPanel.updateUI();
        this.updateUIPerformed();
    }

    private void updateUIPerformed() {
        boolean hasDevice = false;
        Map<String, AbstractProcessor> procMap = GlobalProcessors.getProcessorMap();
        int count = procMap.size() + 1;
        int cols = 4;
        int rows = count / cols + 1;
        int hgap = 6;
        int vgap = 6;
        this.mainPanel.setLayout(new GridLayout(rows, cols, hgap, vgap));
        Set<String> keySet = procMap.keySet();
        Iterator<String> keys = keySet.iterator();
        PowerPanel powerPanel = null;
        while (keys.hasNext()) {
            String key = keys.next();
            powerPanel = new PowerPanel();
            AATitleBorder titleBorder = new AATitleBorder(key);
            titleBorder.setTitleJustification(2);
            powerPanel.setBorder(titleBorder);
            this.powerMap.put(key, powerPanel);
            this.mainPanel.add(powerPanel);
            hasDevice = true;
        }
        if (hasDevice) {
            powerPanel = new PowerPanel();
            AATitleBorder titleBorder = new AATitleBorder("message.quantitieList");
            titleBorder.setTitleJustification(2);
            powerPanel.setBorder(titleBorder);
            this.powerMap.put(SUM_POWER_PANEL, powerPanel);
            this.sumworkInfo.setProdid("P16");
            this.mainPanel.add(powerPanel);
        }
        this.mainPanel.updateUI();
        if (hasDevice) {
            RefreshThread refreshThread = new RefreshThread();
            refreshThread.start();
        }
    }

    private void refreshPowerInfo() {
        Map<String, AbstractProcessor> procMap = GlobalProcessors.getProcessorMap();
        Set<String> keySet = procMap.keySet();
        Iterator<String> keys = keySet.iterator();
        PowerPanel powerPanel = null;
        while (keys.hasNext()) {
            String key = keys.next();
            AbstractProcessor processer = procMap.get(key);
            powerPanel = this.powerMap.get(key);
            if (powerPanel == null) continue;
            WorkInfo workInfo = (WorkInfo)processer.getBeanBag().getBean("workinfo");
            EnergyData energydata = (EnergyData)processer.getBeanBag().getBean("energydata");
            powerPanel.refreshWork(energydata, workInfo);
            double energyInD = energydata.getEnergyInD();
            double energyInM = energydata.getEnergyInM();
            double energyInY = energydata.getEnergyInY();
            this.sumEnergyData.setEnergyInD(energyInD);
            this.sumEnergyData.setEnergyInM(energyInM);
            this.sumEnergyData.setEnergyInY(energyInY);
            int pvInputPower1 = workInfo.getPvInputPower1();
            int mpptTrackNum = processer.getProtocol().getMpptTrackNumber();
            if (mpptTrackNum == 2) {
                pvInputPower1 += workInfo.getPvInputPower2();
            } else if (mpptTrackNum == 3) {
                pvInputPower1 += workInfo.getPvInputPower2() + workInfo.getPvInputPower3();
            }
            this.sumworkInfo.setPvInputPower1(pvInputPower1);
        }
        powerPanel = this.powerMap.get(SUM_POWER_PANEL);
        if (powerPanel != null) {
            powerPanel.refreshWork(this.sumEnergyData, this.sumworkInfo);
        }
    }

    public static PowerInfoJFrame getInstance() {
        return instance;
    }

    public static void setInstance(PowerInfoJFrame instance) {
        PowerInfoJFrame.instance = instance;
    }

    private class RefreshThread
    extends Thread {
        private RefreshThread() {
        }

        @Override
        public void run() {
            while (PowerInfoJFrame.this.isFrameOpened) {
                PowerInfoJFrame.this.refreshPowerInfo();
                try {
                    Thread.sleep(GlobalVariables.globalConfig.getPageRefreshInterval() * 1000 - 5);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

