/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;

public class RealControlJDialog17
extends AADialog {
    private static final long serialVersionUID = -5986305231916605918L;
    private AbstractProcessor processor = null;
    private AAButton applyButton;
    private AAButton cancelButton;
    private JRadioButton disableRadioButton;
    private JRadioButton enableRadioButton;
    private AALabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private AALabel lblLiFeBatteryActive;
    private AAButton btnLiFeActiveApply;
    private JLabel warningIcon;
    private AALabel activeBatteryNote;
    private AALabel activeBatteryWarn;

    public RealControlJDialog17(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("message.realTimeCtrl");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        if (this.processor == null) {
            this.processor = GlobalProcessors.getCurrentProcessor();
        }
        this.jPanel1 = new JPanel();
        this.jLabel2 = new AALabel();
        this.enableRadioButton = new JRadioButton();
        this.disableRadioButton = new JRadioButton();
        this.applyButton = new AAButton();
        this.jPanel2 = new JPanel();
        this.cancelButton = new AAButton();
        this.lblLiFeBatteryActive = new AALabel();
        this.btnLiFeActiveApply = new AAButton();
        this.warningIcon = new JLabel();
        this.activeBatteryNote = new AALabel();
        this.activeBatteryWarn = new AALabel();
        this.lblLiFeBatteryActive.setText("Activate Li-Fe Battery now");
        this.btnLiFeActiveApply.setText("message.yes");
        this.warningIcon.setIcon(new ImageIcon(Constants.WARNINGLIGHTIMG));
        String warning = "If \"Activate Li-Fe battery while commissioning\" is selected in parameter setting,";
        this.activeBatteryNote.setText(warning);
        this.activeBatteryWarn.setText("AC output will be cut off when this action is executed.");
        this.btnLiFeActiveApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                RealControlJDialog17.this.activeAction(e);
            }
        });
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel2.setText("message.acoutput[:]");
        this.enableRadioButton.setText("ON");
        this.enableRadioButton.setSelected(true);
        this.enableRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealControlJDialog17.this.enableRadioButton.setSelected(true);
                RealControlJDialog17.this.disableRadioButton.setSelected(false);
            }
        });
        this.disableRadioButton.setText("OFF");
        this.disableRadioButton.setSelected(false);
        this.disableRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealControlJDialog17.this.enableRadioButton.setSelected(false);
                RealControlJDialog17.this.disableRadioButton.setSelected(true);
            }
        });
        this.initEnable();
        this.applyButton.setText("message.apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                RealControlJDialog17.this.applyAction(e);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableRadioButton).addGap(6, 6, 6).addComponent(this.applyButton).addContainerGap(167, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.lblLiFeBatteryActive).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGap(12, 12, 12).addComponent(this.btnLiFeActiveApply).addContainerGap(167, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.warningIcon).addComponent(this.activeBatteryNote).addContainerGap(167, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(70, 70, 70).addComponent(this.activeBatteryWarn)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.enableRadioButton).addComponent(this.disableRadioButton).addComponent(this.applyButton)).addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblLiFeBatteryActive).addComponent(this.btnLiFeActiveApply)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.warningIcon).addComponent(this.activeBatteryNote)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.activeBatteryWarn)).addContainerGap(203, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.cancelButton.setText("message.cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealControlJDialog17.this.dispose();
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(346, Short.MAX_VALUE).addComponent(this.cancelButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.cancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel2, "Last");
        this.pack();
    }

    private void initEnable() {
        this.processor = GlobalProcessors.getCurrentProcessor();
        if (this.processor != null) {
            WorkInfo workInfo = (WorkInfo)this.processor.getBeanBag().getBean("workinfo");
            if (workInfo.isAcOutputConnect()) {
                this.enableRadioButton.setSelected(true);
                this.disableRadioButton.setSelected(false);
            } else {
                this.enableRadioButton.setSelected(false);
                this.disableRadioButton.setSelected(true);
            }
        }
    }

    private void activeAction(ActionEvent e) {
        boolean result = false;
        if (this.processor == null) {
            this.processor = GlobalProcessors.getCurrentProcessor();
        }
        if (this.processor != null) {
            result = this.processor.executeControl("activeLifeBattery", null);
        }
        if (result) {
            DisplayMessage.showInfoDialog("message.setTrue");
        } else {
            DisplayMessage.showErrorDialog("message.setFalse");
        }
        this.applyButton.setEnabled(true);
    }

    private void applyAction(ActionEvent e) {
        this.applyButton.setEnabled(false);
        boolean result = false;
        if (this.processor == null) {
            this.processor = GlobalProcessors.getCurrentProcessor();
        }
        if (this.processor != null) {
            if (this.enableRadioButton.isSelected()) {
                result = this.processor.executeControl("loadsMachineSupplyPower", new String[]{"1"});
            } else if (this.disableRadioButton.isSelected()) {
                result = this.processor.executeControl("loadsMachineSupplyPower", new String[]{"0"});
            }
        }
        if (result) {
            DisplayMessage.showInfoDialog("message.setTrue");
        } else {
            DisplayMessage.showErrorDialog("message.setFalse");
        }
        this.applyButton.setEnabled(true);
    }
}

