/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuBarPeer;
import java.util.Vector;
import sun.awt.AWTAccessor;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XToolkit;
import sun.util.logging.PlatformLogger;

public class XMenuBarPeer
extends XBaseMenuWindow
implements MenuBarPeer {
    private static PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XMenuBarPeer");
    private XFramePeer framePeer;
    private MenuBar menuBarTarget;
    private XMenuPeer helpMenu = null;
    private static final int BAR_SPACING_TOP = 3;
    private static final int BAR_SPACING_BOTTOM = 3;
    private static final int BAR_SPACING_LEFT = 3;
    private static final int BAR_SPACING_RIGHT = 3;
    private static final int BAR_ITEM_SPACING = 2;
    private static final int BAR_ITEM_MARGIN_LEFT = 10;
    private static final int BAR_ITEM_MARGIN_RIGHT = 10;
    private static final int BAR_ITEM_MARGIN_TOP = 2;
    private static final int BAR_ITEM_MARGIN_BOTTOM = 2;
    static final int W_DIFF = 12;
    static final int H_DIFF = 23;

    XMenuBarPeer(MenuBar menuBar) {
        this.menuBarTarget = menuBar;
    }

    @Override
    public void setFont(Font font) {
        this.resetMapping();
        this.setItemsFont(font);
        this.postPaintEvent();
    }

    @Override
    public void addMenu(Menu menu) {
        this.addItem(menu);
        this.postPaintEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMenu(int n) {
        Object object = XMenuBarPeer.getMenuTreeLock();
        synchronized (object) {
            XMenuItemPeer xMenuItemPeer = this.getItem(n);
            if (xMenuItemPeer != null && xMenuItemPeer == this.helpMenu) {
                this.helpMenu = null;
            }
            this.delItem(n);
        }
        this.postPaintEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHelpMenu(Menu menu) {
        XMenuPeer xMenuPeer = (XMenuPeer)menu.getPeer();
        Object object = XMenuBarPeer.getMenuTreeLock();
        synchronized (object) {
            this.helpMenu = xMenuPeer;
        }
        this.postPaintEvent();
    }

    public void init(Frame frame) {
        this.target = frame;
        this.framePeer = (XFramePeer)frame.getPeer();
        XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
        xCreateWindowParams.remove("delayed");
        xCreateWindowParams.add((Object)"parent window", this.framePeer.getShell());
        xCreateWindowParams.add((Object)"target", frame);
        this.init(xCreateWindowParams);
    }

    @Override
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        Vector vector = AWTAccessor.getMenuBarAccessor().getMenus(this.menuBarTarget);
        Menu menu = AWTAccessor.getMenuBarAccessor().getHelpMenu(this.menuBarTarget);
        this.reloadItems(vector);
        if (menu != null) {
            this.addHelpMenu(menu);
        }
        this.xSetVisible(true);
        this.toFront();
    }

    @Override
    protected XBaseMenuWindow getParentMenuWindow() {
        return null;
    }

    @Override
    protected MappingData map() {
        Object object;
        int n;
        int n2;
        XMenuItemPeer[] xMenuItemPeerArray = this.copyItems();
        int n3 = xMenuItemPeerArray.length;
        XMenuPeer xMenuPeer = this.helpMenu;
        int n4 = -1;
        if (xMenuPeer != null) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (xMenuItemPeerArray[n2] != xMenuPeer) continue;
                n4 = n2;
                break;
            }
            if (n4 != -1 && n4 != n3 - 1) {
                System.arraycopy(xMenuItemPeerArray, n4 + 1, xMenuItemPeerArray, n4, n3 - 1 - n4);
                xMenuItemPeerArray[n3 - 1] = xMenuPeer;
            }
        }
        n2 = 0;
        XMenuItemPeer.TextMetrics[] textMetricsArray = new XMenuItemPeer.TextMetrics[n3];
        for (n = 0; n < n3; ++n) {
            textMetricsArray[n] = xMenuItemPeerArray[n].getTextMetrics();
            Dimension dimension = textMetricsArray[n].getTextDimension();
            if (dimension == null) continue;
            n2 = Math.max(n2, dimension.height);
        }
        n = 0;
        int n5 = 2 + n2 + 2;
        int n6 = n3;
        for (int i = 0; i < n3; ++i) {
            Cloneable cloneable;
            object = xMenuItemPeerArray[i];
            XMenuItemPeer.TextMetrics textMetrics = textMetricsArray[i];
            Dimension dimension = textMetrics.getTextDimension();
            if (dimension != null) {
                int n7 = 10 + dimension.width + 10;
                if (n + n7 > this.width && i > 0) {
                    n6 = i;
                    break;
                }
                if (i == n3 - 1 && n4 != -1) {
                    n = Math.max(n, this.width - n7 - 3);
                }
                cloneable = new Rectangle(n, 3, n7, n5);
                int n8 = (n2 + dimension.height) / 2 - textMetrics.getTextBaseline();
                Point point = new Point(n + 10, 5 + n8);
                n += n7 + 2;
                ((XMenuItemPeer)object).map((Rectangle)cloneable, point);
                continue;
            }
            Rectangle rectangle = new Rectangle(n, 3, 0, 0);
            cloneable = new Point(n + 10, 5);
        }
        XMenuItemPeer[] xMenuItemPeerArray2 = new XMenuItemPeer[n6];
        System.arraycopy(xMenuItemPeerArray, 0, xMenuItemPeerArray2, 0, n6);
        object = new MappingData(xMenuItemPeerArray2, 3 + n5 + 3);
        return object;
    }

    @Override
    protected Rectangle getSubmenuBounds(Rectangle rectangle, Dimension dimension) {
        Dimension dimension2;
        Rectangle rectangle2 = this.toGlobal(rectangle);
        Rectangle rectangle3 = this.fitWindowBelow(rectangle2, dimension, dimension2 = Toolkit.getDefaultToolkit().getScreenSize());
        if (rectangle3 != null) {
            return rectangle3;
        }
        rectangle3 = this.fitWindowAbove(rectangle2, dimension, dimension2);
        if (rectangle3 != null) {
            return rectangle3;
        }
        rectangle3 = this.fitWindowRight(rectangle2, dimension, dimension2);
        if (rectangle3 != null) {
            return rectangle3;
        }
        rectangle3 = this.fitWindowLeft(rectangle2, dimension, dimension2);
        if (rectangle3 != null) {
            return rectangle3;
        }
        return this.fitWindowToScreen(dimension, dimension2);
    }

    @Override
    protected void updateSize() {
        this.resetMapping();
        if (this.framePeer != null) {
            this.framePeer.reshapeMenubarPeer();
        }
    }

    int getDesiredHeight() {
        MappingData mappingData = (MappingData)this.getMappingData();
        return mappingData.getDesiredHeight();
    }

    boolean isFramePeerEnabled() {
        if (this.framePeer != null) {
            return this.framePeer.isEnabled();
        }
        return false;
    }

    @Override
    protected void doDispose() {
        super.doDispose();
        XToolkit.targetDisposedPeer(this.menuBarTarget, this);
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 != this.width || n4 != this.height) {
            this.resetMapping();
        }
        super.reshape(n, n2, n3, n4);
    }

    @Override
    void ungrabInputImpl() {
        this.selectItem(null, false);
        super.ungrabInputImpl();
        this.postPaintEvent();
    }

    @Override
    public void paint(Graphics graphics) {
        this.resetColors();
        int n = this.getWidth();
        int n2 = this.getHeight();
        this.flush();
        graphics.setColor(this.getBackgroundColor());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        this.draw3DRect(graphics, 0, 0, n, n2, true);
        MappingData mappingData = (MappingData)this.getMappingData();
        XMenuItemPeer[] xMenuItemPeerArray = mappingData.getItems();
        XMenuItemPeer xMenuItemPeer = this.getSelectedItem();
        for (int i = 0; i < xMenuItemPeerArray.length; ++i) {
            XMenuItemPeer xMenuItemPeer2 = xMenuItemPeerArray[i];
            graphics.setFont(xMenuItemPeer2.getTargetFont());
            Rectangle rectangle = xMenuItemPeer2.getBounds();
            Point point = xMenuItemPeer2.getTextOrigin();
            if (xMenuItemPeer2 == xMenuItemPeer) {
                graphics.setColor(this.getSelectedColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.draw3DRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            if (this.isFramePeerEnabled() && xMenuItemPeer2.isTargetItemEnabled()) {
                graphics.setColor(this.getForegroundColor());
            } else {
                graphics.setColor(this.getDisabledColor());
            }
            graphics.drawString(xMenuItemPeer2.getTargetLabel(), point.x, point.y);
        }
        this.flush();
    }

    void print(Graphics graphics) {
    }

    @Override
    protected void handleEvent(AWTEvent aWTEvent) {
        if (this.framePeer != null && aWTEvent.getID() != 800 && this.framePeer.isModalBlocked()) {
            return;
        }
        switch (aWTEvent.getID()) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                if (!this.isFramePeerEnabled()) break;
                this.doHandleJavaMouseEvent((MouseEvent)aWTEvent);
                break;
            }
            case 401: 
            case 402: {
                if (!this.isFramePeerEnabled()) break;
                this.doHandleJavaKeyEvent((KeyEvent)aWTEvent);
                break;
            }
            default: {
                super.handleEvent(aWTEvent);
            }
        }
    }

    void handleF10KeyPress(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        if ((n & 8) != 0 || (n & 1) != 0 || (n & 2) != 0) {
            return;
        }
        this.grabInput();
        this.selectItem(this.getFirstSelectableItem(), true);
    }

    @Override
    public void handleKeyPress(XEvent xEvent) {
        XKeyEvent xKeyEvent = xEvent.get_xkey();
        if (log.isLoggable(500)) {
            log.fine(xKeyEvent.toString());
        }
        if (this.isEventDisabled(xEvent)) {
            return;
        }
        Component component = this.getEventSource();
        this.handleKeyPress(xKeyEvent);
    }

    static class MappingData
    extends XBaseMenuWindow.MappingData {
        int desiredHeight;

        MappingData(XMenuItemPeer[] xMenuItemPeerArray, int n) {
            super(xMenuItemPeerArray);
            this.desiredHeight = n;
        }

        MappingData() {
            this.desiredHeight = 0;
        }

        public int getDesiredHeight() {
            return this.desiredHeight;
        }
    }
}

