/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XStandardColormap
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 40 : 80;
    }

    @Override
    public int getDataSize() {
        return XStandardColormap.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XStandardColormap(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XStandardColormap() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XStandardColormap.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_colormap() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_colormap(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public long get_red_max() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_red_max(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    public long get_red_mult() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16));
    }

    public void set_red_mult(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 16), l);
    }

    public long get_green_max() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24));
    }

    public void set_green_max(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 12 : 24), l);
    }

    public long get_green_mult() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 32));
    }

    public void set_green_mult(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 16 : 32), l);
    }

    public long get_blue_max() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 40));
    }

    public void set_blue_max(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 40), l);
    }

    public long get_blue_mult() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 48));
    }

    public void set_blue_mult(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 48), l);
    }

    public long get_base_pixel() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 56));
    }

    public void set_base_pixel(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 28 : 56), l);
    }

    public long get_visualid() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 64));
    }

    public void set_visualid(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 32 : 64), l);
    }

    public long get_killid() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 72));
    }

    public void set_killid(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 36 : 72), l);
    }

    @Override
    String getName() {
        return "XStandardColormap";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(400);
        stringBuilder.append("colormap = ").append(this.get_colormap()).append(", ");
        stringBuilder.append("red_max = ").append(this.get_red_max()).append(", ");
        stringBuilder.append("red_mult = ").append(this.get_red_mult()).append(", ");
        stringBuilder.append("green_max = ").append(this.get_green_max()).append(", ");
        stringBuilder.append("green_mult = ").append(this.get_green_mult()).append(", ");
        stringBuilder.append("blue_max = ").append(this.get_blue_max()).append(", ");
        stringBuilder.append("blue_mult = ").append(this.get_blue_mult()).append(", ");
        stringBuilder.append("base_pixel = ").append(this.get_base_pixel()).append(", ");
        stringBuilder.append("visualid = ").append(this.get_visualid()).append(", ");
        stringBuilder.append("killid = ").append(this.get_killid()).append(", ");
        return stringBuilder.toString();
    }
}

