/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.xmlimpl;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.xmlimpl.XMLObjectImpl;

class XmlProcessor {
    private static final long serialVersionUID = 6903514433204808713L;
    private boolean ignoreComments;
    private boolean ignoreProcessingInstructions;
    private boolean ignoreWhitespace;
    private boolean prettyPrint;
    private int prettyIndent;
    private transient DocumentBuilderFactory dom;
    private transient TransformerFactory xform;
    private transient DocumentBuilder documentBuilder;
    private RhinoSAXErrorHandler errorHandler = new RhinoSAXErrorHandler();

    XmlProcessor() {
        this.setDefault();
        this.dom = DocumentBuilderFactory.newInstance();
        this.dom.setNamespaceAware(true);
        this.dom.setIgnoringComments(false);
        this.xform = TransformerFactory.newInstance();
    }

    final void setDefault() {
        this.setIgnoreComments(true);
        this.setIgnoreProcessingInstructions(true);
        this.setIgnoreWhitespace(true);
        this.setPrettyPrinting(true);
        this.setPrettyIndent(2);
    }

    final void setIgnoreComments(boolean bl) {
        this.ignoreComments = bl;
    }

    final void setIgnoreWhitespace(boolean bl) {
        this.ignoreWhitespace = bl;
    }

    final void setIgnoreProcessingInstructions(boolean bl) {
        this.ignoreProcessingInstructions = bl;
    }

    final void setPrettyPrinting(boolean bl) {
        this.prettyPrint = bl;
    }

    final void setPrettyIndent(int n) {
        this.prettyIndent = n;
    }

    final boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    final boolean isIgnoreProcessingInstructions() {
        return this.ignoreProcessingInstructions;
    }

    final boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    final boolean isPrettyPrinting() {
        return this.prettyPrint;
    }

    final int getPrettyIndent() {
        return this.prettyIndent;
    }

    private String toXmlNewlines(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\r') {
                if (string.charAt(i + 1) == '\n') continue;
                stringBuffer.append('\n');
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private DocumentBuilderFactory getDomFactory() {
        return this.dom;
    }

    private synchronized DocumentBuilder getDocumentBuilderFromPool() throws ParserConfigurationException {
        DocumentBuilder documentBuilder;
        if (this.documentBuilder == null) {
            DocumentBuilderFactory documentBuilderFactory = this.getDomFactory();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        } else {
            documentBuilder = this.documentBuilder;
            this.documentBuilder = null;
        }
        documentBuilder.setErrorHandler(this.errorHandler);
        return documentBuilder;
    }

    private synchronized void returnDocumentBuilderToPool(DocumentBuilder documentBuilder) {
        if (this.documentBuilder == null) {
            try {
                documentBuilder.reset();
                this.documentBuilder = documentBuilder;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private void addProcessingInstructionsTo(List<Node> list, Node node) {
        if (node instanceof ProcessingInstruction) {
            list.add(node);
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addProcessingInstructionsTo(list, node.getChildNodes().item(i));
            }
        }
    }

    private void addCommentsTo(List<Node> list, Node node) {
        if (node instanceof Comment) {
            list.add(node);
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addProcessingInstructionsTo(list, node.getChildNodes().item(i));
            }
        }
    }

    private void addTextNodesToRemoveAndTrim(List<Node> list, Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            boolean bl = false;
            if (!bl) {
                text.setData(text.getData().trim());
            } else if (text.getData().trim().length() == 0) {
                text.setData("");
            }
            if (text.getData().length() == 0) {
                list.add(node);
            }
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addTextNodesToRemoveAndTrim(list, node.getChildNodes().item(i));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Node toXml(String string, String string2) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        Document document;
        DocumentBuilder documentBuilder = null;
        try {
            String string3 = "<parent xmlns=\"" + string + "\">" + string2 + "</parent>";
            documentBuilder = this.getDocumentBuilderFromPool();
            document = documentBuilder.parse(new InputSource(new StringReader(string3)));
            if (this.ignoreProcessingInstructions) {
                object3 = new ArrayList<Node>();
                this.addProcessingInstructionsTo((List<Node>)object3, document);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Node)object2.next();
                    object.getParentNode().removeChild((Node)object);
                }
            }
            if (this.ignoreComments) {
                object3 = new ArrayList();
                this.addCommentsTo((List<Node>)object3, document);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Node)object2.next();
                    object.getParentNode().removeChild((Node)object);
                }
            }
            if (this.ignoreWhitespace) {
                object3 = new ArrayList();
                this.addTextNodesToRemoveAndTrim((List<Node>)object3, document);
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Node)object2.next();
                    object.getParentNode().removeChild((Node)object);
                }
            }
            if ((object3 = document.getDocumentElement().getChildNodes()).getLength() > 1) {
                throw ScriptRuntime.constructError("SyntaxError", "XML objects may contain at most one node.");
            }
            if (object3.getLength() == 0) {
                object = object2 = document.createTextNode("");
                if (documentBuilder != null) {
                    this.returnDocumentBuilderToPool(documentBuilder);
                }
                return object;
            }
        }
        catch (IOException iOException) {
            try {
                throw new RuntimeException("Unreachable.");
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new RuntimeException(parserConfigurationException);
                }
            }
            catch (Throwable throwable) {
                if (documentBuilder != null) {
                    this.returnDocumentBuilderToPool(documentBuilder);
                }
                throw throwable;
            }
        }
        {
            object2 = object3.item(0);
            document.getDocumentElement().removeChild((Node)object2);
            object = object2;
            if (documentBuilder != null) {
                this.returnDocumentBuilderToPool(documentBuilder);
            }
            return object;
        }
    }

    Document newDocument() {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = this.getDocumentBuilderFromPool();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        finally {
            if (documentBuilder != null) {
                this.returnDocumentBuilderToPool(documentBuilder);
            }
        }
    }

    private String toString(Node node) {
        DOMSource dOMSource = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            Transformer transformer = this.xform.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new RuntimeException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException);
        }
        return this.toXmlNewlines(stringWriter.toString());
    }

    String escapeAttributeValue(Object object) {
        String string = ScriptRuntime.toString(object);
        if (string.length() == 0) {
            return "";
        }
        Document document = this.newDocument();
        Element element = document.createElement("a");
        element.setAttribute("b", string);
        String string2 = this.toString(element);
        int n = string2.indexOf(34);
        int n2 = string2.lastIndexOf(34);
        return string2.substring(n + 1, n2);
    }

    String escapeTextValue(Object object) {
        if (object instanceof XMLObjectImpl) {
            return ((XMLObjectImpl)object).toXMLString();
        }
        String string = ScriptRuntime.toString(object);
        if (string.length() == 0) {
            return string;
        }
        Document document = this.newDocument();
        Element element = document.createElement("a");
        element.setTextContent(string);
        String string2 = this.toString(element);
        int n = string2.indexOf(62) + 1;
        int n2 = string2.lastIndexOf(60);
        return n < n2 ? string2.substring(n, n2) : "";
    }

    private String escapeElementValue(String string) {
        return this.escapeTextValue(string);
    }

    private String elementToXmlString(Element element) {
        Element element2 = (Element)element.cloneNode(true);
        if (this.prettyPrint) {
            this.beautifyElement(element2, 0);
        }
        return this.toString(element2);
    }

    final String ecmaToXmlString(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (this.prettyPrint) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(' ');
            }
        }
        if (node instanceof Text) {
            String string = ((Text)node).getData();
            String string2 = this.prettyPrint ? string.trim() : string;
            stringBuffer.append(this.escapeElementValue(string2));
            return stringBuffer.toString();
        }
        if (node instanceof Attr) {
            String string = ((Attr)node).getValue();
            stringBuffer.append(this.escapeAttributeValue(string));
            return stringBuffer.toString();
        }
        if (node instanceof Comment) {
            stringBuffer.append("<!--" + ((Comment)node).getNodeValue() + "-->");
            return stringBuffer.toString();
        }
        if (node instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            stringBuffer.append("<?" + processingInstruction.getTarget() + " " + processingInstruction.getData() + "?>");
            return stringBuffer.toString();
        }
        stringBuffer.append(this.elementToXmlString((Element)node));
        return stringBuffer.toString();
    }

    private void beautifyElement(Element element, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        String string = stringBuffer.toString();
        for (int i = 0; i < this.prettyIndent; ++i) {
            stringBuffer.append(' ');
        }
        String string2 = stringBuffer.toString();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = false;
        for (n2 = 0; n2 < element.getChildNodes().getLength(); ++n2) {
            if (n2 == 1) {
                bl = true;
            }
            if (element.getChildNodes().item(n2) instanceof Text) {
                arrayList.add(element.getChildNodes().item(n2));
                continue;
            }
            bl = true;
            arrayList.add(element.getChildNodes().item(n2));
        }
        if (bl) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                element.insertBefore(element.getOwnerDocument().createTextNode(string2), (Node)arrayList.get(n2));
            }
        }
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            arrayList2.add((Element)nodeList.item(i));
        }
        for (Element element2 : arrayList2) {
            this.beautifyElement(element2, n + this.prettyIndent);
        }
        if (bl) {
            element.appendChild(element.getOwnerDocument().createTextNode(string));
        }
    }

    private static class RhinoSAXErrorHandler
    implements ErrorHandler {
        private static final long serialVersionUID = 6918417235413084055L;

        private RhinoSAXErrorHandler() {
        }

        private void throwError(SAXParseException sAXParseException) {
            throw ScriptRuntime.constructError("TypeError", sAXParseException.getMessage(), sAXParseException.getLineNumber() - 1);
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            this.throwError(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            this.throwError(sAXParseException);
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            Context.reportWarning(sAXParseException.getMessage());
        }
    }
}

