/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.socket;

import cn.com.voltronic.solar.util.VolUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;

public class UdpClient {
    private String ip = "";
    private String port = "";
    private DatagramSocket ds = null;
    private InetAddress inetAddress;

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        try {
            return Integer.parseInt(this.port);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public UdpClient(String ip, String port) throws SocketException, UnknownHostException {
        this.ip = ip;
        this.port = port;
        this.ds = new DatagramSocket();
        this.ds.setSoTimeout(1000);
        this.inetAddress = InetAddress.getByName(this.getIp());
    }

    public byte[] receive() throws IOException {
        byte[] buffer = new byte[64];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        return buffer;
    }

    public void disconnect() {
        this.ds.disconnect();
        this.ds.close();
    }

    public void send(String cmd) throws IOException {
        cmd = String.valueOf(cmd) + '\r';
        byte[] cmdb = cmd.getBytes("UTF-8");
        int port = this.getPort();
        if (port > 0) {
            DatagramPacket dp = new DatagramPacket(cmdb, cmdb.length, this.inetAddress, this.getPort());
            this.ds.send(dp);
        }
    }

    public static void main(String[] args) {
        try {
            String serialno = "fdasdfasdfaf";
            Date trandate = new Date();
            String message = "fdsafdafd";
            UdpClient client = new UdpClient("127.0.0.1", "38693");
            client.send("(Event:[" + serialno + "] [" + VolUtil.getFormatTimestamp(trandate) + "] " + message + "13");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

