/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.CertStoreHelper;
import sun.security.util.Cache;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.URIName;

class URICertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final int CHECK_INTERVAL = 30000;
    private static final int CACHE_SIZE = 185;
    private final CertificateFactory factory;
    private Collection<X509Certificate> certs = Collections.emptySet();
    private X509CRL crl;
    private long lastChecked;
    private long lastModified;
    private URI uri;
    private boolean ldap = false;
    private CertStore ldapCertStore;
    private String ldapPath;
    private static final int DEFAULT_CRL_CONNECT_TIMEOUT = 15000;
    private static final int CRL_CONNECT_TIMEOUT = URICertStore.initializeTimeout();
    private static final Cache certStoreCache = Cache.newSoftMemoryCache(185);

    private static int initializeTimeout() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.crl.timeout"));
        if (n == null || n < 0) {
            return 15000;
        }
        return n * 1000;
    }

    URICertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof URICertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("params must be instanceof URICertStoreParameters");
        }
        this.uri = ((URICertStoreParameters)certStoreParameters).uri;
        if (this.uri.getScheme().toLowerCase(Locale.ENGLISH).equals("ldap")) {
            if (LDAP.helper() == null) {
                throw new NoSuchAlgorithmException("LDAP not present");
            }
            this.ldap = true;
            this.ldapCertStore = LDAP.helper().getCertStore(this.uri);
            this.ldapPath = this.uri.getPath();
            if (this.ldapPath.charAt(0) == '/') {
                this.ldapPath = this.ldapPath.substring(1);
            }
        }
        try {
            this.factory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new RuntimeException();
        }
    }

    static synchronized CertStore getInstance(URICertStoreParameters uRICertStoreParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CertStore certStore;
        if (debug != null) {
            debug.println("CertStore URI:" + uRICertStoreParameters.uri);
        }
        if ((certStore = (CertStore)certStoreCache.get(uRICertStoreParameters)) == null) {
            certStore = new UCS(new URICertStore(uRICertStoreParameters), null, "URI", uRICertStoreParameters);
            certStoreCache.put(uRICertStoreParameters, certStore);
        } else if (debug != null) {
            debug.println("URICertStore.getInstance: cache hit");
        }
        return certStore;
    }

    static CertStore getInstance(AccessDescription accessDescription) {
        if (!accessDescription.getAccessMethod().equals(AccessDescription.Ad_CAISSUERS_Id)) {
            return null;
        }
        GeneralNameInterface generalNameInterface = accessDescription.getAccessLocation().getName();
        if (!(generalNameInterface instanceof URIName)) {
            return null;
        }
        URI uRI = ((URIName)generalNameInterface).getURI();
        try {
            return URICertStore.getInstance(new URICertStoreParameters(uRI));
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("exception creating CertStore: " + exception);
                exception.printStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509Certificate> engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (this.ldap) {
            X509CertSelector x509CertSelector = (X509CertSelector)certSelector;
            try {
                x509CertSelector = LDAP.helper().wrap(x509CertSelector, x509CertSelector.getSubject(), this.ldapPath);
                return this.ldapCertStore.getCertificates(x509CertSelector);
            }
            catch (IOException iOException) {
                throw new CertStoreException(iOException);
            }
        }
        long l = System.currentTimeMillis();
        if (l - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCerts(this.certs, certSelector);
            debug.println("Returning certificates from cache");
            return URICertStore.getMatchingCerts(this.certs, certSelector);
        }
        this.lastChecked = l;
        InputStream inputStream = null;
        try {
            Object object;
            URLConnection uRLConnection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                uRLConnection.setIfModifiedSince(this.lastModified);
            }
            inputStream = uRLConnection.getInputStream();
            long l2 = this.lastModified;
            this.lastModified = uRLConnection.getLastModified();
            if (l2 != 0L) {
                if (l2 == this.lastModified) {
                    if (debug != null) {
                        debug.println("Not modified, using cached copy");
                    }
                    Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, certSelector);
                    return collection;
                }
                if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)(object = (HttpURLConnection)uRLConnection)).getResponseCode() == 304) {
                    if (debug != null) {
                        debug.println("Not modified, using cached copy");
                    }
                    Collection<X509Certificate> collection = URICertStore.getMatchingCerts(this.certs, certSelector);
                    return collection;
                }
            }
            if (debug != null) {
                debug.println("Downloading new certificates...");
            }
            this.certs = this.factory.generateCertificates(inputStream);
            object = URICertStore.getMatchingCerts(this.certs, certSelector);
            return object;
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("Exception fetching certificates:");
                iOException.printStackTrace();
            }
        }
        catch (CertificateException certificateException) {
            if (debug != null) {
                debug.println("Exception fetching certificates:");
                certificateException.printStackTrace();
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.lastModified = 0L;
        this.certs = Collections.emptySet();
        return this.certs;
    }

    private static Collection<X509Certificate> getMatchingCerts(Collection<X509Certificate> collection, CertSelector certSelector) {
        if (certSelector == null) {
            return collection;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(collection.size());
        for (X509Certificate x509Certificate : collection) {
            if (!certSelector.match(x509Certificate)) continue;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Collection<X509CRL> engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (this.ldap) {
            X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
            try {
                x509CRLSelector = LDAP.helper().wrap(x509CRLSelector, null, this.ldapPath);
                return this.ldapCertStore.getCRLs(x509CRLSelector);
            }
            catch (IOException iOException) {
                throw new CertStoreException(iOException);
            }
        }
        long l = System.currentTimeMillis();
        if (l - this.lastChecked < 30000L) {
            if (debug == null) return URICertStore.getMatchingCRLs(this.crl, cRLSelector);
            debug.println("Returning CRL from cache");
            return URICertStore.getMatchingCRLs(this.crl, cRLSelector);
        }
        this.lastChecked = l;
        InputStream inputStream = null;
        try {
            Object object;
            URLConnection uRLConnection = this.uri.toURL().openConnection();
            if (this.lastModified != 0L) {
                uRLConnection.setIfModifiedSince(this.lastModified);
            }
            uRLConnection.setConnectTimeout(CRL_CONNECT_TIMEOUT);
            inputStream = uRLConnection.getInputStream();
            long l2 = this.lastModified;
            this.lastModified = uRLConnection.getLastModified();
            if (l2 != 0L) {
                if (l2 == this.lastModified) {
                    if (debug != null) {
                        debug.println("Not modified, using cached copy");
                    }
                    Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, cRLSelector);
                    return collection;
                }
                if (uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)(object = (HttpURLConnection)uRLConnection)).getResponseCode() == 304) {
                    if (debug != null) {
                        debug.println("Not modified, using cached copy");
                    }
                    Collection<X509CRL> collection = URICertStore.getMatchingCRLs(this.crl, cRLSelector);
                    return collection;
                }
            }
            if (debug != null) {
                debug.println("Downloading new CRL...");
            }
            this.crl = (X509CRL)this.factory.generateCRL(inputStream);
            object = URICertStore.getMatchingCRLs(this.crl, cRLSelector);
            return object;
        }
        catch (IOException iOException) {
            if (debug != null) {
                debug.println("Exception fetching CRL:");
                iOException.printStackTrace();
            }
        }
        catch (CRLException cRLException) {
            if (debug != null) {
                debug.println("Exception fetching CRL:");
                cRLException.printStackTrace();
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.lastModified = 0L;
        this.crl = null;
        return Collections.emptyList();
    }

    private static Collection<X509CRL> getMatchingCRLs(X509CRL x509CRL, CRLSelector cRLSelector) {
        if (cRLSelector == null || x509CRL != null && cRLSelector.match(x509CRL)) {
            return Collections.singletonList(x509CRL);
        }
        return Collections.emptyList();
    }

    private static class UCS
    extends CertStore {
        protected UCS(CertStoreSpi certStoreSpi, Provider provider, String string, CertStoreParameters certStoreParameters) {
            super(certStoreSpi, provider, string, certStoreParameters);
        }
    }

    static class URICertStoreParameters
    implements CertStoreParameters {
        private final URI uri;
        private volatile int hashCode = 0;

        URICertStoreParameters(URI uRI) {
            this.uri = uRI;
        }

        public boolean equals(Object object) {
            if (!(object instanceof URICertStoreParameters)) {
                return false;
            }
            URICertStoreParameters uRICertStoreParameters = (URICertStoreParameters)object;
            return this.uri.equals(uRICertStoreParameters.uri);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n = 17;
                this.hashCode = n = 37 * n + this.uri.hashCode();
            }
            return this.hashCode;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.toString());
            }
        }
    }

    private static class LDAP {
        private static final String CERT_STORE_HELPER = "sun.security.provider.certpath.ldap.LDAPCertStoreHelper";
        private static final CertStoreHelper helper = AccessController.doPrivileged(new PrivilegedAction<CertStoreHelper>(){

            @Override
            public CertStoreHelper run() {
                try {
                    Class<?> clazz = Class.forName(LDAP.CERT_STORE_HELPER, true, null);
                    return (CertStoreHelper)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                catch (InstantiationException instantiationException) {
                    throw new AssertionError((Object)instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
            }
        });

        private LDAP() {
        }

        static CertStoreHelper helper() {
            return helper;
        }
    }
}

