/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.SynchroEnergyPlan;
import cn.com.voltronic.solar.dbtools.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SynchroEnergyDao
extends BaseDao {
    public static final String QUERY = " SELECT * FROM synchroenergyplan";
    public static final String QUERY_EXIST = " SELECT * FROM synchroenergyplan where serialno = ?";
    public static final String INSERT = " INSERT INTO synchroenergyplan(serialno,cycle,plan_week,PLAN_MONTH,PLAN_TIME,synchroTime) VALUES(?,?,?,?,?,?)";
    public static final String DELETE = " delete from  synchroenergyplan where serialno = ?";

    public List<SynchroEnergyPlan> querySynchroEnergyPlan() {
        ArrayList<SynchroEnergyPlan> result;
        block6: {
            result = new ArrayList<SynchroEnergyPlan>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(QUERY);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        SynchroEnergyPlan plan = new SynchroEnergyPlan();
                        plan.setSerialno(rs.getString("serialno"));
                        plan.setCycle(rs.getString("CYCLE"));
                        plan.setPlanMonth(rs.getInt("PLAN_MONTH"));
                        plan.setPlanTime(rs.getTimestamp("PLAN_TIME"));
                        plan.setPlanWeek(rs.getInt("PLAN_WEEK"));
                        plan.setSynchroTime(rs.getInt("synchrotime"));
                        result.add(plan);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean ifPlanExist(String serialno) {
        boolean result;
        block6: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement(QUERY_EXIST);
                    ps.setString(1, serialno);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        result = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean insertPlan(SynchroEnergyPlan plan) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(INSERT);
                ps.setString(1, plan.getSerialno());
                ps.setString(2, plan.getCycle());
                ps.setInt(3, plan.getPlanWeek());
                ps.setInt(4, plan.getPlanMonth());
                ps.setTimestamp(5, new Timestamp(plan.getPlanTime().getTime()));
                ps.setInt(6, plan.getSynchroTime());
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean deletePlan(String serialno) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(DELETE);
                ps.setString(1, serialno);
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }
}

