/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.webservice;

import cn.com.voltronic.solar.beanbag.BeanBag;
import cn.com.voltronic.solar.beanbag.P15BeanBag;
import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.dao.EnergyDao;
import cn.com.voltronic.solar.dao.PriceDao;
import cn.com.voltronic.solar.data.bean.Electrovalence;
import cn.com.voltronic.solar.data.bean.EnergyBean;
import cn.com.voltronic.solar.data.bean.MonthEnergy;
import cn.com.voltronic.solar.data.bean.PriceItem;
import cn.com.voltronic.solar.data.bean.TotalPower;
import cn.com.voltronic.solar.data.bean.TotalPowerMonth;
import cn.com.voltronic.solar.data.bean.YearEnergy;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.VolUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class WebServices {
    private static int REJECT_MINUTES = 1;

    public String findProcessor(String processorKey) {
        if (GlobalProcessors.findProcessor(processorKey) == null) {
            return "notfind";
        }
        return processorKey;
    }

    public BeanBag getMonitorData(String processorKey) {
        AbstractProcessor processor = GlobalProcessors.findProcessor(processorKey);
        if (processor != null) {
            return processor.getBeanBag();
        }
        return new P15BeanBag();
    }

    public Object getBean(String processorKey, String beanName) {
        BeanBag bag = this.getMonitorData(processorKey);
        if (bag != null) {
            return bag.getBean(beanName);
        }
        return null;
    }

    public boolean executeControl(String processorKey, String controlMethod, Object[] paras) {
        AbstractProcessor processor = GlobalProcessors.findProcessor(processorKey);
        if (processor != null) {
            return processor.executeControl(controlMethod, paras);
        }
        return false;
    }

    public boolean executeQuery(String processorKey, String queryMehotd) {
        AbstractProcessor processor = GlobalProcessors.findProcessor(processorKey);
        if (processor != null) {
            return processor.executeQuery(queryMehotd);
        }
        return false;
    }

    public Date queryMachineDate(String processorKey) {
        if (processorKey == null || "".equals(processorKey)) {
            return null;
        }
        AbstractProcessor processor = GlobalProcessors.findProcessor(processorKey);
        if (processor != null) {
            Calendar ca = null;
            try {
                ca = processor.getCurrentTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (ca == null) {
                return null;
            }
            return ca.getTime();
        }
        return null;
    }

    public List<String> getEnergyAllSerialNo(String mark) {
        DeviceDao dao = new DeviceDao();
        List<String> list = dao.querySerialnoAll();
        return list;
    }

    public List<EnergyBean> queryYearwithoutPrice(String processorKey, String serial, int startyear, int endyear, boolean queryHistory) {
        EnergyDao energydao = new EnergyDao();
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        if (queryHistory) {
            return energydao.queryYear(serial, startyear, endyear);
        }
        AbstractProcessor processor = GlobalProcessors.findProcessor(processorKey);
        if (processor != null) {
            EnergyBean bean = new EnergyBean();
            bean.setComplete(false);
            bean.setQueryperiod(0);
            bean.setYear(startyear);
            String startyearmonth = String.format("%4d%02d", startyear, 1);
            String endyearmonth = String.format("%4d%02d", endyear, 12);
            double energy = energydao.queryYearEnergy(serial, startyearmonth, endyearmonth);
            bean.setQuantity(energy);
            energydao.insertYear(processor.getProtocol().getProtocolID(), serial, bean);
            list.add(bean);
        }
        return list;
    }

    public List<EnergyBean> queryYearwithoutPriceForP18(String processorKey, String serial, int startyear, int endyear, boolean queryHistory) {
        EnergyDao energydao = new EnergyDao();
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        if (queryHistory) {
            return energydao.queryYear(serial, startyear, endyear);
        }
        AbstractProcessor processor = GlobalProcessors.findProcessor(processorKey);
        if (processor != null) {
            int year = startyear;
            while (year <= endyear) {
                boolean isException = false;
                double energy = 0.0;
                try {
                    energy = processor.queryEnergyYear(year);
                }
                catch (Exception e) {
                    energy = 0.0;
                    isException = true;
                }
                energy = VolUtil.round(energy * 0.001, 3);
                EnergyBean bean = new EnergyBean();
                bean.setComplete(true);
                bean.setQueryperiod(0);
                bean.setYear(year);
                bean.setQuantity(energy);
                if (!isException) {
                    energydao.insertYear(processor.getProtocol().getProtocolID(), serial, bean);
                    list.add(bean);
                }
                ++year;
            }
        }
        return list;
    }

    public List<EnergyBean> queryYearwithoutPriceForP1730K(String processorKey, String serial, int startyear, int endyear, boolean queryHistory) {
        EnergyDao energydao = new EnergyDao();
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        if (queryHistory) {
            return energydao.queryYear(serial, startyear, endyear);
        }
        AbstractProcessor processor = GlobalProcessors.findProcessor(processorKey);
        if (processor != null) {
            int year = startyear;
            while (year <= endyear) {
                boolean isException = false;
                double energy = 0.0;
                try {
                    energy = processor.queryEnergyYear(year);
                }
                catch (Exception e) {
                    energy = 0.0;
                    isException = true;
                }
                energy = VolUtil.round(energy * 0.001, 3);
                EnergyBean bean = new EnergyBean();
                bean.setComplete(true);
                bean.setQueryperiod(0);
                bean.setYear(year);
                bean.setQuantity(energy);
                if (!isException) {
                    energydao.insertYear(processor.getProtocol().getProtocolID(), serial, bean);
                    list.add(bean);
                }
                ++year;
            }
        }
        return list;
    }

    public List<YearEnergy> queryYearwithPriceView(String processorKey, String serial, int startyear, int endyear) {
        List<EnergyBean> resultList = this.queryYearwithPrice(processorKey, serial, startyear, endyear);
        ArrayList<YearEnergy> returnList = new ArrayList<YearEnergy>();
        int oldyear = startyear;
        double power = 0.0;
        double money = 0.0;
        ArrayList<TotalPower> list = new ArrayList<TotalPower>();
        oldyear = resultList.get(0).getYear();
        power = resultList.get(0).getQuantity();
        money = resultList.get(0).getAmount();
        if (resultList.size() > 1) {
            int i = 1;
            while (i < resultList.size()) {
                int year = resultList.get(i).getYear();
                if (year == oldyear) {
                    power += resultList.get(i).getQuantity();
                    money += resultList.get(i).getAmount();
                    if (i + 1 == resultList.size()) {
                        list.add(new TotalPower(year, power, money));
                    }
                } else {
                    list.add(new TotalPower(oldyear, power, money));
                    power = resultList.get(i).getQuantity();
                    money = resultList.get(i).getAmount();
                    oldyear = year;
                    if (i + 1 == resultList.size()) {
                        list.add(new TotalPower(oldyear, power, money));
                    }
                }
                ++i;
            }
        } else {
            list.add(new TotalPower(oldyear, power, money));
        }
        for (EnergyBean bean : resultList) {
            SimpleDateFormat sdf = this.getSimpleDateFormat();
            String period = String.valueOf(sdf.format(bean.getTrandate().getTime())) + "--" + sdf.format(bean.getEnddate().getTime());
            double price = bean.getPrice();
            double quantity = bean.getQuantity();
            double amount = bean.getAmount();
            int year = bean.getYear();
            YearEnergy energy = new YearEnergy();
            energy.setYear(year);
            energy.setAmount(amount);
            energy.setQuantity(quantity);
            energy.setDateperiod(period);
            energy.setPrice(price);
            int j = 0;
            while (j < list.size()) {
                if (((TotalPower)list.get(j)).getYear() == year) {
                    energy.setTotalQuantity(((TotalPower)list.get(j)).getPower());
                    energy.setTotalAmount(((TotalPower)list.get(j)).getMoney());
                    break;
                }
                ++j;
            }
            returnList.add(energy);
        }
        return returnList;
    }

    private List<EnergyBean> queryYearwithPrice(String processorKey, String serial, int startyear, int endyear) {
        PriceDao dao = new PriceDao();
        List<Electrovalence> prices = dao.queryElectrovalence();
        Calendar firstdate = null;
        Calendar lastdate = null;
        ArrayList<PriceItem> items = new ArrayList<PriceItem>();
        int year = startyear;
        while (year <= endyear) {
            firstdate = Calendar.getInstance();
            firstdate.set(year, 0, 1);
            lastdate = Calendar.getInstance();
            lastdate.set(year, 11, 31);
            List<PriceItem> subitems = this.getPriceItems(prices, firstdate, lastdate);
            int index = 0;
            while (index < subitems.size()) {
                items.add(subitems.get(index));
                ++index;
            }
            ++year;
        }
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        int index = 0;
        while (index < items.size()) {
            PriceItem price = (PriceItem)items.get(index);
            int oneyear = price.getStartdate().get(1);
            if (DateUtils.isFullYear(price.getStartdate(), price.getEnddate())) {
                List<EnergyBean> sublist = this.queryYearwithoutPrice(processorKey, serial, oneyear, oneyear, true);
                if (sublist != null && sublist.size() == 1) {
                    EnergyBean bean = sublist.get(0);
                    bean.setPrice(price.getPrice());
                    bean.setTrandate(price.getStartdate());
                    bean.setEnddate(price.getEnddate());
                    list.add(bean);
                }
            } else {
                EnergyBean bean = new EnergyBean();
                bean.setQueryperiod(0);
                bean.setYear(oneyear);
                bean.setTrandate(price.getStartdate());
                bean.setEnddate(price.getEnddate());
                bean.setPrice(price.getPrice());
                double quantity = 0.0;
                Calendar startdate = (Calendar)price.getStartdate().clone();
                while (startdate.compareTo(price.getEnddate()) <= 0) {
                    Calendar enddate = DateUtils.getEndofMonth(startdate);
                    if (enddate.after(price.getEnddate())) {
                        enddate = (Calendar)price.getEnddate().clone();
                    }
                    List<EnergyBean> subitems = null;
                    if (DateUtils.isFullMonth(startdate, enddate)) {
                        int month = startdate.get(2) + 1;
                        subitems = this.queryMonthwithoutPrice(processorKey, serial, oneyear, month, oneyear, month, true);
                    } else {
                        subitems = this.queryDaywithoutPrice(processorKey, serial, startdate, enddate, true);
                    }
                    for (EnergyBean mbean : subitems) {
                        quantity += mbean.getQuantity();
                    }
                    startdate = DateUtils.getNextMonth(startdate);
                }
                bean.setQuantity(quantity);
                list.add(bean);
            }
            ++index;
        }
        return list;
    }

    public List<EnergyBean> queryMonthwithoutPrice(String processorKey, String serial, int startyear, int startmonth, int endyear, int endmonth, boolean queryHistory) {
        AbstractProcessor processor;
        EnergyDao energydao = new EnergyDao();
        String startyearmonth = String.format("%4d%02d", startyear, startmonth);
        String endyearmonth = String.format("%4d%02d", endyear, endmonth);
        if (!queryHistory && (processor = GlobalProcessors.findProcessor(processorKey)) != null) {
            Calendar current = processor.getCurrentTime();
            int currentMonth = current.get(2) + 1;
            String curYearmonth = String.format("%4d%02d", startyear, currentMonth);
            EnergyBean energy = new EnergyBean();
            energy.setComplete(false);
            Calendar startdate = Calendar.getInstance();
            startdate.set(startyear, current.get(2), 1);
            Calendar enddate = DateUtils.getEndofMonth(startdate);
            double energyValue = energydao.queryMonthEnergy(serial, startdate, enddate);
            energy.setQuantity(energyValue);
            energy.setQueryperiod(1);
            energy.setYear(startyear);
            energy.setYearmonth(curYearmonth);
            energydao.insertMonth(processor.getProtocol().getProtocolID(), serial, energy);
        }
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        List<EnergyBean> historylist = energydao.queryMonth(serial, startyearmonth, endyearmonth);
        while (startmonth <= endmonth) {
            EnergyBean bean = new EnergyBean();
            String yearmonth = String.format("%4d%02d", startyear, startmonth);
            boolean found = false;
            for (EnergyBean energy : historylist) {
                if (energy.getYearmonth().compareTo(yearmonth) != 0) continue;
                found = true;
                bean = energy;
                break;
            }
            if (!found) {
                bean.setQueryperiod(1);
                bean.setQuantity(0.0);
                bean.setYear(startyear);
                bean.setYearmonth(yearmonth);
            }
            list.add(bean);
            ++startmonth;
        }
        return list;
    }

    public List<EnergyBean> queryMonthwithoutPriceForP18(String processorKey, String serial, int startyear, int startmonth, int endyear, int endmonth, boolean queryHistory) {
        AbstractProcessor processor;
        EnergyDao energydao = new EnergyDao();
        String startyearmonth = String.format("%4d%02d", startyear, startmonth);
        String endyearmonth = String.format("%4d%02d", endyear, endmonth);
        if (!queryHistory && (processor = GlobalProcessors.findProcessor(processorKey)) != null) {
            int year = startyear;
            while (year <= endyear) {
                int month = 1;
                while (month <= 12) {
                    boolean isException = false;
                    String yearmonth = String.format("%4d%02d", year, month);
                    double energy = 0.0;
                    try {
                        energy = processor.queryEnergyMonth(startyear, month);
                    }
                    catch (Exception e) {
                        energy = 0.0;
                        isException = true;
                    }
                    energy = VolUtil.round(energy * 0.001, 3);
                    EnergyBean bean = new EnergyBean();
                    bean.setComplete(true);
                    bean.setQuantity(energy);
                    bean.setQueryperiod(1);
                    bean.setYear(year);
                    bean.setYearmonth(yearmonth);
                    if (!isException) {
                        energydao.insertMonth(processor.getProtocol().getProtocolID(), serial, bean);
                    }
                    ++month;
                }
                ++year;
            }
        }
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        List<EnergyBean> historylist = energydao.queryMonth(serial, startyearmonth, endyearmonth);
        while (startmonth <= endmonth) {
            EnergyBean bean = new EnergyBean();
            String yearmonth = String.format("%4d%02d", startyear, startmonth);
            boolean found = false;
            for (EnergyBean energy : historylist) {
                if (energy.getYearmonth().compareTo(yearmonth) != 0) continue;
                found = true;
                bean = energy;
                break;
            }
            if (!found) {
                bean.setQueryperiod(1);
                bean.setQuantity(0.0);
                bean.setYear(startyear);
                bean.setYearmonth(yearmonth);
            }
            list.add(bean);
            ++startmonth;
        }
        return list;
    }

    public List<EnergyBean> queryMonthwithoutPriceForP1730K(String processorKey, String serial, int startyear, int startmonth, int endyear, int endmonth, boolean queryHistory) {
        AbstractProcessor processor;
        EnergyDao energydao = new EnergyDao();
        String startyearmonth = String.format("%4d%02d", startyear, startmonth);
        String endyearmonth = String.format("%4d%02d", endyear, endmonth);
        if (!queryHistory && (processor = GlobalProcessors.findProcessor(processorKey)) != null) {
            int year = startyear;
            while (year <= endyear) {
                int month = 1;
                while (month <= 12) {
                    boolean isException = false;
                    String yearmonth = String.format("%4d%02d", year, month);
                    double energy = 0.0;
                    try {
                        energy = processor.queryEnergyMonth(startyear, month);
                    }
                    catch (Exception e) {
                        energy = 0.0;
                        isException = true;
                    }
                    energy = VolUtil.round(energy * 0.001, 3);
                    EnergyBean bean = new EnergyBean();
                    bean.setComplete(true);
                    bean.setQuantity(energy);
                    bean.setQueryperiod(1);
                    bean.setYear(year);
                    bean.setYearmonth(yearmonth);
                    if (!isException) {
                        energydao.insertMonth(processor.getProtocol().getProtocolID(), serial, bean);
                    }
                    ++month;
                }
                ++year;
            }
        }
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        List<EnergyBean> historylist = energydao.queryMonth(serial, startyearmonth, endyearmonth);
        while (startmonth <= endmonth) {
            EnergyBean bean = new EnergyBean();
            String yearmonth = String.format("%4d%02d", startyear, startmonth);
            boolean found = false;
            for (EnergyBean energy : historylist) {
                if (energy.getYearmonth().compareTo(yearmonth) != 0) continue;
                found = true;
                bean = energy;
                break;
            }
            if (!found) {
                bean.setQueryperiod(1);
                bean.setQuantity(0.0);
                bean.setYear(startyear);
                bean.setYearmonth(yearmonth);
            }
            list.add(bean);
            ++startmonth;
        }
        return list;
    }

    public List<MonthEnergy> queryMonthwithPriceView(String processorKey, String serial, int startyear, int startmonth, int endyear, int endmonth) {
        List<EnergyBean> resultList = this.queryMonthwithPrice(processorKey, serial, startyear, startmonth, endyear, endmonth);
        ArrayList<MonthEnergy> returnList = new ArrayList<MonthEnergy>();
        String oldyearmonth = "" + startyear + startmonth;
        double power = 0.0;
        double money = 0.0;
        ArrayList<TotalPowerMonth> list = new ArrayList<TotalPowerMonth>();
        oldyearmonth = resultList.get(0).getYearmonth();
        power = resultList.get(0).getQuantity();
        money = resultList.get(0).getAmount();
        if (resultList.size() > 1) {
            int i = 1;
            while (i < resultList.size()) {
                String yearmonth = resultList.get(i).getYearmonth();
                if (yearmonth.equals(oldyearmonth)) {
                    power += resultList.get(i).getQuantity();
                    money += resultList.get(i).getAmount();
                    if (i + 1 == resultList.size()) {
                        list.add(new TotalPowerMonth(yearmonth, power, money));
                    }
                } else {
                    list.add(new TotalPowerMonth(oldyearmonth, power, money));
                    power = resultList.get(i).getQuantity();
                    money = resultList.get(i).getAmount();
                    oldyearmonth = yearmonth;
                    if (i + 1 == resultList.size()) {
                        list.add(new TotalPowerMonth(oldyearmonth, power, money));
                    }
                }
                ++i;
            }
        } else {
            list.add(new TotalPowerMonth(oldyearmonth, power, money));
        }
        for (EnergyBean bean : resultList) {
            SimpleDateFormat sdf = this.getSimpleDateFormat();
            String period = String.valueOf(sdf.format(bean.getTrandate().getTime())) + "--" + sdf.format(bean.getEnddate().getTime());
            double price = bean.getPrice();
            double quantity = bean.getQuantity();
            double amount = bean.getAmount();
            String yearmonth = bean.getYearmonth();
            MonthEnergy energy = new MonthEnergy();
            energy.setYearmonth(yearmonth);
            energy.setAmount(amount);
            energy.setQuantity(quantity);
            energy.setDateperiod(period);
            energy.setPrice(price);
            int j = 0;
            while (j < list.size()) {
                if (((TotalPowerMonth)list.get(j)).getYearmonth().equals(yearmonth)) {
                    energy.setTotalQuantity(((TotalPowerMonth)list.get(j)).getPower());
                    energy.setTotalAmount(((TotalPowerMonth)list.get(j)).getMoney());
                    break;
                }
                ++j;
            }
            returnList.add(energy);
        }
        return returnList;
    }

    public List<EnergyBean> queryMonthwithPrice(String processorKey, String serial, int startyear, int startmonth, int endyear, int endmonth) {
        PriceDao dao = new PriceDao();
        List<Electrovalence> prices = dao.queryElectrovalence();
        Calendar firstdate = null;
        Calendar lastdate = null;
        ArrayList<PriceItem> items = new ArrayList<PriceItem>();
        int year = startyear;
        while (year <= endyear) {
            int month = 1;
            while (month <= 12) {
                if (!(year == startyear && month < startmonth || year == endyear && month > endmonth)) {
                    firstdate = Calendar.getInstance();
                    firstdate.set(year, month - 1, 1);
                    lastdate = DateUtils.getEndofMonth(firstdate);
                    List<PriceItem> subitems = this.getPriceItems(prices, firstdate, lastdate);
                    int index = 0;
                    while (index < subitems.size()) {
                        items.add(subitems.get(index));
                        ++index;
                    }
                }
                ++month;
            }
            ++year;
        }
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        int index = 0;
        while (index < items.size()) {
            PriceItem price = (PriceItem)items.get(index);
            int year2 = price.getStartdate().get(1);
            int month = price.getStartdate().get(2) + 1;
            String yearmonth = String.format("%4d%02d", year2, month);
            EnergyBean bean = new EnergyBean();
            bean.setQueryperiod(1);
            bean.setYearmonth(yearmonth);
            bean.setTrandate(price.getStartdate());
            bean.setEnddate(price.getEnddate());
            bean.setPrice(price.getPrice());
            double quantity = 0.0;
            List<EnergyBean> subitems = null;
            subitems = DateUtils.isFullMonth(price.getStartdate(), price.getEnddate()) ? this.queryMonthwithoutPrice(processorKey, serial, year2, month, year2, month, true) : this.queryDaywithoutPrice(processorKey, serial, price.getStartdate(), price.getEnddate(), true);
            for (EnergyBean mbean : subitems) {
                quantity += mbean.getQuantity();
            }
            bean.setQuantity(quantity);
            list.add(bean);
            ++index;
        }
        return list;
    }

    public List<EnergyBean> queryDaywithoutPrice(String processorKey, String serial, Calendar startdate0, Calendar enddate0, boolean queryHistory) {
        EnergyDao energydao = new EnergyDao();
        Calendar startdate = DateUtils.getShortdate(startdate0);
        Calendar enddate = DateUtils.getShortdate(enddate0);
        List<EnergyBean> list = energydao.queryDay(serial, startdate, enddate);
        try {
            AbstractProcessor processor = null;
            if (!queryHistory) {
                processor = GlobalProcessors.findProcessor(processorKey);
            }
            int listindex = 0;
            while (startdate.compareTo(enddate) <= 0) {
                boolean found = false;
                boolean addEmpty = false;
                while (listindex < list.size() && list.get(listindex).getTrandate().before(startdate)) {
                    ++listindex;
                }
                if (listindex < list.size() && list.get(listindex).getTrandate().compareTo(startdate) == 0) {
                    found = true;
                }
                if (listindex < list.size() && !list.get(listindex).isComplete() && processor != null) {
                    list.remove(listindex);
                    found = false;
                }
                if (!found && processor != null) {
                    Calendar current = processor.getCurrentTime();
                    if (current != null) {
                        Calendar currentonlydate = DateUtils.getShortdate(current);
                        if (startdate.compareTo(currentonlydate) < 0) {
                            double energy = 0.0;
                            boolean isException = false;
                            if (startdate.compareTo(currentonlydate) <= 0) {
                                try {
                                    energy = processor.queryEnergyDay(startdate);
                                    if (this.dayEnergyException(processor, energy)) {
                                        energy = this.sumHoursEnergy(processorKey, serial, startdate, 0, startdate, 23, false);
                                        energy *= 1000.0;
                                    }
                                }
                                catch (Exception ex) {
                                    isException = true;
                                }
                            } else {
                                energy = energydao.querySummaryHour(serial, currentonlydate);
                                energy *= 1000.0;
                            }
                            EnergyBean bean = new EnergyBean();
                            if (currentonlydate.compareTo(startdate) == 0) {
                                bean.setComplete(false);
                            } else {
                                bean.setComplete(true);
                                currentonlydate.add(5, -1);
                                if (currentonlydate.compareTo(startdate) == 0 && current.get(11) == 0 && current.get(12) < REJECT_MINUTES) {
                                    bean.setComplete(false);
                                }
                            }
                            energy = VolUtil.round(energy * 0.001, 3);
                            bean.setQueryperiod(2);
                            bean.setQuantity(energy);
                            bean.setTrandate((Calendar)startdate.clone());
                            if (!isException) {
                                energydao.insertDay(processor.getProtocol().getProtocolID(), serial, bean);
                            }
                            list.add(listindex, bean);
                        } else {
                            addEmpty = true;
                        }
                    } else {
                        addEmpty = true;
                    }
                } else if (!found) {
                    addEmpty = true;
                }
                if (addEmpty) {
                    EnergyBean bean = new EnergyBean();
                    bean.setQueryperiod(2);
                    bean.setQuantity(0.0);
                    bean.setTrandate((Calendar)startdate.clone());
                    list.add(listindex, bean);
                }
                startdate.add(5, 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<EnergyBean> queryDaywithoutPriceForP18(String processorKey, String serial, Calendar startdate0, Calendar enddate0, boolean queryHistory) {
        AbstractProcessor processor;
        EnergyDao energydao = new EnergyDao();
        Calendar startdate = DateUtils.getShortdate(startdate0);
        Calendar historyStartdate = DateUtils.getShortdate(startdate0);
        Calendar enddate = DateUtils.getShortdate(enddate0);
        List<EnergyBean> historylist = energydao.queryDay(serial, startdate, enddate);
        if (!queryHistory && (processor = GlobalProcessors.findProcessor(processorKey)) != null) {
            while (startdate.compareTo(enddate) <= 0) {
                Calendar current = processor.getCurrentTime();
                if (current != null) {
                    EnergyBean bean = new EnergyBean();
                    bean.setQueryperiod(2);
                    bean.setTrandate((Calendar)startdate.clone());
                    double energy = 0.0;
                    boolean isException = false;
                    Calendar currentonlydate = DateUtils.getShortdate(current);
                    if (startdate.compareTo(currentonlydate) > 0) {
                        bean.setQuantity(energy);
                    } else {
                        try {
                            energy = processor.queryEnergyDay(startdate);
                        }
                        catch (Exception ex) {
                            isException = true;
                        }
                        energy = VolUtil.round(energy * 0.001, 3);
                        bean.setQuantity(energy);
                    }
                    if (!isException) {
                        energydao.insertDay(processor.getProtocol().getProtocolID(), serial, bean);
                    }
                }
                startdate.add(5, 1);
            }
        }
        startdate = historyStartdate;
        historylist = energydao.queryDay(serial, startdate, enddate);
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        while (startdate.compareTo(enddate) <= 0) {
            EnergyBean bean = new EnergyBean();
            boolean found = false;
            for (EnergyBean energy : historylist) {
                if (energy.getTrandate().compareTo(startdate) != 0) continue;
                found = true;
                bean = energy;
                break;
            }
            if (!found) {
                bean.setQueryperiod(2);
                bean.setQuantity(0.0);
                bean.setTrandate((Calendar)startdate.clone());
            }
            list.add(bean);
            startdate.add(5, 1);
        }
        return list;
    }

    public List<EnergyBean> queryDaywithoutPriceForP1730K(String processorKey, String serial, Calendar startdate0, Calendar enddate0, boolean queryHistory) {
        AbstractProcessor processor;
        EnergyDao energydao = new EnergyDao();
        Calendar startdate = DateUtils.getShortdate(startdate0);
        Calendar historyStartdate = DateUtils.getShortdate(startdate0);
        Calendar enddate = DateUtils.getShortdate(enddate0);
        List<EnergyBean> historylist = energydao.queryDay(serial, startdate, enddate);
        if (!queryHistory && (processor = GlobalProcessors.findProcessor(processorKey)) != null) {
            while (startdate.compareTo(enddate) <= 0) {
                Calendar current = processor.getCurrentTime();
                if (current != null) {
                    EnergyBean bean = new EnergyBean();
                    bean.setQueryperiod(2);
                    bean.setTrandate((Calendar)startdate.clone());
                    double energy = 0.0;
                    boolean isException = false;
                    Calendar currentonlydate = DateUtils.getShortdate(current);
                    if (startdate.compareTo(currentonlydate) > 0) {
                        bean.setQuantity(energy);
                    } else {
                        try {
                            energy = processor.queryEnergyDay(startdate);
                        }
                        catch (Exception ex) {
                            isException = true;
                        }
                        energy = VolUtil.round(energy * 0.001, 3);
                        bean.setQuantity(energy);
                    }
                    if (!isException) {
                        energydao.insertDay(processor.getProtocol().getProtocolID(), serial, bean);
                    }
                }
                startdate.add(5, 1);
            }
        }
        startdate = historyStartdate;
        historylist = energydao.queryDay(serial, startdate, enddate);
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        while (startdate.compareTo(enddate) <= 0) {
            EnergyBean bean = new EnergyBean();
            boolean found = false;
            for (EnergyBean energy : historylist) {
                if (energy.getTrandate().compareTo(startdate) != 0) continue;
                found = true;
                bean = energy;
                break;
            }
            if (!found) {
                bean.setQueryperiod(2);
                bean.setQuantity(0.0);
                bean.setTrandate((Calendar)startdate.clone());
            }
            list.add(bean);
            startdate.add(5, 1);
        }
        return list;
    }

    public List<EnergyBean> queryDaywithPrice(String processorKey, String serial, Calendar startdate, Calendar enddate) {
        PriceDao dao = new PriceDao();
        List<Electrovalence> prices = dao.queryElectrovalence();
        List<PriceItem> priceitems = this.getPriceItems(prices, startdate, enddate);
        ArrayList<EnergyBean> list = new ArrayList<EnergyBean>();
        for (PriceItem price : priceitems) {
            List<EnergyBean> sublist = this.queryDaywithoutPrice(processorKey, serial, price.getStartdate(), price.getEnddate(), true);
            for (EnergyBean bean : sublist) {
                bean.setQueryperiod(2);
                bean.setPrice(price.getPrice());
                list.add(bean);
            }
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public List<EnergyBean> queryHourwithoutPrice(String processorKey, String serial, Calendar startdate0, int starthour, Calendar enddate0, int endhour, boolean queryHistory) {
        startdate = DateUtils.getShortdate(startdate0);
        enddate = DateUtils.getShortdate(enddate0);
        energydao = new EnergyDao();
        list = energydao.queryHour(serial, startdate, starthour, enddate, endhour);
        try {
            processor = null;
            if (!queryHistory) {
                processor = GlobalProcessors.findProcessor(processorKey);
            }
            listindex = 0;
            cal = Calendar.getInstance();
            cal.setTime(startdate.getTime());
            ** GOTO lbl89
            {
                ++listindex;
                do {
                    if (listindex < list.size() && list.get(listindex).getTrandate().before(cal)) continue block4;
                    hour = 0;
                    while (hour < 24) {
                        block28: {
                            found = false;
                            addEmpty = false;
                            if ((cal.compareTo(startdate) != 0 || hour >= starthour) && (cal.compareTo(enddate) != 0 || hour <= endhour)) ** GOTO lbl23
                            break block28;
lbl-1000:
                            // 1 sources

                            {
                                ++listindex;
lbl23:
                                // 2 sources

                                ** while (listindex < list.size() && list.get((int)listindex).getTrandate().compareTo((Calendar)cal) == 0 && list.get((int)listindex).getHour() < hour)
                            }
lbl24:
                            // 1 sources

                            if (listindex < list.size() && list.get(listindex).getTrandate().compareTo(cal) == 0 && list.get(listindex).getHour() == hour) {
                                found = true;
                            }
                            if (listindex < list.size() && !list.get(listindex).isComplete() && processor != null) {
                                list.remove(listindex);
                                found = false;
                            }
                            if (!found && processor != null) {
                                current = processor.getCurrentTime();
                                if (current != null) {
                                    currentonlydate = DateUtils.getShortdate(current);
                                    if (currentonlydate.compareTo(cal) == 0 && hour <= current.get(11) || currentonlydate.compareTo(cal) > 0) {
                                        bean = new EnergyBean();
                                        if (currentonlydate.compareTo(cal) == 0 && current.get(11) == hour) {
                                            bean.setComplete(false);
                                        } else {
                                            bean.setComplete(true);
                                            if (current.get(12) < WebServices.REJECT_MINUTES) {
                                                tempdatetime = (Calendar)current.clone();
                                                tempdatetime.add(11, -1);
                                                temponlydate = DateUtils.getShortdate(tempdatetime);
                                                if (temponlydate.compareTo(cal) == 0 && tempdatetime.get(11) == hour) {
                                                    bean.setComplete(false);
                                                }
                                            }
                                        }
                                        energy = 0.0;
                                        isException = false;
                                        try {
                                            if (!processor.getProtocol().getProtocolID().equals("P1730K")) {
                                                energy = processor.queryEnergyHour(cal, hour);
                                            }
                                        }
                                        catch (Exception ex) {
                                            isException = true;
                                        }
                                        if (this.hourEnergyException(processor, energy)) {
                                            pre = listindex - 1;
                                            if (pre < 0) {
                                                pre = 0;
                                            }
                                            preBean = list.get(pre);
                                            preEnergy = preBean.getQuantity();
                                            energy = VolUtil.round(preEnergy * 1.05, 3);
                                        } else {
                                            energy = VolUtil.round(energy * 0.001, 3);
                                        }
                                        bean.setQueryperiod(3);
                                        bean.setQuantity(energy);
                                        bean.setTrandate((Calendar)cal.clone());
                                        bean.setHour(hour);
                                        if (!isException) {
                                            energydao.insertHour(processor.getProtocol().getProtocolID(), serial, bean);
                                        }
                                        list.add(listindex, bean);
                                    } else {
                                        addEmpty = true;
                                    }
                                } else {
                                    addEmpty = true;
                                }
                            } else if (!found) {
                                addEmpty = true;
                            }
                            if (addEmpty) {
                                bean = new EnergyBean();
                                bean.setQueryperiod(3);
                                bean.setQuantity(0.0);
                                bean.setTrandate((Calendar)cal.clone());
                                bean.setHour(hour);
                                list.add(listindex, bean);
                            }
                        }
                        ++hour;
                    }
                    cal.add(5, 1);
lbl89:
                    // 2 sources

                } while (cal.compareTo(enddate) <= 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<EnergyBean> queryHourwithPrice(String processorKey, String serial, Calendar startdate, int starthour, Calendar enddate, int endhour) {
        List<EnergyBean> list = this.queryHourwithoutPrice(processorKey, serial, startdate, starthour, enddate, endhour, true);
        PriceDao dao = new PriceDao();
        List<Electrovalence> prices = dao.queryElectrovalence();
        List<PriceItem> priceitems = this.getPriceItems(prices, startdate, enddate);
        block0: for (EnergyBean bean : list) {
            for (PriceItem price : priceitems) {
                if (bean.getTrandate().compareTo(price.getStartdate()) < 0 || bean.getTrandate().compareTo(price.getEnddate()) > 0) continue;
                bean.setPrice(price.getPrice());
                continue block0;
            }
        }
        return list;
    }

    public boolean deleteHour(String prodid, String serialno, EnergyBean bean) {
        EnergyDao energydao = new EnergyDao();
        if (energydao.deleteHour(prodid, serialno, bean)) {
            energydao.updateDay(serialno, bean.getTrandate());
            energydao.updateMonth(serialno, bean.getTrandate());
            energydao.updateYear(serialno, bean.getTrandate());
            return true;
        }
        return false;
    }

    public boolean deleteDay(String prodid, String serialno, EnergyBean bean) {
        EnergyDao energydao = new EnergyDao();
        if (energydao.deleteDay(prodid, serialno, bean)) {
            energydao.deleteDayMergeHour(serialno, bean.getTrandate());
            energydao.updateMonth(serialno, bean.getTrandate());
            energydao.updateYear(serialno, bean.getTrandate());
            return true;
        }
        return false;
    }

    public boolean deleteMonth(String prodid, String serialno, MonthEnergy bean) {
        EnergyDao energydao = new EnergyDao();
        if (energydao.deleteMonth(prodid, serialno, bean.getYearmonth())) {
            Calendar trandate = Calendar.getInstance();
            trandate.setTime(DateUtils.parseDate(String.valueOf(bean.getYearmonth()) + "01", "yyyyMMdd"));
            energydao.deleteMonthMergeHour(serialno, trandate);
            energydao.deleteMonthMergeDay(serialno, trandate);
            energydao.updateYear(serialno, trandate);
            return true;
        }
        return false;
    }

    public boolean deleteYear(String prodid, String serialno, YearEnergy bean) {
        EnergyDao energydao = new EnergyDao();
        return energydao.deleteYear(prodid, serialno, bean.getYear());
    }

    public boolean doEnergyBeginDate(String prodid, String serialno, Calendar begindate) {
        boolean result = false;
        EnergyDao dao = new EnergyDao();
        result = dao.queryEnergyBeginDate(serialno) != null ? dao.updateEnergyBeginDate(prodid, serialno, begindate) : dao.insertEnergyBeginDate(prodid, serialno, begindate);
        return result;
    }

    private Calendar getEffectDate(Electrovalence price) {
        Calendar tempdate = Calendar.getInstance();
        tempdate.setTime(price.getEffectdate());
        return tempdate;
    }

    private List<PriceItem> splitPriceItems(Electrovalence price, List<PriceItem> items) {
        ArrayList<PriceItem> result = new ArrayList<PriceItem>();
        int index = 0;
        while (index < items.size()) {
            PriceItem item = items.get(index);
            Calendar effdate = this.getEffectDate(price);
            if (effdate.compareTo(item.getStartdate()) < 0) {
                item.setPrice(price.getPrice());
                result.add(item);
            } else if (effdate.compareTo(item.getEnddate()) > 0) {
                result.add(item);
            } else {
                PriceItem newItem = new PriceItem();
                Calendar newDate = Calendar.getInstance();
                newDate.setTime(effdate.getTime());
                newDate.set(11, 23);
                newDate.set(12, 59);
                newDate.set(13, 59);
                newDate.add(5, -1);
                newItem.setEnddate(newDate);
                newItem.setStartdate(item.getStartdate());
                newItem.setPrice(item.getPrice());
                result.add(newItem);
                item.setStartdate(effdate);
                item.setPrice(price.getPrice());
                result.add(item);
            }
            ++index;
        }
        return result;
    }

    private List<PriceItem> getPriceItems(List<Electrovalence> prices, Calendar startdate, Calendar enddate) {
        startdate.set(11, 0);
        startdate.set(12, 0);
        startdate.set(13, 0);
        enddate.set(11, 23);
        enddate.set(12, 59);
        enddate.set(13, 59);
        PriceItem item = new PriceItem();
        item.setStartdate((Calendar)startdate.clone());
        item.setEnddate((Calendar)enddate.clone());
        item.setPrice(0.0);
        List<PriceItem> list = new ArrayList<PriceItem>();
        list.add(item);
        if (prices == null) {
            return list;
        }
        int index = 0;
        while (index < prices.size()) {
            list = this.splitPriceItems(prices.get(index), list);
            ++index;
        }
        return list;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        String date = GlobalVariables.globalConfig.getDateFormat();
        date = date.equals("YYYY-MM-DD") ? "yyyy-MM-dd" : (date.equals("YYYY/MM/DD") ? "yyyy/MM/dd" : (date.equals("MM-DD-YYYY") ? "MM-dd-yyyy" : (date.equals("MM/DD/YYYY") ? "MM/dd/yyyy" : "yyyy-MM-dd")));
        SimpleDateFormat sdf = new SimpleDateFormat(date);
        return sdf;
    }

    public boolean dayEnergyException(AbstractProcessor processor, double energy) {
        String prodid = processor.getProtocol().getProtocolID();
        if (prodid.equals("P1730K") && energy > 300000.0) {
            return true;
        }
        if (prodid.equals("P17") && energy > 100000.0) {
            return true;
        }
        if (prodid.equals("P175K") && energy > 50000.0) {
            return true;
        }
        if (prodid.equals("P17P1S1") && energy > 30000.0) {
            return true;
        }
        return prodid.equals("P16") && energy > 30000.0;
    }

    public double sumHoursEnergy(String processorKey, String serial, Calendar startdate0, int starthour, Calendar enddate0, int endhour, boolean queryHistory) {
        double currentD = 0.0;
        try {
            List<EnergyBean> hours = this.queryHourwithoutPrice(processorKey, serial, startdate0, starthour, enddate0, endhour, queryHistory);
            for (EnergyBean bean : hours) {
                currentD += bean.getQuantity();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currentD;
    }

    public boolean hourEnergyException(AbstractProcessor processor, double energy) {
        String prodid = processor.getProtocol().getProtocolID();
        if (prodid.equals("P1730K") && energy > 60000.0) {
            return true;
        }
        if (prodid.equals("P17") && energy > 20000.0) {
            return true;
        }
        if (prodid.equals("P175K") && energy > 10000.0) {
            return true;
        }
        if (prodid.equals("P17P1S1") && energy > 10000.0) {
            return true;
        }
        return prodid.equals("P16") && energy > 5000.0;
    }

    public static void main(String[] args) {
        String key = "COM[0]_AAAAAAAAAAAAAA";
        System.out.println(key.split("_")[1]);
    }
}

