/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class DirectFieldAccessor
extends AbstractPropertyAccessor {
    private final Object target;
    private final Map fieldMap = new HashMap();
    private final TypeConverterDelegate typeConverterDelegate;

    public DirectFieldAccessor(Object object) {
        Assert.notNull((Object)object, (String)"Target object must not be null");
        this.target = object;
        ReflectionUtils.doWithFields(this.target.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                DirectFieldAccessor.this.fieldMap.put(field.getName(), field);
            }
        });
        this.typeConverterDelegate = new TypeConverterDelegate(this, object);
        this.setExtractOldValueForEditor(true);
    }

    public boolean isReadableProperty(String string) throws BeansException {
        return this.fieldMap.containsKey(string);
    }

    public boolean isWritableProperty(String string) throws BeansException {
        return this.fieldMap.containsKey(string);
    }

    public Class getPropertyType(String string) throws BeansException {
        Field field = (Field)this.fieldMap.get(string);
        if (field != null) {
            return field.getType();
        }
        return null;
    }

    public Object getPropertyValue(String string) throws BeansException {
        Field field = (Field)this.fieldMap.get(string);
        if (field == null) {
            throw new NotReadablePropertyException(this.target.getClass(), string, "Field '" + string + "' does not exist");
        }
        try {
            ReflectionUtils.makeAccessible((Field)field);
            return field.get(this.target);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidPropertyException(this.target.getClass(), string, "Field is not accessible", illegalAccessException);
        }
    }

    public void setPropertyValue(String string, Object object) throws BeansException {
        Field field = (Field)this.fieldMap.get(string);
        if (field == null) {
            throw new NotWritablePropertyException(this.target.getClass(), string, "Field '" + string + "' does not exist");
        }
        Object object2 = null;
        try {
            ReflectionUtils.makeAccessible((Field)field);
            object2 = field.get(this.target);
            Object object3 = this.typeConverterDelegate.convertIfNecessary(string, object2, object, field.getType());
            field.set(this.target, object3);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidPropertyException(this.target.getClass(), string, "Field is not accessible", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.target, string, object2, object);
            throw new TypeMismatchException(propertyChangeEvent, field.getType(), (Throwable)illegalArgumentException);
        }
    }
}

