/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.util.StringUtils;

public class PropertyPathFactoryBean
implements FactoryBean,
BeanNameAware,
BeanFactoryAware {
    private BeanWrapper targetBeanWrapper;
    private String targetBeanName;
    private String propertyPath;
    private Class resultType;
    private String beanName;
    private BeanFactory beanFactory;

    public void setTargetObject(Object object) {
        this.targetBeanWrapper = new BeanWrapperImpl(object);
    }

    public void setTargetBeanName(String string) {
        this.targetBeanName = StringUtils.trimAllWhitespace((String)string);
    }

    public void setPropertyPath(String string) {
        this.propertyPath = StringUtils.trimAllWhitespace((String)string);
    }

    public void setResultType(Class clazz) {
        this.resultType = clazz;
    }

    public void setBeanName(String string) {
        this.beanName = StringUtils.trimAllWhitespace((String)BeanFactoryUtils.originalBeanName(string));
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        if (this.targetBeanWrapper != null && this.targetBeanName != null) {
            throw new IllegalArgumentException("Specify either targetObject or targetBeanName, not both");
        }
        if (this.targetBeanWrapper == null && this.targetBeanName == null) {
            if (this.propertyPath != null) {
                throw new IllegalArgumentException("Specify targetObject or targetBeanName in combination with propertyPath");
            }
            int n = this.beanName.indexOf(46);
            if (n == -1) {
                throw new IllegalArgumentException("Neither targetObject nor targetBeanName specified, and PropertyPathFactoryBean bean name '" + this.beanName + "' does not follow 'beanName.property' syntax");
            }
            this.targetBeanName = this.beanName.substring(0, n);
            this.propertyPath = this.beanName.substring(n + 1);
        } else if (this.propertyPath == null) {
            throw new IllegalArgumentException("propertyPath is required");
        }
        if (this.targetBeanWrapper == null && this.beanFactory.isSingleton(this.targetBeanName)) {
            this.targetBeanWrapper = new BeanWrapperImpl(this.beanFactory.getBean(this.targetBeanName));
            this.resultType = this.targetBeanWrapper.getPropertyType(this.propertyPath);
        }
    }

    public Object getObject() throws BeansException {
        Object object;
        BeanWrapper beanWrapper = this.targetBeanWrapper;
        if (beanWrapper == null) {
            beanWrapper = new BeanWrapperImpl(this.beanFactory.getBean(this.targetBeanName));
        }
        if ((object = beanWrapper.getPropertyValue(this.propertyPath)) == null) {
            throw new FatalBeanException("PropertyPathFactoryBean is not allowed to return null, but property value for path '" + this.propertyPath + "' is null");
        }
        return object;
    }

    public Class getObjectType() {
        return this.resultType;
    }

    public boolean isSingleton() {
        return false;
    }
}

