/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;

class BeanDefinitionValueResolver {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";
    private final AbstractBeanFactory beanFactory;
    private final String beanName;
    private final BeanDefinition beanDefinition;
    private final TypeConverter typeConverter;

    public BeanDefinitionValueResolver(AbstractBeanFactory abstractBeanFactory, String string, BeanDefinition beanDefinition, TypeConverter typeConverter) {
        this.beanFactory = abstractBeanFactory;
        this.beanName = string;
        this.beanDefinition = beanDefinition;
        this.typeConverter = typeConverter;
    }

    public Object resolveValueIfNecessary(String string, Object object) {
        if (object instanceof RuntimeBeanReference) {
            RuntimeBeanReference runtimeBeanReference = (RuntimeBeanReference)object;
            return this.resolveReference(string, runtimeBeanReference);
        }
        if (object instanceof RuntimeBeanNameReference) {
            String string2 = ((RuntimeBeanNameReference)object).getBeanName();
            if (!this.beanFactory.containsBean(string2)) {
                throw new BeanDefinitionStoreException("Invalid bean name '" + string2 + "' in bean reference for " + string);
            }
            return string2;
        }
        if (object instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder beanDefinitionHolder = (BeanDefinitionHolder)object;
            return this.resolveInnerBean(string, beanDefinitionHolder.getBeanName(), beanDefinitionHolder.getBeanDefinition());
        }
        if (object instanceof BeanDefinition) {
            BeanDefinition beanDefinition = (BeanDefinition)object;
            return this.resolveInnerBean(string, "(inner bean)", beanDefinition);
        }
        if (object instanceof ManagedList) {
            return this.resolveManagedList(string, (List)object);
        }
        if (object instanceof ManagedSet) {
            return this.resolveManagedSet(string, (Set)object);
        }
        if (object instanceof ManagedMap) {
            return this.resolveManagedMap(string, (Map)object);
        }
        if (object instanceof ManagedProperties) {
            Properties properties = (Properties)object;
            Properties properties2 = new Properties();
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                Object object2 = entry.getKey();
                Object object3 = entry.getValue();
                if (object2 instanceof TypedStringValue) {
                    object2 = ((TypedStringValue)object2).getValue();
                }
                if (object3 instanceof TypedStringValue) {
                    object3 = ((TypedStringValue)object3).getValue();
                }
                properties2.put(object2, object3);
            }
            return properties2;
        }
        if (object instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)object;
            try {
                Class clazz = this.resolveTargetType(typedStringValue);
                if (clazz != null) {
                    return this.typeConverter.convertIfNecessary(typedStringValue.getValue(), clazz, null);
                }
                return typedStringValue.getValue();
            }
            catch (Throwable throwable) {
                throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error converting typed String value for " + string, throwable);
            }
        }
        return object;
    }

    protected Class resolveTargetType(TypedStringValue typedStringValue) throws ClassNotFoundException {
        if (typedStringValue.hasTargetType()) {
            return typedStringValue.getTargetType();
        }
        return typedStringValue.resolveTargetType(this.beanFactory.getBeanClassLoader());
    }

    private Object resolveInnerBean(String string, String string2, BeanDefinition beanDefinition) {
        RootBeanDefinition rootBeanDefinition = null;
        try {
            rootBeanDefinition = this.beanFactory.getMergedBeanDefinition(string2, beanDefinition, this.beanDefinition);
            String string3 = string2;
            if (rootBeanDefinition.isSingleton()) {
                string3 = this.adaptInnerBeanName(string2);
            }
            Object object = this.beanFactory.createBean(string3, rootBeanDefinition, null);
            if (rootBeanDefinition.isSingleton()) {
                this.beanFactory.registerDependentBean(string3, this.beanName);
            }
            return this.beanFactory.getObjectForBeanInstance(object, string3, rootBeanDefinition);
        }
        catch (BeansException beansException) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot create inner bean '" + string2 + "' " + (rootBeanDefinition != null && rootBeanDefinition.getBeanClassName() != null ? "of type [" + rootBeanDefinition.getBeanClassName() + "] " : "") + "while setting " + string, (Throwable)((Object)beansException));
        }
    }

    private String adaptInnerBeanName(String string) {
        String string2 = string;
        int n = 0;
        while (this.beanFactory.isBeanNameInUse(string2)) {
            string2 = string + GENERATED_BEAN_NAME_SEPARATOR + ++n;
        }
        return string2;
    }

    private Object resolveReference(String string, RuntimeBeanReference runtimeBeanReference) {
        try {
            if (runtimeBeanReference.isToParent()) {
                if (this.beanFactory.getParentBeanFactory() == null) {
                    throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Can't resolve reference to bean '" + runtimeBeanReference.getBeanName() + "' in parent factory: no parent factory available");
                }
                return this.beanFactory.getParentBeanFactory().getBean(runtimeBeanReference.getBeanName());
            }
            Object object = this.beanFactory.getBean(runtimeBeanReference.getBeanName());
            if (this.beanDefinition.isSingleton()) {
                this.beanFactory.registerDependentBean(runtimeBeanReference.getBeanName(), this.beanName);
            }
            return object;
        }
        catch (BeansException beansException) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot resolve reference to bean '" + runtimeBeanReference.getBeanName() + "' while setting " + string, (Throwable)((Object)beansException));
        }
    }

    private List resolveManagedList(String string, List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.resolveValueIfNecessary(string + " with key " + "[" + i + "]", list.get(i)));
        }
        return arrayList;
    }

    private Set resolveManagedSet(String string, Set set) {
        Set set2 = CollectionFactory.createLinkedSetIfPossible((int)set.size());
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            set2.add(this.resolveValueIfNecessary(string + " with key " + "[" + n + "]", iterator.next()));
            ++n;
        }
        return set2;
    }

    private Map resolveManagedMap(String string, Map map) {
        Map map2 = CollectionFactory.createLinkedMapIfPossible((int)map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object object = this.resolveValueIfNecessary(string, entry.getKey());
            Object object2 = this.resolveValueIfNecessary(string + " with key " + "[" + entry.getKey() + "]", entry.getValue());
            map2.put(object, object2);
        }
        return map2;
    }
}

