/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.core.CollectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultSingletonBeanRegistry
implements SingletonBeanRegistry {
    private static final Object NULL_OBJECT = new Object();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map singletonObjects = CollectionFactory.createConcurrentMapIfPossible((int)16);
    private final Set registeredSingletons = CollectionFactory.createLinkedSetIfPossible((int)16);
    private final Set singletonsCurrentlyInCreation = Collections.synchronizedSet(new HashSet());
    private boolean singletonsCurrentlyInDestruction = false;
    private final Map disposableBeans = CollectionFactory.createLinkedMapIfPossible((int)16);
    private final Map dependentBeanMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSingleton(String string, Object object) throws IllegalStateException {
        Assert.notNull((Object)string, (String)"'beanName' must not be null");
        Map map = this.singletonObjects;
        synchronized (map) {
            Object v = this.singletonObjects.get(string);
            if (v != null) {
                throw new IllegalStateException("Could not register object [" + object + "] under bean name '" + string + "': there is already object [" + v + "] bound");
            }
            this.addSingleton(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSingleton(String string, Object object) {
        Map map = this.singletonObjects;
        synchronized (map) {
            this.singletonObjects.put(string, object != null ? object : NULL_OBJECT);
            this.registeredSingletons.add(string);
        }
    }

    public Object getSingleton(String string) {
        Assert.notNull((Object)string, (String)"'beanName' must not be null");
        Object v = this.singletonObjects.get(string);
        return v != NULL_OBJECT ? v : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingleton(String string, ObjectFactory objectFactory) {
        Assert.notNull((Object)string, (String)"'beanName' must not be null");
        Map map = this.singletonObjects;
        synchronized (map) {
            Object object = this.singletonObjects.get(string);
            if (object == null) {
                if (this.singletonsCurrentlyInDestruction) {
                    throw new BeanCreationNotAllowedException(string, "Singleton bean creation not allowed while the singletons of this factory are in destruction (Do not request a bean from a BeanFactory in a destroy method implementation!)");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating shared instance of singleton bean '" + string + "'"));
                }
                this.beforeSingletonCreation(string);
                try {
                    object = objectFactory.getObject();
                }
                finally {
                    this.afterSingletonCreation(string);
                }
                this.addSingleton(string, object);
            }
            return object != NULL_OBJECT ? object : null;
        }
    }

    protected void removeSingleton(String string) {
        Assert.notNull((Object)string, (String)"'beanName' must not be null");
        this.singletonObjects.remove(string);
        this.registeredSingletons.remove(string);
    }

    public boolean containsSingleton(String string) {
        Assert.notNull((Object)string, (String)"'beanName' must not be null");
        return this.singletonObjects.containsKey(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSingletonNames() {
        Map map = this.singletonObjects;
        synchronized (map) {
            return StringUtils.toStringArray((Collection)this.registeredSingletons);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSingletonCount() {
        Map map = this.singletonObjects;
        synchronized (map) {
            return this.registeredSingletons.size();
        }
    }

    protected void beforeSingletonCreation(String string) {
        if (!this.singletonsCurrentlyInCreation.add(string)) {
            throw new BeanCurrentlyInCreationException(string);
        }
    }

    protected void afterSingletonCreation(String string) {
        if (!this.singletonsCurrentlyInCreation.remove(string)) {
            throw new IllegalStateException("Singleton '" + string + "' isn't currently in creation");
        }
    }

    public final boolean isSingletonCurrentlyInCreation(String string) {
        return this.singletonsCurrentlyInCreation.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDisposableBean(String string, DisposableBean disposableBean) {
        Map map = this.disposableBeans;
        synchronized (map) {
            this.disposableBeans.put(string, disposableBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDependentBean(String string, String string2) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            Set set = (Set)this.dependentBeanMap.get(string);
            if (set == null) {
                set = CollectionFactory.createLinkedSetIfPossible((int)8);
                this.dependentBeanMap.put(string, set);
            }
            set.add(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasDependentBean(String string) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            return this.dependentBeanMap.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getDependentBeans(String string) {
        Map map = this.dependentBeanMap;
        synchronized (map) {
            return Collections.unmodifiableSet((Set)this.dependentBeanMap.get(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingletons() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Destroying singletons in " + this));
        }
        Map map = this.singletonObjects;
        synchronized (map) {
            this.singletonsCurrentlyInDestruction = true;
        }
        map = this.disposableBeans;
        synchronized (map) {
            String[] stringArray = StringUtils.toStringArray(this.disposableBeans.keySet());
            for (int i = stringArray.length - 1; i >= 0; --i) {
                this.destroySingleton(stringArray[i]);
            }
        }
        map = this.singletonObjects;
        synchronized (map) {
            this.singletonObjects.clear();
            this.registeredSingletons.clear();
            this.singletonsCurrentlyInDestruction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySingleton(String string) {
        Object object = this.singletonObjects;
        synchronized (object) {
            this.removeSingleton(string);
        }
        object = null;
        Map map = this.disposableBeans;
        synchronized (map) {
            object = (DisposableBean)this.disposableBeans.remove(string);
        }
        this.destroyBean(string, (DisposableBean)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyBean(String string, DisposableBean disposableBean) {
        Set set = null;
        Object object = this.dependentBeanMap;
        synchronized (object) {
            set = (Set)this.dependentBeanMap.remove(string);
        }
        if (set != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieved dependent beans for bean '" + string + "': " + set));
            }
            object = set.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                this.destroySingleton(string2);
            }
        }
        if (disposableBean != null) {
            try {
                disposableBean.destroy();
            }
            catch (Throwable throwable) {
                this.logger.error((Object)("Destroy method on bean with name '" + string + "' threw an exception"), throwable);
            }
        }
    }

    protected final Object getSingletonMutex() {
        return this.singletonObjects;
    }
}

