/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class BeansDtdResolver
implements EntityResolver {
    private static final String DTD_EXTENSION = ".dtd";
    private static final String[] DTD_NAMES = new String[]{"spring-beans-2.0", "spring-beans"};
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$beans$factory$xml$BeansDtdResolver == null ? (class$org$springframework$beans$factory$xml$BeansDtdResolver = BeansDtdResolver.class$("org.springframework.beans.factory.xml.BeansDtdResolver")) : class$org$springframework$beans$factory$xml$BeansDtdResolver));
    static /* synthetic */ Class class$org$springframework$beans$factory$xml$BeansDtdResolver;

    public InputSource resolveEntity(String string, String string2) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Trying to resolve XML entity with public ID [" + string + "] and system ID [" + string2 + "]"));
        }
        if (string2 != null && string2.endsWith(DTD_EXTENSION)) {
            int n = string2.lastIndexOf("/");
            for (int i = 0; i < DTD_NAMES.length; ++i) {
                int n2 = string2.indexOf(DTD_NAMES[i]);
                if (n2 <= n) continue;
                String string3 = string2.substring(n2);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Trying to locate [" + string3 + "] in Spring jar"));
                }
                try {
                    ClassPathResource classPathResource = new ClassPathResource(string3, this.getClass());
                    InputSource inputSource = new InputSource(classPathResource.getInputStream());
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found beans DTD [" + string2 + "] in classpath: " + string3));
                    }
                    return inputSource;
                }
                catch (IOException iOException) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Could not resolve beans DTD [" + string2 + "]: not found in class path"), (Throwable)iOException);
                }
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

