/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class StringArrayPropertyEditor
extends PropertyEditorSupport {
    public static final String DEFAULT_SEPARATOR = ",";
    private final String separator;

    public StringArrayPropertyEditor() {
        this.separator = DEFAULT_SEPARATOR;
    }

    public StringArrayPropertyEditor(String string) {
        this.separator = string;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        String[] stringArray = StringUtils.delimitedListToStringArray((String)string, (String)this.separator);
        this.setValue(stringArray);
    }

    public String getAsText() {
        Object[] objectArray = (String[])this.getValue();
        return StringUtils.arrayToDelimitedString((Object[])objectArray, (String)this.separator);
    }
}

