/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.softeutil;

import java.io.File;

public class UpgradeConstants {
    public static String BACKUPSTR = String.valueOf(System.getProperty("user.dir")) + File.separator + "BackupFiles";
    public static final String OS_NAME = UpgradeConstants.getSystemProperty("os.name");
    public static final boolean IS_OS_MAC = UpgradeConstants.getOSMatches("Mac");
    public static final boolean IS_OS_WINDOWS = UpgradeConstants.getOSMatches("Windows");
    public static final boolean IS_OS_MAC_OSX = UpgradeConstants.getOSMatches("Mac OS X");
    public static final boolean IS_OS_LINUX = UpgradeConstants.getOSMatches("Linux") || UpgradeConstants.getOSMatches("LINUX");
    public static final boolean IS_OS_SOLARIS = UpgradeConstants.getOSMatches("Solaris") || UpgradeConstants.getOSMatches("SunOS");

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("Caught a SecurityException reading the system property '" + property + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    private static boolean getOSMatches(String osNamePrefix) {
        if (OS_NAME == null) {
            return false;
        }
        return OS_NAME.startsWith(osNamePrefix);
    }
}

