/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.hifi;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.hifi.HiFiUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;

public class HiFiTabbedPaneUI
extends BaseTabbedPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new HiFiTabbedPaneUI();
    }

    protected Color[] getContentBorderColors(int n) {
        Color[] colorArray = new Color[]{ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0), ColorHelper.brighter(AbstractLookAndFeel.getBackgroundColor(), 20.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 20.0), ColorHelper.darker(AbstractLookAndFeel.getBackgroundColor(), 40.0)};
        return colorArray;
    }

    protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
        graphics.setFont(font);
        View view = this.getTextViewForTab(n2);
        if (view != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            view.paint(graphics, rectangle);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        } else {
            int n3 = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                n3 = this.tabPane.getDisplayedMnemonicIndexAt(n2);
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.6f);
            graphics2D.setComposite(alphaComposite);
            Color color = this.tabPane.getForegroundAt(n2);
            if (bl) {
                color = AbstractLookAndFeel.getTheme().getButtonForegroundColor();
            }
            if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n2)) {
                color = AbstractLookAndFeel.getTheme().getDisabledForegroundColor();
            }
            if (ColorHelper.getGrayValue(color) > 128) {
                graphics2D.setColor(Color.black);
            } else {
                graphics2D.setColor(Color.white);
            }
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
            graphics2D.setComposite(composite);
            graphics2D.setColor(color);
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, graphics, string, n3, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        HiFiUtils.fillComponent(graphics, this.tabPane);
        super.paintContentBorder(graphics, n, n2, n3, n4, n5, n6);
    }

    protected void paintRoundedTopTabBorder(int n, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl) {
        super.paintRoundedTopTabBorder(n, graphics, n2, n3, n4, n5, bl);
        graphics.setColor(this.tabAreaBackground);
        graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1);
        graphics.drawLine(n4 - 1, n3 + 1, n4 - 1, n3 + 1);
    }
}

