/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import javax.swing.plaf.UIResource;
import sun.security.action.LoadLibraryAction;

public class AquaNativeResources {
    static final AquaUtils.RecyclableSingleton<Color> sBackgroundColor;

    private static native long getWindowBackgroundColor();

    public static Color getWindowBackgroundColorUIResource() {
        return sBackgroundColor.get();
    }

    static BufferedImage getRadioButtonSizerImage() {
        BufferedImage bufferedImage = new BufferedImage(20, 20, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.pink);
        graphics.fillRect(0, 0, 20, 20);
        return bufferedImage;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("osxui"));
        sBackgroundColor = new AquaUtils.RecyclableSingleton<Color>(){

            @Override
            protected Color getInstance() {
                long l = AquaNativeResources.getWindowBackgroundColor();
                return new CColorPaintUIResource(l, 238, 238, 238, 255);
            }
        };
    }

    static class CColorPaintUIResource
    extends Color
    implements UIResource {
        public CColorPaintUIResource(long l, int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }
    }
}

